/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.result;

import com.yahoo.data.JsonProducer;
import com.yahoo.data.access.Inspectable;
import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.Type;
import com.yahoo.data.access.simple.JsonRender;
import com.yahoo.data.access.simple.Value;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.serialization.JsonFormat;
import com.yahoo.tensor.serialization.TypedBinaryFormat;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class FeatureData
implements Inspectable,
JsonProducer {
    private static final FeatureData empty = new FeatureData(Value.empty());
    private final Inspector encodedValues;
    private Map<String, Tensor> values = null;
    private Set<String> featureNames = null;

    public FeatureData(Inspector encodedValues) {
        this.encodedValues = Objects.requireNonNull(encodedValues);
    }

    public FeatureData(Map<String, Tensor> values) {
        this.encodedValues = null;
        this.values = values;
    }

    public static FeatureData empty() {
        return empty;
    }

    public Inspector inspect() {
        if (this.encodedValues == null) {
            throw new IllegalStateException("FeatureData not created from an inspector cannot be inspected");
        }
        return this.encodedValues;
    }

    @Override
    public String toJson() {
        return this.toJson(new JsonFormat.EncodeOptions());
    }

    public String toJson(boolean tensorShortForm) {
        return this.toJson(new JsonFormat.EncodeOptions(tensorShortForm));
    }

    public String toJson(boolean tensorShortForm, boolean tensorDirectValues) {
        return this.toJson(new JsonFormat.EncodeOptions(tensorShortForm, tensorDirectValues));
    }

    public String toJson(JsonFormat.EncodeOptions tensorOptions) {
        return this.writeJson(tensorOptions, new StringBuilder()).toString();
    }

    @Override
    public StringBuilder writeJson(StringBuilder target) {
        return this.writeJson(new JsonFormat.EncodeOptions(false, false, false), target);
    }

    private StringBuilder writeJson(JsonFormat.EncodeOptions tensorOptions, StringBuilder target) {
        if (this == empty) {
            return target.append("{}");
        }
        if (this.encodedValues != null) {
            return JsonRender.render((Inspectable)this.encodedValues, (JsonRender.StringEncoder)new Encoder(target, true, tensorOptions));
        }
        return this.writeJson(this.values, tensorOptions, target);
    }

    private StringBuilder writeJson(Map<String, Tensor> values, JsonFormat.EncodeOptions tensorOptions, StringBuilder target) {
        target.append("{");
        for (Map.Entry<String, Tensor> entry : values.entrySet()) {
            target.append("\"").append(entry.getKey()).append("\":");
            if (entry.getValue().type().rank() == 0) {
                target.append(entry.getValue().asDouble());
            } else {
                byte[] encodedTensor = JsonFormat.encode((Tensor)entry.getValue(), (JsonFormat.EncodeOptions)tensorOptions);
                target.append(new String(encodedTensor, StandardCharsets.UTF_8));
            }
            target.append(",");
        }
        if (!values.isEmpty()) {
            target.setLength(target.length() - 1);
        }
        target.append("}");
        return target;
    }

    public Double getDouble(String featureName) {
        Tensor value = this.getTensor(featureName);
        return value == null ? null : Double.valueOf(value.asDouble());
    }

    public Tensor getTensor(String featureName) {
        Tensor value;
        if (this.values == null) {
            this.values = new HashMap<String, Tensor>();
        }
        if ((value = this.values.get(featureName)) != null) {
            return value;
        }
        if (this.encodedValues != null) {
            value = this.decodeTensor(featureName);
        }
        if (value != null) {
            this.values.put(featureName, value);
        }
        return value;
    }

    private Tensor decodeTensor(String featureName) {
        Inspector featureValue = this.getInspector(featureName);
        if (!featureValue.valid()) {
            return null;
        }
        return switch (featureValue.type()) {
            case Type.DOUBLE -> Tensor.from((double)featureValue.asDouble());
            case Type.DATA -> FeatureData.tensorFromData(featureValue.asData());
            default -> throw new IllegalStateException("Unexpected feature value type " + featureValue.type());
        };
    }

    private Inspector getInspector(String featureName) {
        Inspector featureValue = this.encodedValues.field(featureName);
        if (featureValue.valid()) {
            return featureValue;
        }
        return this.encodedValues.field(Reference.wrapInRankingExpression((String)featureName));
    }

    public Set<String> featureNames() {
        if (this == empty) {
            return Set.of();
        }
        if (this.featureNames != null) {
            return this.featureNames;
        }
        if (this.encodedValues == null) {
            return this.values.keySet();
        }
        this.featureNames = new LinkedHashSet<String>();
        this.encodedValues.fields().forEach(field -> this.featureNames.add((String)field.getKey()));
        return this.featureNames;
    }

    public String toString() {
        if (this.encodedValues != null && this.encodedValues.type() == Type.EMPTY) {
            return "";
        }
        return this.toJson();
    }

    public int hashCode() {
        return this.toJson().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FeatureData)) {
            return false;
        }
        return ((FeatureData)other).toJson().equals(this.toJson());
    }

    private static Tensor tensorFromData(byte[] value) {
        return TypedBinaryFormat.decode(Optional.empty(), (GrowableByteBuffer)GrowableByteBuffer.wrap((byte[])value));
    }

    private static class Encoder
    extends JsonRender.StringEncoder {
        private final JsonFormat.EncodeOptions tensorOptions;

        Encoder(StringBuilder out, boolean compact, JsonFormat.EncodeOptions tensorOptions) {
            super(out, compact);
            this.tensorOptions = tensorOptions;
        }

        public void encodeDATA(byte[] value) {
            Tensor tensor = FeatureData.tensorFromData(value);
            byte[] encodedTensor = JsonFormat.encode((Tensor)tensor, (JsonFormat.EncodeOptions)this.tensorOptions);
            this.target().append(new String(encodedTensor, StandardCharsets.UTF_8));
        }
    }
}

