/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.querytransform;

import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.FalseItem;
import com.yahoo.prelude.query.IntItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.Limit;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.yolean.chain.After;
import com.yahoo.yolean.chain.Before;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;

@Before(value={"queryCanonicalization"})
@After(value={"transformedQuery"})
public class RangeQueryOptimizer
extends Searcher {
    @Override
    public Result search(Query query, Execution execution) {
        if (execution.context().getIndexFacts() == null) {
            return execution.search(query);
        }
        boolean optimized = this.recursiveOptimize(query.getModel().getQueryTree(), execution.context().getIndexFacts().newSession(query));
        if (optimized) {
            query.trace("Optimized query ranges", true, 2);
        }
        return execution.search(query);
    }

    private boolean recursiveOptimize(Item item, IndexFacts.Session indexFacts) {
        if (!(item instanceof CompositeItem)) {
            return false;
        }
        boolean optimized = false;
        ListIterator<Item> i = ((CompositeItem)item).getItemIterator();
        while (i.hasNext()) {
            optimized |= this.recursiveOptimize((Item)i.next(), indexFacts);
        }
        if (item instanceof AndItem) {
            optimized |= this.optimizeAnd((AndItem)item, indexFacts);
        }
        return optimized;
    }

    private boolean optimizeAnd(AndItem and, IndexFacts.Session indexFacts) {
        ArrayList<FieldRange> fieldRanges = null;
        ListIterator<Item> i = and.getItemIterator();
        while (i.hasNext()) {
            Optional<FieldRange> compatibleRange;
            IntItem intItem;
            Item item = (Item)i.next();
            if (!(item instanceof IntItem) || (intItem = (IntItem)item).getHitLimit() != 0 || intItem.getFromLimit().equals(intItem.getToLimit()) || indexFacts.getIndex(intItem.getIndexName()).isMultivalue()) continue;
            if (fieldRanges == null) {
                fieldRanges = new ArrayList<FieldRange>();
            }
            if ((compatibleRange = this.findCompatibleRange(intItem, fieldRanges)).isPresent()) {
                compatibleRange.get().addRange(intItem);
            } else {
                fieldRanges.add(new FieldRange(intItem));
            }
            i.remove();
        }
        if (fieldRanges == null) {
            return false;
        }
        boolean optimized = false;
        for (FieldRange fieldRange : fieldRanges) {
            and.addItem(fieldRange.toItem());
            optimized |= fieldRange.isOptimization();
        }
        return optimized;
    }

    private Optional<FieldRange> findCompatibleRange(IntItem item, List<FieldRange> fieldRanges) {
        for (FieldRange fieldRange : fieldRanges) {
            if (!fieldRange.isCompatibleWith(item)) continue;
            return Optional.of(fieldRange);
        }
        return Optional.empty();
    }

    private static final class FieldRange {
        private Range range = new Range(new Limit(Double.NEGATIVE_INFINITY, false), new Limit(Double.POSITIVE_INFINITY, false));
        private int sourceRangeCount = 0;
        private final String indexName;
        private final Item.ItemCreator creator;
        private final boolean ranked;
        private final int weight;

        public FieldRange(IntItem item) {
            this.indexName = item.getIndexName();
            this.creator = item.getCreator();
            this.ranked = item.isRanked();
            this.weight = item.getWeight();
            this.addRange(item);
        }

        public String getIndexName() {
            return this.indexName;
        }

        public boolean isCompatibleWith(IntItem item) {
            if (!this.indexName.equals(item.getIndexName())) {
                return false;
            }
            if (this.creator != item.getCreator()) {
                return false;
            }
            if (this.ranked != item.isRanked()) {
                return false;
            }
            return this.weight == item.getWeight();
        }

        public void addRange(IntItem item) {
            this.range = this.range.intersection(new Range(item));
            ++this.sourceRangeCount;
        }

        public Item toItem() {
            Item item = this.range.toItem(this.indexName);
            item.setCreator(this.creator);
            item.setRanked(this.ranked);
            item.setWeight(this.weight);
            return item;
        }

        public boolean isOptimization() {
            return this.sourceRangeCount > 1;
        }
    }

    private static class EmptyRange
    extends Range {
        public EmptyRange() {
            super(new Limit(0, false), new Limit(0, false));
        }

        @Override
        public boolean overlaps(Range other) {
            return false;
        }

        @Override
        public Range intersection(Range other) {
            return this;
        }

        @Override
        public Item toItem(String fieldName) {
            return new FalseItem();
        }

        @Override
        public String toString() {
            return "(empty)";
        }
    }

    private static class Range {
        private final Limit from;
        private final Limit to;
        private static final Range empty = new EmptyRange();

        public Range(Limit from, Limit to) {
            this.from = from;
            this.to = to;
        }

        public Range(IntItem range) {
            this.from = range.getFromLimit();
            this.to = range.getToLimit();
        }

        public boolean overlaps(Range other) {
            if (other.from.isSmallerOrEqualTo(this.to) && other.to.isLargerOrEqualTo(this.from)) {
                return true;
            }
            return other.to.isLargerOrEqualTo(this.from) && other.from.isSmallerOrEqualTo(this.to);
        }

        public Range intersection(Range other) {
            if (!this.overlaps(other)) {
                return empty;
            }
            return new Range(this.from.max(other.from), this.to.min(other.to));
        }

        public Item toItem(String fieldName) {
            return IntItem.from(fieldName, this.from, this.to, 0);
        }

        public String toString() {
            return "[" + this.from + ";" + this.to + "]";
        }
    }
}

