/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.textserialize.item;

import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NearItem;
import com.yahoo.search.query.textserialize.item.CompositeConverter;
import com.yahoo.search.query.textserialize.item.ItemArguments;
import com.yahoo.search.query.textserialize.item.ItemContext;
import com.yahoo.search.query.textserialize.item.TypeCheck;
import com.yahoo.search.query.textserialize.serializer.DispatchForm;
import com.yahoo.search.query.textserialize.serializer.ItemIdMapper;

public class NearConverter
extends CompositeConverter {
    private final String distanceProperty = "distance";

    public NearConverter(Class<? extends NearItem> nearItemClass) {
        super(nearItemClass);
    }

    @Override
    public Object formToItem(String name, ItemArguments arguments, ItemContext itemContext) {
        NearItem nearItem = (NearItem)super.formToItem(name, arguments, itemContext);
        this.setDistance(nearItem, arguments);
        return nearItem;
    }

    private void setDistance(NearItem nearItem, ItemArguments arguments) {
        Object distance = arguments.properties.get("distance");
        if (distance != null) {
            TypeCheck.ensureInteger(distance);
            nearItem.setDistance(((Number)distance).intValue());
        }
    }

    @Override
    public DispatchForm itemToForm(Item item, ItemIdMapper itemIdMapper) {
        DispatchForm dispatchForm = super.itemToForm(item, itemIdMapper);
        NearItem nearItem = (NearItem)item;
        dispatchForm.setProperty("distance", nearItem.getDistance());
        return dispatchForm;
    }
}

