/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.rewrite.rewriters;

import com.yahoo.component.ComponentId;
import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.fsa.FSA;
import com.yahoo.prelude.querytransform.PhraseMatcher;
import com.yahoo.search.Query;
import com.yahoo.search.query.rewrite.QueryRewriteSearcher;
import com.yahoo.search.query.rewrite.RewriterFeatures;
import com.yahoo.search.query.rewrite.RewriterUtils;
import com.yahoo.search.query.rewrite.RewritesConfig;
import java.io.File;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;

@Provides(value={"GenericExpansionRewriter"})
public class GenericExpansionRewriter
extends QueryRewriteSearcher {
    private final boolean SKIP_REWRITER_IF_REWRITTEN = false;
    public static final String REWRITER_NAME = "GenericExpansionRewriter";
    public static final String GENERIC_EXPAND_DICT = "GenericExpansion";
    public static final String GENERIC_EXPAND_DICT_FILENAME = "GenericExpansionRewriter.fsa";
    private PhraseMatcher phraseMatcher;
    private Logger logger;

    @Inject
    public GenericExpansionRewriter(ComponentId id, FileAcquirer fileAcquirer, RewritesConfig config) {
        super(id, fileAcquirer, config);
    }

    public GenericExpansionRewriter(RewritesConfig config, HashMap<String, File> fileList) {
        super(config, fileList);
    }

    @Override
    public boolean configure(FileAcquirer fileAcquirer, RewritesConfig config, HashMap<String, File> fileList) {
        this.logger = Logger.getLogger(GenericExpansionRewriter.class.getName());
        FSA fsa = (FSA)this.rewriterDicts.get(GENERIC_EXPAND_DICT);
        if (fsa == null) {
            RewriterUtils.error(this.logger, "Error retrieving FSA dictionary: GenericExpansion");
            return false;
        }
        RewriterUtils.log(this.logger, "Creating PhraseMatcher");
        try {
            this.phraseMatcher = new PhraseMatcher(fsa, false);
        }
        catch (IllegalArgumentException e) {
            RewriterUtils.error(this.logger, "Error creating phrase matcher");
            return false;
        }
        this.phraseMatcher.setMatchSingleItems(true);
        this.phraseMatcher.setMatchAll(true);
        return true;
    }

    @Override
    public HashMap<String, Object> rewrite(Query query, String dictKey) throws RuntimeException {
        Set<PhraseMatcher.Phrase> matches;
        Boolean rewritten = false;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("Rewritten", rewritten);
        result.put("DictKey", dictKey);
        RewriterUtils.log(this.logger, query, "In GenericExpansionRewriter, query used for dict retrieval=[" + dictKey + "]");
        String partialPhraseMatch = this.getQPConfig(query, "PartialPhraseMatch");
        if (partialPhraseMatch == null) {
            RewriterUtils.error(this.logger, query, "Required param PartialPhraseMatch is not set, skipping rewriter");
            throw new RuntimeException("Required param PartialPhraseMatch is not set, skipping rewriter");
        }
        int maxNumRewrites = 0;
        String maxNumRewritesStr = this.getQPConfig(query, "MaxRewrites");
        if (maxNumRewritesStr != null) {
            maxNumRewrites = Integer.parseInt(maxNumRewritesStr);
            RewriterUtils.log(this.logger, query, "Limiting max number of rewrites to: " + maxNumRewrites);
        } else {
            RewriterUtils.log(this.logger, query, "No limit on number of rewrites");
        }
        String rewritesAsUnitEquiv = this.getQPConfig(query, "RewritesAsUnitEquiv");
        if (rewritesAsUnitEquiv == null) {
            rewritesAsUnitEquiv = "false";
        }
        if (partialPhraseMatch.equalsIgnoreCase("true")) {
            RewriterUtils.log(this.logger, query, "Partial phrase matching");
            matches = RewriterFeatures.getNonOverlappingPartialPhraseMatches(this.phraseMatcher, query);
        } else {
            RewriterUtils.log(this.logger, query, "Full phrase matching");
            matches = RewriterFeatures.getNonOverlappingFullPhraseMatches(this.phraseMatcher, query);
        }
        if (matches == null) {
            return result;
        }
        query = RewriterFeatures.addExpansions(query, matches, null, maxNumRewrites, false, rewritesAsUnitEquiv.equalsIgnoreCase("true"));
        rewritten = true;
        RewriterUtils.log(this.logger, query, "GenericExpansionRewriter final query: " + query.toDetailString());
        result.put("Rewritten", rewritten);
        return result;
    }

    @Override
    public boolean getSkipRewriterIfRewritten() {
        return false;
    }

    @Override
    public String getRewriterName() {
        return REWRITER_NAME;
    }

    @Override
    public HashMap<String, String> getDefaultFSAs() {
        HashMap<String, String> defaultDicts = new HashMap<String, String>();
        defaultDicts.put(GENERIC_EXPAND_DICT, GENERIC_EXPAND_DICT_FILENAME);
        return defaultDicts;
    }
}

