/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.rewrite;

import com.yahoo.component.ComponentId;
import com.yahoo.component.chain.Chain;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.query.rewrite.RewriterUtils;
import com.yahoo.search.searchchain.Execution;
import java.util.logging.Logger;

@Provides(value={"SearchChainDispatcher"})
@After(value={"QLAS"})
public class SearchChainDispatcherSearcher
extends Searcher {
    protected final Logger logger = Logger.getLogger(SearchChainDispatcherSearcher.class.getName());

    public SearchChainDispatcherSearcher(ComponentId id) {
        super(id);
    }

    public SearchChainDispatcherSearcher() {
    }

    @Override
    public Result search(Query query, Execution execution) {
        RewriterUtils.log(this.logger, query, "Entering SearchChainDispatcherSearcher");
        String rewriterChain = RewriterUtils.getRewriterChain(query);
        if (rewriterChain == null || rewriterChain.equals("")) {
            RewriterUtils.log(this.logger, query, "No rewriter chain is specified, skipping to the next searcher");
            return execution.search(query);
        }
        RewriterUtils.log(this.logger, query, "Redirecting to chain " + rewriterChain);
        Chain<Searcher> myChain = execution.searchChainRegistry().getChain(rewriterChain);
        if (myChain == null) {
            RewriterUtils.log(this.logger, query, "Invalid search chain specified, skipping to the next searcher");
            return execution.search(query);
        }
        new Execution(myChain, execution.context()).search(query);
        RewriterUtils.log(this.logger, query, "Finish executing search chain " + rewriterChain);
        return execution.search(query);
    }
}

