/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.ranking;

import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.query.ranking.RankProperties;
import java.util.Objects;

public class WeakAnd
implements Cloneable {
    private static final QueryProfileType argumentType = new QueryProfileType("weakand");
    public static final String STOPWORD_LIMIT = "stopwordLimit";
    public static final String ADJUST_TARGET = "adjustTarget";
    private Double stopwordLimit = null;
    private Double adjustTarget = null;

    public static QueryProfileType getArgumentType() {
        return argumentType;
    }

    public Double getStopwordLimit() {
        return this.stopwordLimit;
    }

    public Double getAdjustTarget() {
        return this.adjustTarget;
    }

    private static void validateRange(String field, double v, double lboundIncl, double uboundIncl) {
        if (v < lboundIncl || v > uboundIncl) {
            throw new IllegalArgumentException("%s must be in the range [%.1f, %.1f]. It is %.1f".formatted(field, lboundIncl, uboundIncl, v));
        }
    }

    public void setStopwordLimit(double limit) {
        WeakAnd.validateRange(STOPWORD_LIMIT, limit, 0.0, 1.0);
        this.stopwordLimit = limit;
    }

    public void setAdjustTarget(double target) {
        WeakAnd.validateRange(ADJUST_TARGET, target, 0.0, 1.0);
        this.adjustTarget = target;
    }

    public void prepare(RankProperties rankProperties) {
        if (this.stopwordLimit != null) {
            rankProperties.put("vespa.matching.weakand.stop_word_drop_limit", String.valueOf(this.stopwordLimit));
        }
        if (this.adjustTarget != null) {
            rankProperties.put("vespa.matching.weakand.stop_word_adjust_limit", String.valueOf(this.adjustTarget));
        }
    }

    public WeakAnd clone() {
        try {
            return (WeakAnd)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Won't happen", e);
        }
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeakAnd weakAnd = (WeakAnd)o;
        return Objects.equals(this.stopwordLimit, weakAnd.stopwordLimit) && Objects.equals(this.adjustTarget, weakAnd.adjustTarget);
    }

    public int hashCode() {
        return Objects.hash(this.stopwordLimit, this.adjustTarget);
    }

    static {
        argumentType.setStrict(true);
        argumentType.setBuiltin(true);
        argumentType.addField(new FieldDescription(STOPWORD_LIMIT, "double"));
        argumentType.addField(new FieldDescription(ADJUST_TARGET, "double"));
    }
}

