/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.properties;

import com.yahoo.language.process.Embedder;
import com.yahoo.processing.IllegalInputException;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.query.Properties;
import com.yahoo.search.query.Ranking;
import com.yahoo.search.query.profile.compiled.CompiledQueryProfileRegistry;
import com.yahoo.search.query.profile.types.ConversionContext;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.tensor.Tensor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class QueryProperties
extends Properties {
    private Query query;
    private final CompiledQueryProfileRegistry profileRegistry;
    private final Map<String, Embedder> embedders;
    private static final Set<String> reservedPrefix = Set.of("model", "presentation", "select", "ranking", "trace");
    private static final Map<CompoundName, GetterSetter> propertyAccessors = QueryProperties.createPropertySetterMap();

    private static void addDualCasedRM(Map<CompoundName, GetterSetter> map, String last, GetterSetter accessor) {
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "matching", last}), accessor);
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "matching", last.toLowerCase()}), accessor);
    }

    private static Map<CompoundName, GetterSetter> createPropertySetterMap() {
        HashMap<CompoundName, GetterSetter> map = new HashMap<CompoundName, GetterSetter>();
        map.put(CompoundName.fromComponents((String[])new String[]{"model", "queryString"}), GetterSetter.of(query -> query.getModel().getQueryString(), (query, value) -> query.getModel().setQueryString(QueryProperties.asString((Object)value, (String)""))));
        map.put(CompoundName.fromComponents((String[])new String[]{"model", "type"}), GetterSetter.of(query -> query.getModel().getType(), (query, value) -> query.getModel().setType(QueryProperties.asString((Object)value, (String)"ANY"))));
        map.put(CompoundName.fromComponents((String[])new String[]{"model", "filter"}), GetterSetter.of(query -> query.getModel().getFilter(), (query, value) -> query.getModel().setFilter(QueryProperties.asString((Object)value, (String)""))));
        map.put(CompoundName.fromComponents((String[])new String[]{"model", "defaultIndex"}), GetterSetter.of(query -> query.getModel().getDefaultIndex(), (query, value) -> query.getModel().setDefaultIndex(QueryProperties.asString((Object)value, (String)""))));
        map.put(CompoundName.fromComponents((String[])new String[]{"model", "language"}), GetterSetter.of(query -> query.getModel().getLanguage(), (query, value) -> query.getModel().setLanguage(QueryProperties.asString((Object)value, (String)""))));
        map.put(CompoundName.fromComponents((String[])new String[]{"model", "locale"}), GetterSetter.of(query -> query.getModel().getLocale(), (query, value) -> query.getModel().setLocale(QueryProperties.asString((Object)value, (String)""))));
        map.put(CompoundName.fromComponents((String[])new String[]{"model", "encoding"}), GetterSetter.of(query -> query.getModel().getEncoding(), (query, value) -> query.getModel().setEncoding(QueryProperties.asString((Object)value, (String)""))));
        map.put(CompoundName.fromComponents((String[])new String[]{"model", "sources"}), GetterSetter.of(query -> query.getModel().getSources(), (query, value) -> query.getModel().setSources(QueryProperties.asString((Object)value, (String)""))));
        map.put(CompoundName.fromComponents((String[])new String[]{"model", "searchPath"}), GetterSetter.of(query -> query.getModel().getSearchPath(), (query, value) -> query.getModel().setSearchPath(QueryProperties.asString((Object)value, (String)""))));
        map.put(CompoundName.fromComponents((String[])new String[]{"model", "restrict"}), GetterSetter.of(query -> query.getModel().getRestrict(), (query, value) -> query.getModel().setRestrict(QueryProperties.asString((Object)value, (String)""))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "location"}), GetterSetter.of(query -> query.getRanking().getLocation(), (query, value) -> query.getRanking().setLocation(QueryProperties.asString((Object)value, (String)""))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "profile"}), GetterSetter.of(query -> query.getRanking().getProfile(), (query, value) -> query.getRanking().setProfile(QueryProperties.asString((Object)value, (String)""))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "sorting"}), GetterSetter.of(query -> query.getRanking().getSorting(), (query, value) -> query.getRanking().setSorting(QueryProperties.asString((Object)value, (String)""))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "freshness"}), GetterSetter.of(query -> query.getRanking().getFreshness(), (query, value) -> query.getRanking().setFreshness(QueryProperties.asString((Object)value, (String)""))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "queryCache"}), GetterSetter.of(query -> query.getRanking().getQueryCache(), (query, value) -> query.getRanking().setQueryCache(QueryProperties.asBoolean((Object)value, (boolean)false))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "rerankCount"}), GetterSetter.of(query -> query.getRanking().getRerankCount(), (query, value) -> query.getRanking().setRerankCount(QueryProperties.asInteger((Object)value, null))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "keepRankCount"}), GetterSetter.of(query -> query.getRanking().getKeepRankCount(), (query, value) -> query.getRanking().setKeepRankCount(QueryProperties.asInteger((Object)value, null))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "rankScoreDropLimit"}), GetterSetter.of(query -> query.getRanking().getRankScoreDropLimit(), (query, value) -> query.getRanking().setRankScoreDropLimit(QueryProperties.asDouble((Object)value, null))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "listFeatures"}), GetterSetter.of(query -> query.getRanking().getListFeatures(), (query, value) -> query.getRanking().setListFeatures(QueryProperties.asBoolean((Object)value, (boolean)false))));
        QueryProperties.addDualCasedRM(map, "termwiseLimit", GetterSetter.of(query -> query.getRanking().getMatching().getTermwiseLimit(), (query, value) -> query.getRanking().getMatching().setTermwiselimit(QueryProperties.asDouble((Object)value, (Double)1.0))));
        QueryProperties.addDualCasedRM(map, "numThreadsPerSearch", GetterSetter.of(query -> query.getRanking().getMatching().getNumThreadsPerSearch(), (query, value) -> query.getRanking().getMatching().setNumThreadsPerSearch(QueryProperties.asInteger((Object)value, (Integer)1))));
        QueryProperties.addDualCasedRM(map, "numSearchPartitions", GetterSetter.of(query -> query.getRanking().getMatching().getNumSearchPartitions(), (query, value) -> query.getRanking().getMatching().setNumSearchPartitions(QueryProperties.asInteger((Object)value, (Integer)1))));
        QueryProperties.addDualCasedRM(map, "minHitsPerThread", GetterSetter.of(query -> query.getRanking().getMatching().getMinHitsPerThread(), (query, value) -> query.getRanking().getMatching().setMinHitsPerThread(QueryProperties.asInteger((Object)value, (Integer)0))));
        QueryProperties.addDualCasedRM(map, "postFilterThreshold", GetterSetter.of(query -> query.getRanking().getMatching().getPostFilterThreshold(), (query, value) -> query.getRanking().getMatching().setPostFilterThreshold(QueryProperties.asDouble((Object)value, (Double)1.0))));
        QueryProperties.addDualCasedRM(map, "approximateThreshold", GetterSetter.of(query -> query.getRanking().getMatching().getApproximateThreshold(), (query, value) -> query.getRanking().getMatching().setApproximateThreshold(QueryProperties.asDouble((Object)value, (Double)0.05))));
        QueryProperties.addDualCasedRM(map, "targetHitsMaxAdjustmentFactor", GetterSetter.of(query -> query.getRanking().getMatching().getTargetHitsMaxAdjustmentFactor(), (query, value) -> query.getRanking().getMatching().setTargetHitsMaxAdjustmentFactor(QueryProperties.asDouble((Object)value, (Double)20.0))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "matching", "weakand", "stopwordLimit"}), GetterSetter.of(query -> query.getRanking().getMatching().getWeakAnd().getStopwordLimit(), (query, value) -> query.getRanking().getMatching().getWeakAnd().setStopwordLimit(QueryProperties.asDouble((Object)value, (Double)1.0))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "matching", "weakand", "adjustTarget"}), GetterSetter.of(query -> query.getRanking().getMatching().getWeakAnd().getAdjustTarget(), (query, value) -> query.getRanking().getMatching().getWeakAnd().setAdjustTarget(QueryProperties.asDouble((Object)value, (Double)1.0))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "matchPhase", "attribute"}), GetterSetter.of(query -> query.getRanking().getMatchPhase().getAttribute(), (query, value) -> query.getRanking().getMatchPhase().setAttribute(QueryProperties.asString((Object)value, null))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "matchPhase", "ascending"}), GetterSetter.of(query -> query.getRanking().getMatchPhase().getAscending(), (query, value) -> query.getRanking().getMatchPhase().setAscending(QueryProperties.asBoolean((Object)value, (boolean)false))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "matchPhase", "maxHits"}), GetterSetter.of(query -> query.getRanking().getMatchPhase().getMaxHits(), (query, value) -> query.getRanking().getMatchPhase().setMaxHits(QueryProperties.asLong((Object)value, null))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "matchPhase", "maxFilterCoverage"}), GetterSetter.of(query -> query.getRanking().getMatchPhase().getMaxFilterCoverage(), (query, value) -> query.getRanking().getMatchPhase().setMaxFilterCoverage(QueryProperties.asDouble((Object)value, (Double)0.2))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "matchPhase", "diversity", "attribute"}), GetterSetter.of(query -> query.getRanking().getMatchPhase().getDiversity().getAttribute(), (query, value) -> query.getRanking().getMatchPhase().getDiversity().setAttribute(QueryProperties.asString((Object)value, null))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "matchPhase", "diversity", "minGroups"}), GetterSetter.of(query -> query.getRanking().getMatchPhase().getDiversity().getMinGroups(), (query, value) -> query.getRanking().getMatchPhase().getDiversity().setMinGroups(QueryProperties.asLong((Object)value, null))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "matchPhase", "diversity", "cutoff", "factor"}), GetterSetter.of(query -> query.getRanking().getMatchPhase().getDiversity().getCutoffFactor(), (query, value) -> query.getRanking().getMatchPhase().getDiversity().setCutoffFactor(QueryProperties.asDouble((Object)value, (Double)10.0))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "matchPhase", "diversity", "cutoff", "strategy"}), GetterSetter.of(query -> query.getRanking().getMatchPhase().getDiversity().getCutoffStrategy(), (query, value) -> query.getRanking().getMatchPhase().getDiversity().setCutoffStrategy(QueryProperties.asString((Object)value, (String)"loose"))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "secondPhase", "rankScoreDropLimit"}), GetterSetter.of(query -> query.getRanking().getSecondPhase().getRankScoreDropLimit(), (query, value) -> query.getRanking().getSecondPhase().setRankScoreDropLimit(QueryProperties.asDouble((Object)value, null))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "globalPhase", "rerankCount"}), GetterSetter.of(query -> query.getRanking().getGlobalPhase().getRerankCount(), (query, value) -> query.getRanking().getGlobalPhase().setRerankCount(QueryProperties.asInteger((Object)value, null))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "softtimeout", "enable"}), GetterSetter.of(query -> query.getRanking().getSoftTimeout().getEnable(), (query, value) -> query.getRanking().getSoftTimeout().setEnable(QueryProperties.asBoolean((Object)value, (boolean)true))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "softtimeout", "factor"}), GetterSetter.of(query -> query.getRanking().getSoftTimeout().getFactor(), (query, value) -> query.getRanking().getSoftTimeout().setFactor(QueryProperties.asDouble((Object)value, null))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "softtimeout", "tailcost"}), GetterSetter.of(query -> query.getRanking().getSoftTimeout().getTailcost(), (query, value) -> query.getRanking().getSoftTimeout().setTailcost(QueryProperties.asDouble((Object)value, null))));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking", "significance", "useModel"}), GetterSetter.of(query -> query.getRanking().getSignificance().getUseModel().orElse(false), (query, value) -> query.getRanking().getSignificance().setUseModel(QueryProperties.asBoolean((Object)value, (boolean)false))));
        map.put(CompoundName.fromComponents((String[])new String[]{"select"}), GetterSetter.of(query -> query.getSelect().getGroupingExpressionString(), (query, value) -> query.getSelect().setGroupingExpressionString(QueryProperties.asString((Object)value, (String)""))));
        map.put(CompoundName.fromComponents((String[])new String[]{"select", "where"}), GetterSetter.of(query -> query.getSelect().getWhereString(), (query, value) -> query.getSelect().setWhereString(QueryProperties.asString((Object)value, (String)""))));
        map.put(CompoundName.fromComponents((String[])new String[]{"select", "grouping"}), GetterSetter.of(query -> query.getSelect().getGroupingString(), (query, value) -> query.getSelect().setGroupingString(QueryProperties.asString((Object)value, (String)""))));
        map.put(CompoundName.fromComponents((String[])new String[]{"trace", "level"}), GetterSetter.of(query -> query.getTrace().getLevel(), (query, value) -> query.getTrace().setLevel(QueryProperties.asInteger((Object)value, (Integer)0))));
        map.put(CompoundName.fromComponents((String[])new String[]{"trace", "explainLevel"}), GetterSetter.of(query -> query.getTrace().getExplainLevel(), (query, value) -> query.getTrace().setExplainLevel(QueryProperties.asInteger((Object)value, (Integer)0))));
        map.put(CompoundName.fromComponents((String[])new String[]{"trace", "profileDepth"}), GetterSetter.of(null, (query, value) -> query.getTrace().setProfileDepth(QueryProperties.asInteger((Object)value, (Integer)0))));
        map.put(CompoundName.fromComponents((String[])new String[]{"trace", "timestamps"}), GetterSetter.of(query -> query.getTrace().getTimestamps(), (query, value) -> query.getTrace().setTimestamps(QueryProperties.asBoolean((Object)value, (boolean)false))));
        map.put(CompoundName.fromComponents((String[])new String[]{"trace", "query"}), GetterSetter.of(query -> query.getTrace().getQuery(), (query, value) -> query.getTrace().setQuery(QueryProperties.asBoolean((Object)value, (boolean)true))));
        map.put(CompoundName.fromComponents((String[])new String[]{"trace", "profiling", "matching", "depth"}), GetterSetter.of(query -> query.getTrace().getProfiling().getMatching().getDepth(), (query, value) -> query.getTrace().getProfiling().getMatching().setDepth(QueryProperties.asInteger((Object)value, (Integer)0))));
        map.put(CompoundName.fromComponents((String[])new String[]{"trace", "profiling", "firstPhaseRanking", "depth"}), GetterSetter.of(query -> query.getTrace().getProfiling().getFirstPhaseRanking().getDepth(), (query, value) -> query.getTrace().getProfiling().getFirstPhaseRanking().setDepth(QueryProperties.asInteger((Object)value, (Integer)0))));
        map.put(CompoundName.fromComponents((String[])new String[]{"trace", "profiling", "secondPhaseRanking", "depth"}), GetterSetter.of(query -> query.getTrace().getProfiling().getSecondPhaseRanking().getDepth(), (query, value) -> query.getTrace().getProfiling().getSecondPhaseRanking().setDepth(QueryProperties.asInteger((Object)value, (Integer)0))));
        map.put(CompoundName.fromComponents((String[])new String[]{"presentation", "bolding"}), GetterSetter.of(query -> query.getPresentation().getBolding(), (query, value) -> query.getPresentation().setBolding(QueryProperties.asBoolean((Object)value, (boolean)true))));
        map.put(CompoundName.fromComponents((String[])new String[]{"presentation", "summary"}), GetterSetter.of(query -> query.getPresentation().getSummary(), (query, value) -> query.getPresentation().setSummary(QueryProperties.asString((Object)value, (String)""))));
        map.put(CompoundName.fromComponents((String[])new String[]{"presentation", "format"}), GetterSetter.of(query -> query.getPresentation().getFormat(), (query, value) -> query.getPresentation().setFormat(QueryProperties.asString((Object)value, (String)""))));
        map.put(CompoundName.fromComponents((String[])new String[]{"presentation", "timing"}), GetterSetter.of(query -> query.getPresentation().getTiming(), (query, value) -> query.getPresentation().setTiming(QueryProperties.asBoolean((Object)value, (boolean)true))));
        map.put(CompoundName.fromComponents((String[])new String[]{"presentation", "summaryFields"}), GetterSetter.of(query -> query.getPresentation().getSummaryFields(), (query, value) -> query.getPresentation().setSummaryFields(QueryProperties.asString((Object)value, (String)""))));
        map.put(CompoundName.fromComponents((String[])new String[]{"presentation", "format", "tensors"}), GetterSetter.of(query -> query.getPresentation().getTensorFormat(), (query, value) -> query.getPresentation().setTensorFormat(QueryProperties.asString((Object)value, (String)"short"))));
        map.put(Query.HITS, GetterSetter.of(Query::getHits, (query, value) -> query.setHits(QueryProperties.asInteger((Object)value, (Integer)10))));
        map.put(Query.OFFSET, GetterSetter.of(Query::getOffset, (query, value) -> query.setOffset(QueryProperties.asInteger((Object)value, (Integer)0))));
        map.put(Query.TIMEOUT, GetterSetter.of(Query::getTimeout, (query, value) -> query.setTimeout(value.toString())));
        map.put(Query.NO_CACHE, GetterSetter.of(Query::getNoCache, (query, value) -> query.setNoCache(QueryProperties.asBoolean((Object)value, (boolean)false))));
        map.put(Query.GROUPING_SESSION_CACHE, GetterSetter.of(Query::getGroupingSessionCache, (query, value) -> query.setGroupingSessionCache(QueryProperties.asBoolean((Object)value, (boolean)true))));
        map.put(CompoundName.fromComponents((String[])new String[]{"model"}), GetterSetter.of(Query::getModel, null));
        map.put(CompoundName.fromComponents((String[])new String[]{"ranking"}), GetterSetter.of(Query::getRanking, null));
        map.put(CompoundName.fromComponents((String[])new String[]{"presentation"}), GetterSetter.of(Query::getPresentation, null));
        return map;
    }

    public QueryProperties(Query query, CompiledQueryProfileRegistry profileRegistry, Map<String, Embedder> embedders) {
        this.query = query;
        this.profileRegistry = profileRegistry;
        this.embedders = embedders;
    }

    @Override
    public void setParentQuery(Query query) {
        this.query = query;
        super.setParentQuery(query);
    }

    public Object get(CompoundName key, Map<String, String> context, com.yahoo.processing.request.Properties substitution) {
        GetterSetter propertyAccessor = propertyAccessors.get(key);
        if (propertyAccessor != null && propertyAccessor.getter != null) {
            return propertyAccessor.getter.get(this.query);
        }
        if (key.first().equals("ranking")) {
            Ranking ranking = this.query.getRanking();
            if (key.size() > 2) {
                if (key.get(1).equals("features")) {
                    return ranking.getFeatures().getObject(key.rest().rest().toString());
                }
                if (key.get(1).equals("properties")) {
                    return ranking.getProperties().get(key.rest().rest().toString());
                }
            }
        }
        return super.get(key, context, substitution);
    }

    private void setInternal(CompoundName key, Object value, Map<String, String> context) {
        GetterSetter propertyAccessor = propertyAccessors.get(key);
        if (propertyAccessor != null && propertyAccessor.setter != null) {
            propertyAccessor.setter.set(this.query, value);
            return;
        }
        if (key.first().equals("ranking") && key.size() > 2) {
            String restKey = key.rest().rest().toString();
            this.chained().requireSettable(key, value, context);
            if (key.get(1).equals("features")) {
                this.setRankFeature(this.query, restKey, this.toSpecifiedType(restKey, value, (QueryProfileType)((Object)this.profileRegistry.getTypeRegistry().getComponent("features")), context));
                return;
            }
            if (key.get(1).equals("properties")) {
                Ranking ranking = this.query.getRanking();
                ranking.getProperties().put(restKey, this.toSpecifiedType(restKey, value, (QueryProfileType)((Object)this.profileRegistry.getTypeRegistry().getComponent("properties")), context));
                return;
            }
        }
        if (reservedPrefix.contains(key.first())) {
            this.throwIllegalParameter(key.rest().toString(), key.first());
        } else {
            super.set(key, value, context);
        }
    }

    public void set(CompoundName key, Object value, Map<String, String> context) {
        try {
            this.setInternal(key, value, context);
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().startsWith("Could not set")) {
                throw e;
            }
            throw new IllegalInputException("Could not set '" + key + "' to '" + value + "'", (Throwable)e);
        }
    }

    public Map<String, Object> listProperties(CompoundName prefix, Map<String, String> context, com.yahoo.processing.request.Properties substitution) {
        Map properties = super.listProperties(prefix, context, substitution);
        for (CompoundName queryProperty : Query.nativeProperties) {
            Object value;
            if (!queryProperty.hasPrefix(prefix) || (value = this.get(queryProperty, context, substitution)) == null) continue;
            properties.put(queryProperty.toString(), value);
        }
        return properties;
    }

    private void setRankFeature(Query query, String key, Object value) {
        if (value instanceof Tensor) {
            query.getRanking().getFeatures().put(key, (Tensor)value);
        } else if (value instanceof Double) {
            query.getRanking().getFeatures().put(key, (Double)value);
        } else {
            String valueString = QueryProperties.asString((Object)value, (String)"");
            try {
                query.getRanking().getFeatures().put(key, Double.parseDouble(valueString));
            }
            catch (IllegalArgumentException e) {
                query.getRanking().getFeatures().put(key, valueString);
            }
        }
    }

    private Object toSpecifiedType(String key, Object value, QueryProfileType type, Map<String, String> context) {
        if (!(value instanceof String)) {
            return value;
        }
        if (type == null) {
            return value;
        }
        FieldDescription field = type.getField(key);
        if (field == null) {
            return value;
        }
        return field.getType().convertFrom(value, new ConversionContext(key, this.profileRegistry, this.embedders, context, (Properties)this));
    }

    private void throwIllegalParameter(String key, String namespace) {
        throw new IllegalInputException("'" + key + "' is not a valid property in '" + namespace + "'. See the query api for valid keys starting by '" + namespace + "'.");
    }

    @Override
    public final Query getParentQuery() {
        return this.query;
    }

    static interface GetProperty {
        public Object get(Query var1);
    }

    static interface SetProperty {
        public void set(Query var1, Object var2);
    }

    private record GetterSetter(GetProperty getter, SetProperty setter) {
        static GetterSetter of(GetProperty getter, SetProperty setter) {
            return new GetterSetter(getter, setter);
        }
    }
}

