/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile.types;

import com.yahoo.processing.request.Properties;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.search.query.profile.SubstituteString;
import com.yahoo.search.query.profile.types.ConversionContext;
import com.yahoo.search.query.profile.types.FieldType;
import com.yahoo.search.schema.internal.TensorConverter;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.util.Map;

public class TensorFieldType
extends FieldType {
    private final TensorType type;

    public TensorFieldType(TensorType type) {
        this.type = type;
    }

    @Override
    public TensorType asTensorType() {
        return this.type;
    }

    @Override
    public Class getValueClass() {
        return Tensor.class;
    }

    @Override
    public String stringValue() {
        return this.type.toString();
    }

    @Override
    public String toString() {
        return "field type " + this.stringValue();
    }

    @Override
    public String toInstanceDescription() {
        return "a tensor";
    }

    @Override
    public Object convertFrom(Object o, QueryProfileRegistry registry) {
        return this.convertFrom(o, ConversionContext.empty());
    }

    @Override
    public Object convertFrom(Object o, ConversionContext context) {
        if (o instanceof SubstituteString) {
            return new SubstituteStringTensor((SubstituteString)o, this.type);
        }
        return new TensorConverter(context.embedders()).convertTo(this.type, context.destination(), o, context.language(), context.contextValues(), context.properties());
    }

    public static TensorFieldType fromTypeString(String s) {
        return new TensorFieldType(TensorType.fromSpec((String)s));
    }

    private static class SubstituteStringTensor
    extends SubstituteString {
        private final TensorType type;

        SubstituteStringTensor(SubstituteString string, TensorType type) {
            super(string.components(), string.stringValue());
            this.type = type;
        }

        @Override
        public Object substitute(Map<String, String> context, Properties substitution) {
            String substituted = super.substitute(context, substitution).toString();
            return Tensor.from((TensorType)this.type, (String)substituted);
        }
    }
}

