/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import com.yahoo.search.query.profile.DimensionValues;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DimensionBinding {
    private List<String> dimensions;
    private DimensionValues values;
    private Map<String, String> context;
    public static final DimensionBinding nullBinding = new DimensionBinding(List.of(), DimensionValues.empty, null);
    public static final DimensionBinding invalidBinding = new DimensionBinding(List.of(), DimensionValues.empty, null);
    private final boolean containsAllNulls;

    public static DimensionBinding createFrom(Map<String, String> values) {
        return DimensionBinding.createFrom(new ArrayList<String>(values.keySet()), values);
    }

    public static DimensionBinding createFrom(List<String> dimensions, Map<String, String> context) {
        if (dimensions == null || dimensions.size() == 0) {
            if (context == null) {
                return nullBinding;
            }
            if (dimensions == null) {
                return new DimensionBinding(null, DimensionValues.empty, context);
            }
        }
        return new DimensionBinding(dimensions, DimensionBinding.extractDimensionValues(dimensions, context), context);
    }

    public static DimensionBinding createFrom(List<String> dimensions, DimensionValues dimensionValues) {
        if (dimensionValues == null || dimensionValues == DimensionValues.empty) {
            return nullBinding;
        }
        if (dimensions == null) {
            return new DimensionBinding(null, dimensionValues, null);
        }
        return new DimensionBinding(dimensions, dimensionValues, null);
    }

    public DimensionBinding createFor(List<String> newDimensions) {
        if (newDimensions == null) {
            return this;
        }
        if (this.dimensions == newDimensions) {
            return this;
        }
        Map<String, String> context = this.context;
        if (context == null) {
            context = this.values.asContext(this.dimensions != null ? this.dimensions : newDimensions);
        }
        return new DimensionBinding(newDimensions, DimensionBinding.extractDimensionValues(newDimensions, context), context);
    }

    private DimensionBinding(List<String> dimensions, DimensionValues values, Map<String, String> context) {
        this.dimensions = dimensions;
        this.values = values;
        this.context = context;
        this.containsAllNulls = values.isEmpty();
    }

    public List<String> getDimensions() {
        return this.dimensions;
    }

    public Map<String, String> getContext() {
        if (this.context != null) {
            return this.context;
        }
        this.context = this.values.asContext(this.dimensions);
        return this.context;
    }

    public DimensionValues getValues() {
        return this.values;
    }

    public boolean isNull() {
        return this.dimensions == null || this.containsAllNulls;
    }

    private static DimensionValues extractDimensionValues(List<String> dimensions, Map<String, String> context) {
        String[] dimensionValues = new String[dimensions.size()];
        if (context == null || context.size() == 0) {
            return DimensionValues.createFrom(dimensionValues);
        }
        for (int i = 0; i < dimensions.size(); ++i) {
            dimensionValues[i] = context.get(dimensions.get(i));
        }
        return DimensionValues.createFrom(dimensionValues);
    }

    public DimensionBinding combineWith(DimensionBinding other) {
        List<String> d1 = this.getDimensions();
        List<String> d2 = other.getDimensions();
        DimensionValues v1 = this.getValues();
        DimensionValues v2 = other.getValues();
        ArrayList<String> dimensions = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        int i1 = 0;
        int i2 = 0;
        while (i1 < d1.size() && i2 < d2.size()) {
            if (d1.get(i1).equals(d2.get(i2))) {
                String s1 = v1.get(i1);
                String s2 = v2.get(i2);
                if (s1 == null) {
                    values.add(s2);
                } else if (s2 == null || s1.equals(s2)) {
                    values.add(s1);
                } else {
                    return invalidBinding;
                }
                dimensions.add(d1.get(i1));
                ++i1;
                ++i2;
                continue;
            }
            if (!d2.contains(d1.get(i1))) {
                dimensions.add(d1.get(i1));
                values.add(v1.get(i1));
                ++i1;
                continue;
            }
            if (!d1.contains(d2.get(i2))) {
                dimensions.add(d2.get(i2));
                values.add(v2.get(i2));
                ++i2;
                continue;
            }
            return invalidBinding;
        }
        while (i1 < d1.size()) {
            dimensions.add(d1.get(i1));
            values.add(v1.get(i1));
            ++i1;
        }
        while (i2 < d2.size()) {
            dimensions.add(d2.get(i2));
            values.add(v2.get(i2));
            ++i2;
        }
        return DimensionBinding.createFrom(dimensions, DimensionValues.createFrom(values.toArray(new String[0])));
    }

    public boolean isInvalid() {
        return this == invalidBinding;
    }

    public String toString() {
        if (this.isInvalid()) {
            return "Invalid DimensionBinding";
        }
        if (this.dimensions == null) {
            return "DimensionBinding []";
        }
        StringBuilder b = new StringBuilder("DimensionBinding [");
        for (int i = 0; i < this.dimensions.size(); ++i) {
            b.append(this.dimensions.get(i)).append("=").append(this.values.get(i));
            if (i >= this.dimensions.size() - 1) continue;
            b.append(", ");
        }
        b.append("]");
        return b.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DimensionBinding)) {
            return false;
        }
        DimensionBinding other = (DimensionBinding)o;
        if (!this.dimensions.equals(other.dimensions)) {
            return false;
        }
        return this.values.equals(other.values);
    }

    public int hashCode() {
        return Objects.hash(this.dimensions, this.values);
    }
}

