/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query;

import com.google.common.base.Preconditions;
import com.yahoo.collections.LazyMap;
import com.yahoo.geo.DistanceParser;
import com.yahoo.geo.ParsedDegree;
import com.yahoo.language.Language;
import com.yahoo.language.process.Normalizer;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.Location;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.BoolItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.DotProductItem;
import com.yahoo.prelude.query.EquivItem;
import com.yahoo.prelude.query.ExactStringItem;
import com.yahoo.prelude.query.FalseItem;
import com.yahoo.prelude.query.FuzzyItem;
import com.yahoo.prelude.query.GeoLocationItem;
import com.yahoo.prelude.query.IntItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.Limit;
import com.yahoo.prelude.query.NearItem;
import com.yahoo.prelude.query.NearestNeighborItem;
import com.yahoo.prelude.query.NotItem;
import com.yahoo.prelude.query.ONearItem;
import com.yahoo.prelude.query.OrItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.PredicateQueryItem;
import com.yahoo.prelude.query.PrefixItem;
import com.yahoo.prelude.query.RangeItem;
import com.yahoo.prelude.query.RankItem;
import com.yahoo.prelude.query.RegExpItem;
import com.yahoo.prelude.query.SameElementItem;
import com.yahoo.prelude.query.SegmentingRule;
import com.yahoo.prelude.query.Substring;
import com.yahoo.prelude.query.SubstringItem;
import com.yahoo.prelude.query.SuffixItem;
import com.yahoo.prelude.query.TaggableItem;
import com.yahoo.prelude.query.TrueItem;
import com.yahoo.prelude.query.WandItem;
import com.yahoo.prelude.query.WeakAndItem;
import com.yahoo.prelude.query.WeightedSetItem;
import com.yahoo.prelude.query.WordAlternativesItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.processing.IllegalInputException;
import com.yahoo.search.grouping.request.GroupingOperation;
import com.yahoo.search.query.QueryTree;
import com.yahoo.search.query.parser.Parsable;
import com.yahoo.search.query.parser.Parser;
import com.yahoo.search.query.parser.ParserEnvironment;
import com.yahoo.search.yql.VespaGroupingStep;
import com.yahoo.search.yql.YqlParser;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.slime.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SelectParser
implements Parser {
    private static final String AND = "and";
    private static final String AND_NOT = "and_not";
    private static final String CALL = "call";
    private static final String CONTAINS = "contains";
    private static final String EQ = "equals";
    private static final String MATCHES = "matches";
    private static final String OR = "or";
    Parsable query;
    private final IndexFacts indexFacts;
    private final Map<Integer, TaggableItem> identifiedItems = LazyMap.newHashMap();
    private final List<ConnectedItem> connectedItems = new ArrayList<ConnectedItem>();
    private final Normalizer normalizer;
    private IndexFacts.Session indexFactsSession;
    private static final List<String> FUNCTION_CALLS = List.of("wand", "weightedSet", "dotProduct", "geoLocation", "nearestNeighbor", "predicate", "rank", "weakAnd");

    public SelectParser(ParserEnvironment environment) {
        this.indexFacts = environment.getIndexFacts();
        this.normalizer = environment.getLinguistics().getNormalizer();
    }

    @Override
    public QueryTree parse(Parsable query) {
        this.indexFactsSession = this.indexFacts.newSession(query.getSources(), query.getRestrict());
        this.connectedItems.clear();
        this.identifiedItems.clear();
        this.query = query;
        return this.buildTree();
    }

    private QueryTree buildTree() {
        Cursor inspector = SlimeUtils.jsonToSlime((String)this.query.getSelect().getWhereString()).get();
        if (inspector.field("error_message").valid()) {
            throw new IllegalInputException("Illegal query: " + inspector.field("error_message").asString() + " at: '" + new String(inspector.field("offending_input").asData(), StandardCharsets.UTF_8) + "'");
        }
        try {
            Item root = this.walkJson((Inspector)inspector);
            this.connectItems();
            return new QueryTree(root);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalInputException("Illegal JSON query", (Throwable)e);
        }
    }

    private Item walkJson(Inspector inspector) {
        if (inspector.type() == Type.BOOL) {
            return inspector.asBool() ? new TrueItem() : new FalseItem();
        }
        Item[] item = new Item[]{null};
        inspector.traverse((key, value) -> {
            String type;
            switch (type = FUNCTION_CALLS.contains(key) ? CALL : key) {
                case "and": {
                    item[0] = this.buildAnd(key, value);
                    break;
                }
                case "and_not": {
                    item[0] = this.buildNotAnd(key, value);
                    break;
                }
                case "call": {
                    item[0] = this.buildFunctionCall(key, value);
                    break;
                }
                case "contains": {
                    item[0] = this.buildTermSearch(key, value);
                    break;
                }
                case "equals": {
                    item[0] = this.buildEquals(key, value);
                    break;
                }
                case "matches": {
                    item[0] = this.buildRegExpSearch(key, value);
                    break;
                }
                case "or": {
                    item[0] = this.buildOr(key, value);
                    break;
                }
                case "range": {
                    item[0] = this.buildRange(key, value);
                    break;
                }
                default: {
                    throw SelectParser.newUnexpectedArgumentException(key, AND, AND_NOT, CALL, CONTAINS, EQ, MATCHES, OR, "range");
                }
            }
        });
        return item[0];
    }

    public List<VespaGroupingStep> getGroupingSteps(String grouping) {
        ArrayList<VespaGroupingStep> groupingSteps = new ArrayList<VespaGroupingStep>();
        List<String> groupingOperations = this.toGroupingRequests(grouping);
        for (String groupingString : groupingOperations) {
            GroupingOperation groupingOperation = GroupingOperation.fromString(groupingString);
            VespaGroupingStep groupingStep = new VespaGroupingStep(groupingOperation);
            groupingSteps.add(groupingStep);
        }
        return groupingSteps;
    }

    private List<String> toGroupingRequests(String groupingJson) {
        Cursor inspector = SlimeUtils.jsonToSlime((String)groupingJson).get();
        if (inspector.field("error_message").valid()) {
            throw new IllegalInputException("Illegal query: " + inspector.field("error_message").asString() + " at: '" + new String(inspector.field("offending_input").asData(), StandardCharsets.UTF_8) + "'");
        }
        ArrayList<String> operations = new ArrayList<String>();
        inspector.traverse((__, item) -> operations.add(this.toGroupingRequest(item)));
        return operations;
    }

    private String toGroupingRequest(Inspector groupingJson) {
        StringBuilder b = new StringBuilder();
        this.toGroupingRequest(groupingJson, b);
        return b.toString();
    }

    private void toGroupingRequest(Inspector groupingJson, StringBuilder b) {
        switch (groupingJson.type()) {
            case ARRAY: {
                groupingJson.traverse((index, item) -> {
                    this.toGroupingRequest(item, b);
                    if (index + 1 < groupingJson.entries()) {
                        b.append(",");
                    }
                });
                break;
            }
            case OBJECT: {
                groupingJson.traverse((name, object) -> {
                    b.append(name);
                    b.append("(");
                    this.toGroupingRequest(object, b);
                    b.append(") ");
                });
                break;
            }
            case STRING: {
                b.append(groupingJson.asString());
                break;
            }
            default: {
                b.append(groupingJson.toString());
            }
        }
    }

    private Item buildFunctionCall(String key, Inspector value) {
        return switch (key) {
            case "wand" -> this.buildWand(key, value);
            case "weightedSet" -> this.buildWeightedSet(key, value);
            case "dotProduct" -> this.buildDotProduct(key, value);
            case "geoLocation" -> this.buildGeoLocation(key, value);
            case "nearestNeighbor" -> this.buildNearestNeighbor(key, value);
            case "predicate" -> this.buildPredicate(key, value);
            case "rank" -> this.buildRank(key, value);
            case "weakAnd" -> this.buildWeakAnd(key, value);
            default -> throw SelectParser.newUnexpectedArgumentException(key, "dotProduct", "nearestNeighbor", "rank", "wand", "weakAnd", "weightedSet", "predicate");
        };
    }

    private void addItemsFromInspector(CompositeItem item, Inspector inspector) {
        if (inspector.type() == Type.ARRAY) {
            inspector.traverse((index, new_value) -> item.addItem(this.walkJson(new_value)));
        } else if (inspector.type() == Type.OBJECT && inspector.field("children").valid()) {
            inspector.field("children").traverse((index, new_value) -> item.addItem(this.walkJson(new_value)));
        }
    }

    private Inspector getChildren(Inspector inspector) {
        if (inspector.type() == Type.ARRAY) {
            return inspector;
        }
        if (inspector.type() == Type.OBJECT) {
            if (inspector.field("children").valid()) {
                return inspector.field("children");
            }
            if (inspector.field(1).valid()) {
                return inspector.field(1);
            }
        }
        return null;
    }

    private HashMap<Integer, Inspector> childMap(Inspector inspector) {
        HashMap<Integer, Inspector> children = new HashMap<Integer, Inspector>();
        if (inspector.type() == Type.ARRAY) {
            inspector.traverse(children::put);
        } else if (inspector.type() == Type.OBJECT && inspector.field("children").valid()) {
            inspector.field("children").traverse(children::put);
        }
        return children;
    }

    private Inspector getAnnotations(Inspector inspector) {
        if (inspector.type() == Type.OBJECT && inspector.field("attributes").valid()) {
            return inspector.field("attributes");
        }
        return null;
    }

    private HashMap<String, Inspector> getAnnotationMapFromAnnotationInspector(Inspector annotation) {
        HashMap<String, Inspector> attributes = new HashMap<String, Inspector>();
        if (annotation.type() == Type.OBJECT) {
            annotation.traverse(attributes::put);
        }
        return attributes;
    }

    private HashMap<String, Inspector> getAnnotationMap(Inspector inspector) {
        HashMap<String, Inspector> attributes = new HashMap<String, Inspector>();
        if (inspector.type() == Type.OBJECT && inspector.field("attributes").valid()) {
            inspector.field("attributes").traverse(attributes::put);
        }
        return attributes;
    }

    private <T> T getAnnotation(String annotationName, HashMap<String, Inspector> annotations, Class<T> expectedClass, T defaultValue) {
        return annotations.get(annotationName) == null ? defaultValue : expectedClass.cast(annotations.get(annotationName).asString());
    }

    private Boolean getBoolAnnotation(String annotationName, HashMap<String, Inspector> annotations, Boolean defaultValue) {
        Inspector annotation;
        if (annotations != null && (annotation = (Inspector)annotations.getOrDefault(annotationName, null)) != null) {
            return annotation.asBool();
        }
        return defaultValue;
    }

    private Integer getIntegerAnnotation(String annotationName, HashMap<String, Inspector> annotations, Integer defaultValue) {
        Inspector annotation;
        if (annotations != null && (annotation = (Inspector)annotations.getOrDefault(annotationName, null)) != null) {
            return (int)annotation.asLong();
        }
        return defaultValue;
    }

    private Double getDoubleAnnotation(String annotationName, HashMap<String, Inspector> annotations, Double defaultValue) {
        Inspector annotation;
        if (annotations != null && (annotation = (Inspector)annotations.getOrDefault(annotationName, null)) != null) {
            return annotation.asDouble();
        }
        return defaultValue;
    }

    private Inspector getAnnotationAsInspectorOrNull(String annotationName, HashMap<String, Inspector> annotations) {
        return annotations.get(annotationName);
    }

    private CompositeItem buildAnd(String key, Inspector value) {
        AndItem andItem = new AndItem();
        this.addItemsFromInspector(andItem, value);
        return andItem;
    }

    private CompositeItem buildNotAnd(String key, Inspector value) {
        NotItem notItem = new NotItem();
        this.addItemsFromInspector(notItem, value);
        return notItem;
    }

    private CompositeItem buildOr(String key, Inspector value) {
        OrItem orItem = new OrItem();
        this.addItemsFromInspector(orItem, value);
        return orItem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Item buildGeoLocation(String key, Inspector value) {
        HashMap<Integer, Inspector> children = this.childMap(value);
        Preconditions.checkArgument((children.size() == 4 ? 1 : 0) != 0, (String)"Expected 4 arguments, got %s.", (int)children.size());
        String field = children.get(0).asString();
        Inspector arg1 = children.get(1);
        Inspector arg2 = children.get(2);
        Inspector arg3 = children.get(3);
        Location loc = new Location();
        if (arg3.type() != Type.STRING) {
            throw new IllegalArgumentException("Invalid geoLocation radius type " + arg3.type() + " for " + arg3);
        }
        double radius = DistanceParser.parse((String)arg3.asString());
        if (arg1.type() == Type.STRING && arg2.type() == Type.STRING) {
            String c1input = children.get(1).asString();
            String c2input = children.get(2).asString();
            ParsedDegree coord_1 = ParsedDegree.fromString((String)c1input, (boolean)true, (boolean)false);
            ParsedDegree coord_2 = ParsedDegree.fromString((String)c2input, (boolean)false, (boolean)true);
            if (coord_1.isLatitude && coord_2.isLongitude) {
                loc.setGeoCircle(coord_1.degrees, coord_2.degrees, radius);
            } else {
                if (!coord_2.isLatitude || !coord_1.isLongitude) throw new IllegalArgumentException("Invalid geoLocation coordinates '" + c1input + "' and '" + c2input + "'");
                loc.setGeoCircle(coord_2.degrees, coord_1.degrees, radius);
            }
        } else {
            if (arg1.type() != Type.DOUBLE || arg2.type() != Type.DOUBLE) throw new IllegalArgumentException("Invalid geoLocation coordinate types " + arg1.type() + " and " + arg2.type());
            loc.setGeoCircle(arg1.asDouble(), arg2.asDouble(), radius);
        }
        GeoLocationItem item = new GeoLocationItem(loc, field);
        Inspector annotations = this.getAnnotations(value);
        if (annotations == null) return item;
        annotations.traverse((annotation_name, annotation_value) -> {
            if ("label".equals(annotation_name)) {
                item.setLabel(annotation_value.asString());
            }
        });
        return item;
    }

    private Item buildNearestNeighbor(String key, Inspector value) {
        HashMap<Integer, Inspector> children = this.childMap(value);
        Preconditions.checkArgument((children.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 arguments, got %s.", (int)children.size());
        String field = children.get(0).asString();
        String property = children.get(1).asString();
        NearestNeighborItem item = new NearestNeighborItem(this.indexFactsSession.getCanonicName(field), property);
        Inspector annotations = this.getAnnotations(value);
        if (annotations != null) {
            annotations.traverse((annotation_name, annotation_value) -> {
                if ("targetHits".equals(annotation_name)) {
                    item.setTargetNumHits((int)annotation_value.asDouble());
                }
                if ("targetNumHits".equals(annotation_name)) {
                    item.setTargetNumHits((int)annotation_value.asDouble());
                }
                if ("distanceThreshold".equals(annotation_name)) {
                    double distanceThreshold = annotation_value.asDouble();
                    item.setDistanceThreshold(distanceThreshold);
                }
                if ("hnsw.exploreAdditionalHits".equals(annotation_name)) {
                    int hnswExploreAdditionalHits = (int)annotation_value.asDouble();
                    item.setHnswExploreAdditionalHits(hnswExploreAdditionalHits);
                }
                if ("approximate".equals(annotation_name)) {
                    boolean allowApproximate = annotation_value.asBool();
                    item.setAllowApproximate(allowApproximate);
                }
                if ("label".equals(annotation_name)) {
                    item.setLabel(annotation_value.asString());
                }
            });
        }
        return item;
    }

    private CompositeItem buildWeakAnd(String key, Inspector value) {
        WeakAndItem weakAnd = new WeakAndItem();
        this.addItemsFromInspector(weakAnd, value);
        Inspector annotations = this.getAnnotations(value);
        if (annotations != null) {
            annotations.traverse((annotation_name, annotation_value) -> {
                if ("targetHits".equals(annotation_name) || "targetNumHits".equals(annotation_name)) {
                    weakAnd.setN((int)annotation_value.asDouble());
                }
            });
        }
        return weakAnd;
    }

    private <T extends TaggableItem> T leafStyleSettings(Inspector annotations, T out) {
        if (annotations != null) {
            Inspector itemConnectivity = this.getAnnotationAsInspectorOrNull("connectivity", this.getAnnotationMapFromAnnotationInspector(annotations));
            if (itemConnectivity != null) {
                Integer[] id = new Integer[]{null};
                Double[] weight = new Double[]{null};
                itemConnectivity.traverse((key, value) -> {
                    switch (key) {
                        case "id": {
                            id[0] = (int)value.asLong();
                            break;
                        }
                        case "weight": {
                            weight[0] = value.asDouble();
                        }
                    }
                });
                this.connectedItems.add(new ConnectedItem(out, id[0], weight[0]));
            }
            annotations.traverse((annotation_name, annotation_value) -> {
                if ("significance".equals(annotation_name) && annotation_value != null) {
                    out.setSignificance(annotation_value.asDouble());
                }
                if ("id".equals(annotation_name) && annotation_value != null) {
                    out.setUniqueID((int)annotation_value.asLong());
                    this.identifiedItems.put((int)annotation_value.asLong(), out);
                }
            });
        }
        Item leaf = (Item)((Object)out);
        if (annotations != null) {
            Inspector itemAnnotations = this.getAnnotationAsInspectorOrNull("annotations", this.getAnnotationMapFromAnnotationInspector(annotations));
            if (itemAnnotations != null) {
                itemAnnotations.traverse((key, value) -> leaf.addAnnotation(key, value.asString()));
            }
            annotations.traverse((annotation_name, annotation_value) -> {
                if ("filter".equals(annotation_name) && annotation_value != null) {
                    leaf.setFilter(annotation_value.asBool());
                }
                if ("ranked".equals(annotation_name) && annotation_value != null) {
                    leaf.setRanked(annotation_value.asBool());
                }
                if ("label".equals(annotation_name) && annotation_value != null) {
                    leaf.setLabel(annotation_value.asString());
                }
                if ("weight".equals(annotation_name) && annotation_value != null) {
                    leaf.setWeight((int)annotation_value.asDouble());
                }
            });
        }
        if (out instanceof IntItem) {
            Integer hitLimit;
            IntItem number = (IntItem)out;
            if (annotations != null && (hitLimit = this.getCappedRangeSearchParameter(annotations)) != null) {
                number.setHitLimit(hitLimit);
            }
        }
        return out;
    }

    private Integer getCappedRangeSearchParameter(Inspector annotations) {
        Integer[] hitLimit = new Integer[]{null};
        annotations.traverse((annotation_name, annotation_value) -> {
            if ("hitLimit".equals(annotation_name) && annotation_value != null) {
                hitLimit[0] = (int)annotation_value.asDouble();
            }
        });
        Boolean[] ascending = new Boolean[]{null};
        Boolean[] descending = new Boolean[]{null};
        if (hitLimit[0] != null) {
            annotations.traverse((annotation_name, annotation_value) -> {
                if ("ascending".equals(annotation_name)) {
                    ascending[0] = annotation_value.asBool();
                }
                if ("descending".equals(annotation_name)) {
                    descending[0] = annotation_value.asBool();
                }
            });
            Preconditions.checkArgument((ascending[0] == null || descending[0] == null ? 1 : 0) != 0, (Object)"Settings for both ascending and descending ordering set, only one of these expected.");
            if (Boolean.TRUE.equals(descending[0]) || Boolean.FALSE.equals(ascending[0])) {
                hitLimit[0] = hitLimit[0] * -1;
            }
        }
        return hitLimit[0];
    }

    private Item buildEquals(String key, Inspector value) {
        HashMap<Integer, Inspector> children = this.childMap(value);
        if (children.size() != 2) {
            throw new IllegalArgumentException("The value of 'equals' should be an array containing a field name and a value, but was " + value);
        }
        if (((Inspector)children.get(0)).type() != Type.STRING) {
            throw new IllegalArgumentException("The first array element under 'equals' should be a field name string but was " + children.get(0));
        }
        String field = ((Inspector)children.get(0)).asString();
        return switch (((Inspector)children.get(1)).type()) {
            case Type.BOOL -> new BoolItem(((Inspector)children.get(1)).asBool(), field);
            case Type.LONG -> new IntItem(((Inspector)children.get(1)).asLong(), field);
            default -> throw new IllegalArgumentException("The second array element under 'equals' should be a boolean or int value but was " + children.get(1));
        };
    }

    private Item buildRange(String key, Inspector value) {
        Inspector boundInspector;
        String field;
        HashMap<Integer, Inspector> children = this.childMap(value);
        Inspector annotations = this.getAnnotations(value);
        boolean[] equals = new boolean[]{false};
        if (((Inspector)children.get(0)).type() == Type.STRING) {
            field = ((Inspector)children.get(0)).asString();
            boundInspector = (Inspector)children.get(1);
        } else {
            field = ((Inspector)children.get(1)).asString();
            boundInspector = (Inspector)children.get(0);
        }
        Number[] bounds = new Number[]{null, null};
        String[] operators = new String[]{null, null};
        boundInspector.traverse((operator, bound) -> {
            if (bound.type() == Type.STRING) {
                throw new IllegalArgumentException("Expected a numeric argument to range, but got the string '" + bound.asString() + "'");
            }
            if (operator.equals("=")) {
                bounds[0] = bound.type() == Type.DOUBLE ? (Number)bound.asDouble() : (Number)bound.asLong();
                operators[0] = operator;
                equals[0] = true;
            }
            if (operator.equals(">=") || operator.equals(">")) {
                bounds[0] = bound.type() == Type.DOUBLE ? (Number)bound.asDouble() : (Number)bound.asLong();
                operators[0] = operator;
            } else if (operator.equals("<=") || operator.equals("<")) {
                bounds[1] = bound.type() == Type.DOUBLE ? (Number)bound.asDouble() : (Number)bound.asLong();
                operators[1] = operator;
            }
        });
        IntItem range = null;
        if (equals[0]) {
            range = new IntItem(bounds[0].toString(), field);
        } else if (operators[0] == null || operators[1] == null) {
            int index = operators[0] == null ? 1 : 0;
            range = switch (operators[index]) {
                case ">=" -> this.buildGreaterThanOrEquals(field, bounds[index].toString());
                case ">" -> this.buildGreaterThan(field, bounds[index].toString());
                case "<" -> this.buildLessThan(field, bounds[index].toString());
                case "<=" -> this.buildLessThanOrEquals(field, bounds[index].toString());
                default -> range;
            };
        } else {
            range = this.instantiateRangeItem(bounds[0], bounds[1], field, operators[0].equals(">"), operators[1].equals("<"));
        }
        return this.leafStyleSettings(annotations, range);
    }

    private IntItem buildGreaterThanOrEquals(String field, String bound) {
        return new IntItem("[" + bound + ";]", field);
    }

    private IntItem buildLessThanOrEquals(String field, String bound) {
        return new IntItem("[;" + bound + "]", field);
    }

    private IntItem buildGreaterThan(String field, String bound) {
        return new IntItem(">" + bound, field);
    }

    private IntItem buildLessThan(String field, String bound) {
        return new IntItem("<" + bound, field);
    }

    private IntItem instantiateRangeItem(Number lowerBound, Number upperBound, String field, boolean bounds_left_open, boolean bounds_right_open) {
        Limit to;
        Limit from;
        Preconditions.checkArgument((lowerBound != null && upperBound != null && field != null ? 1 : 0) != 0, (Object)"Expected 3 NonNull-arguments");
        if (!bounds_left_open && !bounds_right_open) {
            return new RangeItem(lowerBound, upperBound, field);
        }
        if (bounds_left_open && bounds_right_open) {
            from = new Limit(lowerBound, false);
            to = new Limit(upperBound, false);
        } else if (bounds_left_open) {
            from = new Limit(lowerBound, false);
            to = new Limit(upperBound, true);
        } else {
            from = new Limit(lowerBound, true);
            to = new Limit(upperBound, false);
        }
        return new IntItem(from, to, field);
    }

    private Item buildWand(String key, Inspector value) {
        Double thresholdBoostFactor;
        HashMap<String, Inspector> annotations = this.getAnnotationMap(value);
        HashMap<Integer, Inspector> children = this.childMap(value);
        Preconditions.checkArgument((children.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 arguments, got %s.", (int)children.size());
        Integer target_num_hits = this.getIntegerAnnotation("targetHits", annotations, null);
        if (target_num_hits == null) {
            target_num_hits = this.getIntegerAnnotation("targetNumHits", annotations, YqlParser.DEFAULT_TARGET_NUM_HITS);
        }
        WandItem out = new WandItem(children.get(0).asString(), target_num_hits);
        Double scoreThreshold = this.getDoubleAnnotation("scoreThreshold", annotations, null);
        if (scoreThreshold != null) {
            out.setScoreThreshold(scoreThreshold);
        }
        if ((thresholdBoostFactor = this.getDoubleAnnotation("thresholdBoostFactor", annotations, null)) != null) {
            out.setThresholdBoostFactor(thresholdBoostFactor);
        }
        return this.fillWeightedSet(value, children, out);
    }

    private WeightedSetItem fillWeightedSet(Inspector value, HashMap<Integer, Inspector> children, WeightedSetItem out) {
        SelectParser.addItems(children, out);
        return this.leafStyleSettings(this.getAnnotations(value), out);
    }

    private static void addItems(HashMap<Integer, Inspector> children, WeightedSetItem out) {
        switch (children.get(1).type()) {
            case OBJECT: {
                SelectParser.addStringItems(children, out);
                break;
            }
            case ARRAY: {
                SelectParser.addLongItems(children, out);
                break;
            }
            default: {
                throw SelectParser.newUnexpectedArgumentException(children.get(1).type(), Type.ARRAY, Type.OBJECT);
            }
        }
    }

    private static void addStringItems(HashMap<Integer, Inspector> children, WeightedSetItem out) {
        children.get(1).traverse((key, value) -> {
            if (value.type() == Type.STRING) {
                throw new IllegalArgumentException("Expected an integer argument, but got the string '" + value.asString() + "'");
            }
            out.addToken(key, (int)value.asLong());
        });
    }

    private static void addLongItems(HashMap<Integer, Inspector> children, WeightedSetItem out) {
        children.get(1).traverse((index, pair) -> {
            ArrayList pairValues = new ArrayList();
            pair.traverse((pairIndex, pairValue) -> pairValues.add((int)pairValue.asLong()));
            Preconditions.checkArgument((pairValues.size() == 2 ? 1 : 0) != 0, (String)"Expected item and weight, got %s.", pairValues);
            out.addToken(((Integer)pairValues.get(0)).longValue(), (int)((Integer)pairValues.get(1)));
        });
    }

    private Item buildRegExpSearch(String key, Inspector value) {
        SelectParser.assertHasOperator(key, MATCHES);
        HashMap<Integer, Inspector> children = this.childMap(value);
        String field = children.get(0).asString();
        String wordData = children.get(1).asString();
        RegExpItem regExp = new RegExpItem(field, true, wordData);
        return this.leafStyleSettings(this.getAnnotations(value), regExp);
    }

    private Item buildWeightedSet(String key, Inspector value) {
        HashMap<Integer, Inspector> children = this.childMap(value);
        String field = children.get(0).asString();
        Preconditions.checkArgument((children.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 arguments, got %s.", (int)children.size());
        return this.fillWeightedSet(value, children, new WeightedSetItem(field));
    }

    private Item buildDotProduct(String key, Inspector value) {
        HashMap<Integer, Inspector> children = this.childMap(value);
        String field = children.get(0).asString();
        Preconditions.checkArgument((children.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 arguments, got %s.", (int)children.size());
        return this.fillWeightedSet(value, children, new DotProductItem(field));
    }

    private Item buildPredicate(String key, Inspector value) {
        HashMap<Integer, Inspector> children = this.childMap(value);
        String field = children.get(0).asString();
        Inspector args = children.get(1);
        Preconditions.checkArgument((children.size() == 3 ? 1 : 0) != 0, (String)"Expected 3 arguments, got %s.", (int)children.size());
        PredicateQueryItem item = new PredicateQueryItem();
        item.setIndexName(field);
        List<Inspector> argumentList = this.valueListFromInspector(this.getChildren(value));
        argumentList.get(1).traverse((attrKey, attrValue) -> {
            if (attrValue.type() == Type.ARRAY) {
                List<Inspector> attributes = this.valueListFromInspector(attrValue);
                attributes.forEach(attribute -> item.addFeature(attrKey, attribute.asString()));
            } else {
                item.addFeature(attrKey, attrValue.asString());
            }
        });
        argumentList.get(2).traverse((attrKey, attrValue) -> item.addRangeFeature(attrKey, (int)attrValue.asDouble()));
        return this.leafStyleSettings(this.getAnnotations(value), item);
    }

    private CompositeItem buildRank(String key, Inspector value) {
        RankItem rankItem = new RankItem();
        this.addItemsFromInspector(rankItem, value);
        return rankItem;
    }

    private Item buildTermSearch(String key, Inspector value) {
        HashMap<Integer, Inspector> children = this.childMap(value);
        String field = children.get(0).asString();
        return this.instantiateLeafItem(field, key, value);
    }

    private String getInspectorKey(Inspector inspector) {
        String[] actualKey = new String[]{""};
        if (inspector.type() == Type.OBJECT) {
            inspector.traverse((key, value) -> {
                actualKey[0] = key;
            });
        }
        return actualKey[0];
    }

    private Item instantiateLeafItem(String field, String key, Inspector value) {
        String possibleLeafFunctionName;
        List<Inspector> possibleLeafFunction = this.valueListFromInspector(value);
        String string = possibleLeafFunctionName = possibleLeafFunction.size() > 1 ? this.getInspectorKey(possibleLeafFunction.get(1)) : "";
        if (FUNCTION_CALLS.contains(key)) {
            return this.instantiateCompositeLeaf(field, key, value);
        }
        if (!possibleLeafFunctionName.isEmpty()) {
            return this.instantiateCompositeLeaf(field, possibleLeafFunctionName, this.valueListFromInspector(value).get(1).field(possibleLeafFunctionName));
        }
        return this.instantiateWordItem(field, key, value);
    }

    private Item instantiateCompositeLeaf(String field, String key, Inspector value) {
        return switch (key) {
            case "sameElement" -> this.instantiateSameElementItem(field, key, value);
            case "phrase" -> this.instantiatePhraseItem(field, key, value);
            case "near" -> this.instantiateNearItem(field, key, value);
            case "onear" -> this.instantiateONearItem(field, key, value);
            case "equiv" -> this.instantiateEquivItem(field, key, value);
            case "fuzzy" -> this.instantiateFuzzyItem(field, key, value);
            case "alternatives" -> this.instantiateWordAlternativesItem(field, key, value);
            default -> throw SelectParser.newUnexpectedArgumentException(key, "equiv", "near", "onear", "phrase", "sameElement");
        };
    }

    private Item instantiateWordItem(String field, String key, Inspector value) {
        HashMap<Integer, Inspector> children = this.childMap(value);
        if (children.size() < 2) {
            throw new IllegalArgumentException("Expected at least 2 children of '" + key + "', but got " + children.size());
        }
        String wordData = children.get(1).asString();
        return this.instantiateWordItem(field, wordData, key, value, false, this.decideParsingLanguage(value, wordData));
    }

    private Item instantiateWordItem(String field, String rawWord, String key, Inspector value, boolean exactMatch, Language language) {
        String wordData = rawWord;
        HashMap<String, Inspector> annotations = this.getAnnotationMap(value);
        if (this.getBoolAnnotation("nfkc", annotations, Boolean.FALSE).booleanValue()) {
            wordData = this.normalizer.normalize(wordData);
        }
        boolean fromQuery = this.getBoolAnnotation("implicitTransforms", annotations, Boolean.TRUE);
        boolean prefixMatch = this.getBoolAnnotation("prefix", annotations, Boolean.FALSE);
        boolean suffixMatch = this.getBoolAnnotation("suffix", annotations, Boolean.FALSE);
        boolean substrMatch = this.getBoolAnnotation("substring", annotations, Boolean.FALSE);
        Preconditions.checkArgument(((prefixMatch ? 1 : 0) + (substrMatch ? 1 : 0) + (suffixMatch ? 1 : 0) < 2 ? 1 : 0) != 0, (Object)"Only one of prefix, substring and suffix can be set.");
        WordItem wordItem = exactMatch ? new ExactStringItem(wordData, fromQuery) : (prefixMatch ? new PrefixItem(wordData, fromQuery) : (suffixMatch ? new SuffixItem(wordData, fromQuery) : (substrMatch ? new SubstringItem(wordData, fromQuery) : new WordItem(wordData, fromQuery))));
        this.prepareWord(field, value, wordItem);
        if (language != Language.ENGLISH) {
            wordItem.setLanguage(language);
        }
        return this.leafStyleSettings(this.getAnnotations(value), wordItem);
    }

    private Language decideParsingLanguage(Inspector value, String wordData) {
        String languageTag = this.getAnnotation("language", this.getAnnotationMap(value), String.class, null);
        Language language = Language.fromLanguageTag((String)languageTag);
        if (language != Language.UNKNOWN) {
            return language;
        }
        Optional<Language> explicitLanguage = this.query.getExplicitLanguage();
        return explicitLanguage.orElse(Language.ENGLISH);
    }

    private void prepareWord(String field, Inspector value, WordItem wordItem) {
        wordItem.setIndexName(field);
        this.wordStyleSettings(value, wordItem);
    }

    private void wordStyleSettings(Inspector value, WordItem out) {
        HashMap<String, Inspector> annotations = this.getAnnotationMap(value);
        Substring origin = this.getOrigin(this.getAnnotations(value));
        if (origin != null) {
            out.setOrigin(origin);
        }
        if (annotations != null) {
            Boolean andSegmenting;
            Boolean accentDrop;
            Boolean normalizeCase;
            Boolean stem;
            Boolean usePositionData = this.getBoolAnnotation("usePositionData", annotations, null);
            if (usePositionData != null) {
                out.setPositionData(usePositionData);
            }
            if ((stem = this.getBoolAnnotation("stem", annotations, null)) != null) {
                out.setStemmed(stem == false);
            }
            if ((normalizeCase = this.getBoolAnnotation("normalizeCase", annotations, null)) != null) {
                out.setLowercased(normalizeCase == false);
            }
            if ((accentDrop = this.getBoolAnnotation("accentDrop", annotations, null)) != null) {
                out.setNormalizable(accentDrop);
            }
            if ((andSegmenting = this.getBoolAnnotation("andSegmenting", annotations, null)) != null) {
                if (andSegmenting.booleanValue()) {
                    out.setSegmentingRule(SegmentingRule.BOOLEAN_AND);
                } else {
                    out.setSegmentingRule(SegmentingRule.PHRASE);
                }
            }
        }
    }

    private Substring getOrigin(Inspector annotations) {
        if (annotations != null) {
            Inspector origin = this.getAnnotationAsInspectorOrNull("origin", this.getAnnotationMapFromAnnotationInspector(annotations));
            if (origin == null) {
                return null;
            }
            String[] original = new String[]{null};
            Integer[] offset = new Integer[]{null};
            Integer[] length = new Integer[]{null};
            origin.traverse((key, value) -> {
                switch (key) {
                    case "original": {
                        original[0] = value.asString();
                        break;
                    }
                    case "offset": {
                        offset[0] = (int)value.asDouble();
                        break;
                    }
                    case "length": {
                        length[0] = (int)value.asDouble();
                    }
                }
            });
            return new Substring(offset[0], length[0] + offset[0], original[0]);
        }
        return null;
    }

    private Item instantiateSameElementItem(String field, String key, Inspector value) {
        SelectParser.assertHasOperator(key, "sameElement");
        SameElementItem sameElement = new SameElementItem(field);
        this.getChildren(value).traverse((index, term) -> sameElement.addItem(this.walkJson(term)));
        return sameElement;
    }

    private Item instantiatePhraseItem(String field, String key, Inspector value) {
        SelectParser.assertHasOperator(key, "phrase");
        PhraseItem phrase = new PhraseItem();
        phrase.setIndexName(field);
        phrase.setExplicit(true);
        HashMap<Integer, Inspector> children = this.childMap(value);
        for (Inspector word : children.values()) {
            if (word.type() == Type.STRING) {
                phrase.addItem(new WordItem(word.asString()));
                continue;
            }
            if (word.type() != Type.OBJECT || !word.field("phrase").valid()) continue;
            phrase.addItem(this.instantiatePhraseItem(field, key, this.getChildren(word)));
        }
        return this.leafStyleSettings(this.getAnnotations(value), phrase);
    }

    private Item instantiateNearItem(String field, String key, Inspector value) {
        SelectParser.assertHasOperator(key, "near");
        NearItem near = new NearItem();
        near.setIndexName(field);
        HashMap<Integer, Inspector> children = this.childMap(value);
        for (Inspector word : children.values()) {
            near.addItem(new WordItem(word.asString(), field));
        }
        Integer distance = this.getIntegerAnnotation("distance", this.getAnnotationMap(value), null);
        if (distance != null) {
            near.setDistance(distance);
        }
        return near;
    }

    private Item instantiateONearItem(String field, String key, Inspector value) {
        SelectParser.assertHasOperator(key, "onear");
        ONearItem onear = new ONearItem();
        onear.setIndexName(field);
        HashMap<Integer, Inspector> children = this.childMap(value);
        for (Inspector word : children.values()) {
            onear.addItem(new WordItem(word.asString(), field));
        }
        Integer distance = this.getIntegerAnnotation("distance", this.getAnnotationMap(value), null);
        if (distance != null) {
            onear.setDistance(distance);
        }
        return onear;
    }

    private Item instantiateEquivItem(String field, String key, Inspector value) {
        HashMap<Integer, Inspector> children = this.childMap(value);
        Preconditions.checkArgument((children.size() >= 2 ? 1 : 0) != 0, (String)"Expected 2 or more arguments, got %s.", (int)children.size());
        EquivItem equiv = new EquivItem();
        equiv.setIndexName(field);
        for (Inspector word : children.values()) {
            if (word.type() == Type.STRING || word.type() == Type.LONG || word.type() == Type.DOUBLE) {
                equiv.addItem(new WordItem(word.asString(), field));
            }
            if (word.type() != Type.OBJECT) continue;
            word.traverse((key2, value2) -> {
                SelectParser.assertHasOperator(key2, "phrase");
                equiv.addItem(this.instantiatePhraseItem(field, key2, value2));
            });
        }
        return this.leafStyleSettings(this.getAnnotations(value), equiv);
    }

    private Item instantiateFuzzyItem(String field, String key, Inspector value) {
        HashMap<Integer, Inspector> children = this.childMap(value);
        HashMap<String, Inspector> annotations = this.getAnnotationMap(value);
        Preconditions.checkArgument((children.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 argument, got %s.", (int)children.size());
        String wordData = children.get(0).asString();
        Integer maxEditDistance = this.getIntegerAnnotation("maxEditDistance", annotations, FuzzyItem.DEFAULT_MAX_EDIT_DISTANCE);
        Integer prefixLength = this.getIntegerAnnotation("prefixLength", annotations, FuzzyItem.DEFAULT_PREFIX_LENGTH);
        boolean prefixMatch = this.getBoolAnnotation("prefix", annotations, Boolean.FALSE);
        FuzzyItem fuzzy = new FuzzyItem(field, true, wordData, maxEditDistance, prefixLength, prefixMatch);
        return this.leafStyleSettings(this.getAnnotations(value), fuzzy);
    }

    private Item instantiateWordAlternativesItem(String field, String key, Inspector value) {
        HashMap<Integer, Inspector> children = this.childMap(value);
        Preconditions.checkArgument((!children.isEmpty() ? 1 : 0) != 0, (Object)"Expected 1 or more arguments, got none");
        Preconditions.checkArgument((children.get(0).type() == Type.OBJECT ? 1 : 0) != 0, (String)"Expected OBJECT, got %s.", (Object)children.get(0).type());
        ArrayList<WordAlternativesItem.Alternative> terms = new ArrayList<WordAlternativesItem.Alternative>();
        children.get(0).traverse((keys, values) -> terms.add(new WordAlternativesItem.Alternative(keys, values.asDouble())));
        return this.leafStyleSettings(this.getAnnotations(value), new WordAlternativesItem(field, Boolean.TRUE, null, terms));
    }

    private String getIndex(String field) {
        Preconditions.checkArgument((boolean)this.indexFactsSession.isIndex(field), (String)"Field '%s' does not exist.", (Object)field);
        return field;
    }

    private static void assertHasOperator(String key, String expectedKey) {
        Preconditions.checkArgument((boolean)key.equals(expectedKey), (String)"Expected operator %s, got %s.", (Object)expectedKey, (Object)key);
    }

    private static IllegalArgumentException newUnexpectedArgumentException(Object actual, Object ... expected) {
        StringBuilder out = new StringBuilder("Expected ");
        int len = expected.length;
        for (int i = 0; i < len; ++i) {
            out.append(expected[i]);
            if (i < len - 2) {
                out.append(", ");
                continue;
            }
            if (i >= len - 1) continue;
            out.append(" or ");
        }
        out.append(", got ").append(actual).append(".");
        return new IllegalArgumentException(out.toString());
    }

    private List<Inspector> valueListFromInspector(Inspector inspector) {
        ArrayList<Inspector> inspectorList = new ArrayList<Inspector>();
        inspector.traverse((key, value) -> inspectorList.add(value));
        return inspectorList;
    }

    private void connectItems() {
        for (ConnectedItem entry : this.connectedItems) {
            TaggableItem to = this.identifiedItems.get(entry.toId);
            if (to == null) {
                throw new IllegalArgumentException("Item '" + entry.fromItem + "' was specified to connect to item with ID " + entry.toId + ", which does not exist in the query.");
            }
            entry.fromItem.setConnectivity((Item)((Object)to), entry.weight);
        }
    }

    private static final class ConnectedItem {
        final double weight;
        final int toId;
        final TaggableItem fromItem;

        ConnectedItem(TaggableItem fromItem, int toId, double weight) {
            this.weight = weight;
            this.toId = toId;
            this.fromItem = fromItem;
        }
    }
}

