/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.yahoo.search.grouping.request.FunctionNode;
import com.yahoo.search.grouping.request.GroupingExpression;
import com.yahoo.search.grouping.request.MathACosFunction;
import com.yahoo.search.grouping.request.MathACosHFunction;
import com.yahoo.search.grouping.request.MathASinFunction;
import com.yahoo.search.grouping.request.MathASinHFunction;
import com.yahoo.search.grouping.request.MathATanFunction;
import com.yahoo.search.grouping.request.MathATanHFunction;
import com.yahoo.search.grouping.request.MathCbrtFunction;
import com.yahoo.search.grouping.request.MathCosFunction;
import com.yahoo.search.grouping.request.MathCosHFunction;
import com.yahoo.search.grouping.request.MathExpFunction;
import com.yahoo.search.grouping.request.MathFloorFunction;
import com.yahoo.search.grouping.request.MathHypotFunction;
import com.yahoo.search.grouping.request.MathLog10Function;
import com.yahoo.search.grouping.request.MathLog1pFunction;
import com.yahoo.search.grouping.request.MathLogFunction;
import com.yahoo.search.grouping.request.MathPowFunction;
import com.yahoo.search.grouping.request.MathSinFunction;
import com.yahoo.search.grouping.request.MathSinHFunction;
import com.yahoo.search.grouping.request.MathSqrtFunction;
import com.yahoo.search.grouping.request.MathTanFunction;
import com.yahoo.search.grouping.request.MathTanHFunction;

public abstract class MathFunctions {
    public static FunctionNode newInstance(Function type, GroupingExpression x, GroupingExpression y) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Function.EXP -> new MathExpFunction(x);
            case Function.POW -> new MathPowFunction(x, y);
            case Function.LOG -> new MathLogFunction(x);
            case Function.LOG1P -> new MathLog1pFunction(x);
            case Function.LOG10 -> new MathLog10Function(x);
            case Function.SIN -> new MathSinFunction(x);
            case Function.ASIN -> new MathASinFunction(x);
            case Function.COS -> new MathCosFunction(x);
            case Function.ACOS -> new MathACosFunction(x);
            case Function.TAN -> new MathTanFunction(x);
            case Function.ATAN -> new MathATanFunction(x);
            case Function.SQRT -> new MathSqrtFunction(x);
            case Function.SINH -> new MathSinHFunction(x);
            case Function.ASINH -> new MathASinHFunction(x);
            case Function.COSH -> new MathCosHFunction(x);
            case Function.ACOSH -> new MathACosHFunction(x);
            case Function.TANH -> new MathTanHFunction(x);
            case Function.ATANH -> new MathATanHFunction(x);
            case Function.CBRT -> new MathCbrtFunction(x);
            case Function.HYPOT -> new MathHypotFunction(x, y);
            case Function.FLOOR -> new MathFloorFunction(x);
        };
    }

    public static enum Function {
        EXP,
        POW,
        LOG,
        LOG1P,
        LOG10,
        SIN,
        ASIN,
        COS,
        ACOS,
        TAN,
        ATAN,
        SQRT,
        SINH,
        ASINH,
        COSH,
        ACOSH,
        TANH,
        ATANH,
        CBRT,
        HYPOT,
        FLOOR;


        static Function create(int tid) {
            for (Function p : Function.values()) {
                if (tid != p.ordinal()) continue;
                return p;
            }
            return null;
        }
    }
}

