/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping;

import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.processing.IllegalInputException;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.config.ClusterConfig;
import com.yahoo.search.grouping.GroupingQueryParser;
import com.yahoo.search.grouping.GroupingRequest;
import com.yahoo.search.grouping.UnavailableAttributeException;
import com.yahoo.search.grouping.request.AttributeMapLookupValue;
import com.yahoo.search.grouping.request.AttributeValue;
import com.yahoo.search.grouping.request.ExpressionVisitor;
import com.yahoo.search.grouping.request.GroupingExpression;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.vespa.config.search.AttributesConfig;
import java.util.HashMap;

@Before(value={"backend"})
@After(value={"SelectParameterParsing"})
@Provides(value={"GroupingValidated"})
public class GroupingValidator
extends Searcher {
    public static final String GROUPING_VALIDATED = "GroupingValidated";
    public static final CompoundName PARAM_ENABLED = CompoundName.from((String)("validate_" + GroupingQueryParser.PARAM_REQUEST));
    private final HashMap<String, AttributesConfig.Attribute> attributes = new HashMap();
    private final String clusterName;
    private final boolean enabled;

    @Inject
    public GroupingValidator(ClusterConfig clusterConfig, AttributesConfig attributesConfig) {
        this.enabled = clusterConfig.indexMode() != ClusterConfig.IndexMode.Enum.STREAMING;
        this.clusterName = clusterConfig.clusterName();
        for (AttributesConfig.Attribute attr : attributesConfig.attribute()) {
            this.attributes.put(attr.name(), attr);
        }
    }

    @Override
    public Result search(Query query, Execution execution) {
        if (this.enabled && query.properties().getBoolean(PARAM_ENABLED, true)) {
            MyVisitor visitor = new MyVisitor();
            for (GroupingRequest req : query.getSelect().getGrouping()) {
                req.getRootOperation().visitExpressions(visitor);
            }
        }
        return execution.search(query);
    }

    private static String datatypeAsString(AttributesConfig.Attribute attribute) {
        AttributesConfig.Attribute.Datatype.Enum datatype = attribute.datatype();
        if (datatype == AttributesConfig.Attribute.Datatype.TENSOR && !attribute.tensortype().isEmpty()) {
            return attribute.tensortype();
        }
        return switch (datatype) {
            default -> throw new IncompatibleClassChangeError();
            case AttributesConfig.Attribute.Datatype.Enum.STRING -> "string";
            case AttributesConfig.Attribute.Datatype.Enum.BOOL -> "bool";
            case AttributesConfig.Attribute.Datatype.Enum.UINT2 -> "uint2";
            case AttributesConfig.Attribute.Datatype.Enum.UINT4 -> "uint4";
            case AttributesConfig.Attribute.Datatype.Enum.INT8 -> "byte";
            case AttributesConfig.Attribute.Datatype.Enum.INT16 -> "short";
            case AttributesConfig.Attribute.Datatype.Enum.INT32 -> "int";
            case AttributesConfig.Attribute.Datatype.Enum.INT64 -> "long";
            case AttributesConfig.Attribute.Datatype.Enum.FLOAT16 -> "float16";
            case AttributesConfig.Attribute.Datatype.Enum.FLOAT -> "float";
            case AttributesConfig.Attribute.Datatype.Enum.DOUBLE -> "double";
            case AttributesConfig.Attribute.Datatype.Enum.PREDICATE -> "predicate";
            case AttributesConfig.Attribute.Datatype.Enum.TENSOR -> "tensor";
            case AttributesConfig.Attribute.Datatype.Enum.REFERENCE -> "reference";
            case AttributesConfig.Attribute.Datatype.Enum.RAW -> "raw";
            case AttributesConfig.Attribute.Datatype.Enum.NONE -> "none";
        };
    }

    private static String typeAsString(AttributesConfig.Attribute attribute) {
        AttributesConfig.Attribute.Collectiontype.Enum collectiontype = attribute.collectiontype();
        return switch (collectiontype) {
            default -> throw new IncompatibleClassChangeError();
            case AttributesConfig.Attribute.Collectiontype.Enum.SINGLE -> GroupingValidator.datatypeAsString(attribute);
            case AttributesConfig.Attribute.Collectiontype.Enum.ARRAY -> "array<" + GroupingValidator.datatypeAsString(attribute) + ">";
            case AttributesConfig.Attribute.Collectiontype.Enum.WEIGHTEDSET -> "weightedset<" + GroupingValidator.datatypeAsString(attribute) + ">";
        };
    }

    private static boolean isPrimitiveAttribute(AttributesConfig.Attribute attribute) {
        AttributesConfig.Attribute.Datatype.Enum datatype = attribute.datatype();
        return datatype == AttributesConfig.Attribute.Datatype.INT8 || datatype == AttributesConfig.Attribute.Datatype.INT16 || datatype == AttributesConfig.Attribute.Datatype.INT32 || datatype == AttributesConfig.Attribute.Datatype.INT64 || datatype == AttributesConfig.Attribute.Datatype.STRING || datatype == AttributesConfig.Attribute.Datatype.FLOAT || datatype == AttributesConfig.Attribute.Datatype.DOUBLE;
    }

    private static boolean isSingleRawBoolOrReferenceAttribute(AttributesConfig.Attribute attribute) {
        AttributesConfig.Attribute.Datatype.Enum datatype = attribute.datatype();
        return (datatype == AttributesConfig.Attribute.Datatype.RAW || datatype == AttributesConfig.Attribute.Datatype.BOOL || datatype == AttributesConfig.Attribute.Datatype.REFERENCE) && attribute.collectiontype() == AttributesConfig.Attribute.Collectiontype.SINGLE;
    }

    private void verifyHasAttribute(String attributeName, boolean isMapLookup) {
        AttributesConfig.Attribute attribute = this.attributes.get(attributeName);
        if (attribute == null) {
            throw new UnavailableAttributeException(this.clusterName, attributeName);
        }
        if (GroupingValidator.isPrimitiveAttribute(attribute) || !isMapLookup && GroupingValidator.isSingleRawBoolOrReferenceAttribute(attribute)) {
            return;
        }
        throw new IllegalInputException("Grouping request references attribute '" + attributeName + "' with unsupported type '" + GroupingValidator.typeAsString(attribute) + "'" + (isMapLookup ? " for map lookup" : ""));
    }

    private void verifyCompatibleAttributeTypes(String keyAttributeName, String keySourceAttributeName) {
        AttributesConfig.Attribute keyAttribute = this.attributes.get(keyAttributeName);
        AttributesConfig.Attribute keySourceAttribute = this.attributes.get(keySourceAttributeName);
        if (!keySourceAttribute.datatype().equals((Object)keyAttribute.datatype())) {
            throw new IllegalInputException("Grouping request references key source attribute '" + keySourceAttributeName + "' with data type '" + GroupingValidator.datatypeAsString(keySourceAttribute) + "' that is different than data type '" + GroupingValidator.datatypeAsString(keyAttribute) + "' of key attribute '" + keyAttributeName + "'");
        }
        if (!keySourceAttribute.collectiontype().equals((Object)AttributesConfig.Attribute.Collectiontype.Enum.SINGLE)) {
            throw new IllegalInputException("Grouping request references key source attribute '" + keySourceAttributeName + "' with type '" + GroupingValidator.typeAsString(keySourceAttribute) + "' which is not of single value type");
        }
    }

    private class MyVisitor
    implements ExpressionVisitor {
        private MyVisitor() {
        }

        @Override
        public void visitExpression(GroupingExpression exp) {
            if (exp instanceof AttributeMapLookupValue) {
                AttributeMapLookupValue mapLookup = (AttributeMapLookupValue)exp;
                GroupingValidator.this.verifyHasAttribute(mapLookup.getKeyAttribute(), true);
                GroupingValidator.this.verifyHasAttribute(mapLookup.getValueAttribute(), true);
                if (mapLookup.hasKeySourceAttribute()) {
                    GroupingValidator.this.verifyHasAttribute(mapLookup.getKeySourceAttribute(), true);
                    GroupingValidator.this.verifyCompatibleAttributeTypes(mapLookup.getKeyAttribute(), mapLookup.getKeySourceAttribute());
                }
            } else if (exp instanceof AttributeValue) {
                GroupingValidator.this.verifyHasAttribute(((AttributeValue)exp).getAttributeName(), false);
            }
        }
    }
}

