/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch.searchcluster;

import com.google.common.math.Quantiles;
import com.yahoo.search.dispatch.searchcluster.Group;
import com.yahoo.search.dispatch.searchcluster.Node;
import com.yahoo.search.dispatch.searchcluster.SearchGroups;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class SearchGroupsImpl
implements SearchGroups {
    private final Map<Integer, Group> groups;
    private final double minActiveDocsPercentage;

    public SearchGroupsImpl(Map<Integer, Group> groups, double minActiveDocsPercentage) {
        this.groups = Map.copyOf(groups);
        this.minActiveDocsPercentage = minActiveDocsPercentage;
    }

    @Override
    public Group get(int id) {
        return this.groups.get(id);
    }

    @Override
    public Set<Integer> keys() {
        return this.groups.keySet();
    }

    @Override
    public Collection<Group> groups() {
        return this.groups.values();
    }

    @Override
    public int size() {
        return this.groups.size();
    }

    @Override
    public boolean isPartialGroupCoverageSufficient(boolean currentIsGroupCoverageSufficient, Collection<Node> nodes) {
        if (this.size() == 1) {
            return true;
        }
        long groupDocumentCount = nodes.stream().mapToLong(Node::getActiveDocuments).sum();
        return this.isGroupCoverageSufficient(currentIsGroupCoverageSufficient, groupDocumentCount, this.medianDocumentCount(), this.maxDocumentCount());
    }

    public boolean isGroupCoverageSufficient(boolean currentIsGroupCoverageSufficient, long groupDocumentCount, long medianDocumentCount, long maxDocumentCount) {
        if (medianDocumentCount <= 0L) {
            return true;
        }
        if (currentIsGroupCoverageSufficient) {
            double documentCoverage = 100.0 * (double)groupDocumentCount / (double)medianDocumentCount;
            return documentCoverage >= this.minActiveDocsPercentage;
        }
        double documentCoverage = 100.0 * (double)groupDocumentCount / (double)maxDocumentCount;
        return documentCoverage >= this.minActiveDocsPercentage;
    }

    public long medianDocumentCount() {
        if (this.isEmpty()) {
            return 0L;
        }
        double[] activeDocuments = this.groups().stream().mapToDouble(Group::activeDocuments).toArray();
        return (long)Quantiles.median().computeInPlace(activeDocuments);
    }

    public long maxDocumentCount() {
        return (long)this.groups().stream().mapToDouble(Group::activeDocuments).max().orElse(0.0);
    }
}

