/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.yahoo.concurrent.Timer;
import com.yahoo.search.Query;
import com.yahoo.search.dispatch.TimeoutHandler;
import com.yahoo.vespa.config.search.DispatchConfig;

class AdaptiveTimeoutHandler
implements TimeoutHandler {
    private final double minimumCoverage;
    private final int askedNodes;
    private final int minimumResponses;
    private final Query query;
    private final Timer timer;
    private final DispatchConfig config;
    private long deadline;
    private long adaptiveTimeoutMin;
    private long adaptiveTimeoutMax;
    boolean adaptiveTimeoutCalculated = false;

    AdaptiveTimeoutHandler(Timer timer, DispatchConfig config, int askedNodes, Query query) {
        this.minimumCoverage = config.minSearchCoverage();
        this.config = config;
        this.askedNodes = askedNodes;
        this.query = query;
        this.timer = timer;
        this.minimumResponses = (int)Math.ceil((double)askedNodes * this.minimumCoverage / 100.0);
        this.deadline = timer.milliTime() + query.getTimeLeft();
    }

    @Override
    public long nextTimeoutMS(int answeredNodes) {
        long nextAdaptive;
        if (this.askedNodes == answeredNodes) {
            return this.query.getTimeLeft();
        }
        if (answeredNodes < this.minimumResponses) {
            return this.query.getTimeLeft();
        }
        if (!this.adaptiveTimeoutCalculated) {
            long timeLeftMs = this.query.getTimeLeft();
            this.adaptiveTimeoutMin = (long)((double)timeLeftMs * this.config.minWaitAfterCoverageFactor());
            this.adaptiveTimeoutMax = (long)((double)timeLeftMs * this.config.maxWaitAfterCoverageFactor());
            this.adaptiveTimeoutCalculated = true;
        }
        long now = this.timer.milliTime();
        int pendingQueries = this.askedNodes - answeredNodes;
        double missWidth = (100.0 - this.minimumCoverage) * (double)this.askedNodes / 100.0 - 1.0;
        double slopedWait = this.adaptiveTimeoutMin;
        if (pendingQueries > 1 && missWidth > 0.0) {
            slopedWait += (double)((this.adaptiveTimeoutMax - this.adaptiveTimeoutMin) * (long)(pendingQueries - 1)) / missWidth;
        }
        if ((nextAdaptive = (long)slopedWait) >= this.deadline - now) {
            return this.deadline - now;
        }
        this.deadline = now + nextAdaptive;
        return nextAdaptive;
    }

    @Override
    public int reason() {
        return 4;
    }
}

