/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.rule;

import com.yahoo.prelude.semantics.engine.Choicepoint;
import com.yahoo.prelude.semantics.engine.FlattenedItem;
import com.yahoo.prelude.semantics.engine.RuleEvaluation;
import com.yahoo.prelude.semantics.rule.Condition;
import java.util.Iterator;
import java.util.List;

public class EllipsisCondition
extends Condition {
    private boolean referable;

    public EllipsisCondition() {
        this(true);
    }

    public EllipsisCondition(boolean referable) {
        this(null, referable);
    }

    public EllipsisCondition(String label, boolean referable) {
        super(label);
        this.referable = referable;
        if (referable) {
            this.setContextName("...");
        }
    }

    public EllipsisCondition(String label, String context) {
        super(label, context);
    }

    @Override
    public boolean doesMatch(RuleEvaluation e) {
        Choicepoint choicepoint = e.getChoicepoint(this, false);
        if (choicepoint == null) {
            choicepoint = e.getChoicepoint(this, true);
        } else if (!choicepoint.isOpen()) {
            return false;
        }
        int numberOfTermsToMatch = e.itemCount() - e.currentPosition() - choicepoint.tryCount();
        if (numberOfTermsToMatch < 0) {
            choicepoint.close();
            return false;
        }
        choicepoint.addTry();
        String matchedTerms = this.matchTerms(numberOfTermsToMatch, e);
        e.setValue(matchedTerms);
        return true;
    }

    private String matchTerms(int numberOfTerms, RuleEvaluation e) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < numberOfTerms; ++i) {
            e.addMatch(e.currentItem(), e.currentItem().getItem().getIndexedString());
            b.append(e.currentItem().getItem().stringValue());
            if (i < numberOfTerms - 1) {
                b.append(" ");
            }
            e.next();
        }
        return b.toString();
    }

    @Override
    public String getMatchInfo(RuleEvaluation e) {
        Choicepoint choicepoint = e.getChoicepoint(this, false);
        if (choicepoint == null) {
            return null;
        }
        return this.spaceSeparated(e.items().subList(choicepoint.getState().getPosition(), e.itemCount() - choicepoint.tryCount() + 1));
    }

    private String spaceSeparated(List<FlattenedItem> items) {
        StringBuilder buffer = new StringBuilder();
        Iterator<FlattenedItem> i = items.iterator();
        while (i.hasNext()) {
            buffer.append(i.next().toString());
            if (!i.hasNext()) continue;
            buffer.append(" ");
        }
        return buffer.toString();
    }

    @Override
    public boolean isReferable() {
        return this.referable || super.isReferable();
    }

    public void setReferable(boolean referable) {
        this.referable = referable;
        if (referable && this.getContextName() == null) {
            this.setContextName("...");
        }
        if (!referable && "...".equals(this.getContextName())) {
            this.setContextName(null);
        }
    }

    @Override
    protected boolean hasOpenChoicepoint(RuleEvaluation e) {
        Choicepoint choicepoint = e.getChoicepoint(this, false);
        if (choicepoint == null) {
            return false;
        }
        return choicepoint.isOpen();
    }

    @Override
    protected boolean isDefaultContextName() {
        return this.getContextName() == null || this.getContextName().equals("...");
    }

    @Override
    protected String toInnerString() {
        if (this.referable) {
            return "[...]";
        }
        return "...";
    }
}

