/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.rule;

import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.semantics.RuleBase;
import com.yahoo.prelude.semantics.engine.FlattenedItem;
import com.yahoo.prelude.semantics.engine.RuleEvaluation;
import com.yahoo.prelude.semantics.rule.CompositeCondition;

public abstract class Condition {
    private CompositeCondition parent = null;
    private String label;
    private String nameSpace = null;
    private String contextName;
    private Anchor anchor = Anchor.NONE;

    public Condition() {
        this(null, null);
    }

    public Condition(String label) {
        this(label, null);
    }

    public Condition(String label, String context) {
        this.label = label;
        this.contextName = context;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public String getContextName() {
        return this.contextName;
    }

    protected boolean isReferable() {
        return this.contextName != null;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public CompositeCondition getParent() {
        return this.parent;
    }

    void setParent(CompositeCondition parent) {
        this.parent = parent;
    }

    public void setAnchor(Anchor anchor) {
        this.anchor = anchor;
    }

    public Anchor getAnchor() {
        return this.anchor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean matches(RuleEvaluation e) {
        try {
            this.preMatchHook(e);
            if (!this.matchesStartAnchor(e)) {
                boolean bl = false;
                return bl;
            }
            String higherLabel = e.getCurrentLabel();
            if (this.getLabel() != null) {
                e.setCurrentLabel(this.getLabel());
            }
            boolean matches = this.doesMatch(e);
            while (!matches && this.hasOpenChoicepoint(e)) {
                matches = this.doesMatch(e);
            }
            e.setCurrentLabel(higherLabel);
            if (!this.matchesEndAnchor(e)) {
                boolean bl = false;
                return bl;
            }
            this.traceResult(matches, e);
            boolean bl = matches;
            return bl;
        }
        finally {
            this.postMatchHook(e);
        }
    }

    protected boolean matchesStartAnchor(RuleEvaluation e) {
        if (this.anchor != Anchor.START && this.anchor != Anchor.BOTH) {
            return true;
        }
        if (e.getPosition() == 0) {
            return true;
        }
        if (e.getTraceLevel() >= 4) {
            e.trace(4, this + " must be at the start, which " + e.currentItem() + " isn't");
        }
        return false;
    }

    protected boolean matchesEndAnchor(RuleEvaluation e) {
        if (this.anchor != Anchor.END && this.anchor != Anchor.BOTH) {
            return true;
        }
        if (e.getPosition() >= e.items().size()) {
            return true;
        }
        if (e.getTraceLevel() >= 4) {
            e.trace(4, this + " must be at the end, which " + e.currentItem() + " isn't");
        }
        return false;
    }

    protected void traceResult(boolean matches, RuleEvaluation e) {
        if (matches && e.getTraceLevel() >= 3) {
            e.trace(3, "Matched '" + this + "'" + this.getMatchInfoString(e) + " at " + e.previousItem());
        }
        if (!matches && e.getTraceLevel() >= 4) {
            e.trace(4, "Did not match '" + this + "' at " + e.currentItem());
        }
    }

    protected String getMatchInfoString(RuleEvaluation e) {
        String matchInfo = this.getMatchInfo(e);
        if (matchInfo == null) {
            return "";
        }
        return " as '" + matchInfo + "'";
    }

    protected void preMatchHook(RuleEvaluation e) {
        e.entering(this.contextName);
    }

    protected void postMatchHook(RuleEvaluation e) {
        e.leaving(this.contextName);
    }

    protected String getMatchInfo(RuleEvaluation e) {
        return null;
    }

    protected abstract boolean doesMatch(RuleEvaluation var1);

    protected boolean hasOpenChoicepoint(RuleEvaluation e) {
        return false;
    }

    public void makeReferences(RuleBase rules) {
    }

    protected String getLabelString() {
        if (this.label == null) {
            return "";
        }
        return this.label + ":";
    }

    protected boolean labelMatches(RuleEvaluation e) {
        FlattenedItem flattenedItem = e.currentItem();
        if (flattenedItem == null) {
            return true;
        }
        TermItem item = flattenedItem.getItem();
        if (item == null) {
            return true;
        }
        return this.labelMatches(item, e);
    }

    protected boolean labelMatches(TermItem evaluationTerm, RuleEvaluation e) {
        String indexName = evaluationTerm.getIndexName();
        String label = this.getLabel();
        if (label == null) {
            label = e.getCurrentLabel();
        }
        if ("".equals(indexName) && label == null) {
            return true;
        }
        if ("default".equals(indexName) && label == null) {
            return true;
        }
        if (indexName.equals(label)) {
            return true;
        }
        if (e.getTraceLevel() >= 4) {
            e.trace(4, "'" + this + "' does not match, label of " + e.currentItem() + " was required to be " + label);
        }
        return false;
    }

    protected abstract String toInnerString();

    protected boolean isDefaultContextName() {
        return false;
    }

    public String toString() {
        Object contextString = "";
        Object nameSpaceString = "";
        if (this.contextName != null && !this.isDefaultContextName()) {
            contextString = this.contextName + "/";
        }
        if (this.getNameSpace() != null) {
            nameSpaceString = this.getNameSpace() + ".";
        }
        return (String)contextString + (String)nameSpaceString + this.toInnerString();
    }

    public static enum Anchor {
        NONE,
        START,
        END,
        BOTH;


        public static Anchor create(boolean start, boolean end) {
            if (start && end) {
                return BOTH;
            }
            if (start) {
                return START;
            }
            if (end) {
                return END;
            }
            return NONE;
        }
    }
}

