/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.engine;

import com.yahoo.language.Language;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.StemList;
import com.yahoo.language.process.StemMode;
import java.util.List;
import java.util.Objects;

public class RuleBaseLinguistics {
    private final StemMode stemMode;
    private final Language language;
    private final Linguistics linguistics;

    public RuleBaseLinguistics(Linguistics linguistics) {
        this(StemMode.BEST, Language.ENGLISH, linguistics);
    }

    public RuleBaseLinguistics(StemMode stemMode, Language language, Linguistics linguistics) {
        this.stemMode = Objects.requireNonNull(stemMode);
        this.language = Objects.requireNonNull(language);
        this.linguistics = Objects.requireNonNull(linguistics);
    }

    public RuleBaseLinguistics withStemMode(StemMode stemMode) {
        return new RuleBaseLinguistics(stemMode, this.language, this.linguistics);
    }

    public RuleBaseLinguistics withLanguage(Language language) {
        return new RuleBaseLinguistics(this.stemMode, language, this.linguistics);
    }

    public Linguistics linguistics() {
        return this.linguistics;
    }

    public String process(String term) {
        if (this.stemMode == StemMode.NONE) {
            return term;
        }
        List stems = this.linguistics.getStemmer().stem(term, this.language, StemMode.SHORTEST, true);
        if (stems.isEmpty()) {
            return term;
        }
        if (((StemList)stems.get(0)).isEmpty()) {
            return term;
        }
        return ((StemList)stems.get(0)).get(0);
    }
}

