/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.querytransform;

import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.query.QueryTree;
import com.yahoo.search.searchchain.Execution;
import java.util.ListIterator;

public class CollapsePhraseSearcher
extends Searcher {
    @Override
    public Result search(Query query, Execution execution) {
        QueryTree tree = query.getModel().getQueryTree();
        Item root = tree.getRoot();
        if (root != null) {
            Item newRoot = root.clone();
            if (!root.equals(newRoot = this.simplifyPhrases(newRoot))) {
                tree.setRoot(newRoot);
                query.trace("Collapsing single term phrases to single terms", true, 2);
            }
        }
        return execution.search(query);
    }

    private Item simplifyPhrases(Item root) {
        if (root == null) {
            return root;
        }
        if (root instanceof PhraseItem) {
            return this.collapsePhrase((PhraseItem)root);
        }
        if (root instanceof CompositeItem) {
            CompositeItem composite = (CompositeItem)root;
            ListIterator<Item> i = composite.getItemIterator();
            while (i.hasNext()) {
                Item transformed;
                Item original = i.next();
                if (original == (transformed = this.simplifyPhrases(original))) continue;
                i.set(transformed);
            }
            return root;
        }
        return root;
    }

    private Item collapsePhrase(PhraseItem root) {
        if (root.getItemCount() == 1) {
            return root.getItem(0);
        }
        return root;
    }
}

