/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.DocumentFrequency;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.TaggableItem;
import java.util.Optional;

public abstract class CompositeTaggableItem
extends CompositeItem
implements TaggableItem {
    @Override
    public int getUniqueID() {
        return this.uniqueID;
    }

    @Override
    public void setUniqueID(int id) {
        this.setHasUniqueID(true);
        this.uniqueID = id;
    }

    @Override
    public void setConnectivity(Item item, double connectivity) {
        if (!(item instanceof TaggableItem)) {
            throw new IllegalArgumentException("setConnectivity item must be taggable, was: " + item.getClass() + " [" + item + "]");
        }
        this.setHasUniqueID(true);
        item.setHasUniqueID(true);
        if (this.connectedItem != null) {
            this.connectedItem.connectedBacklink = null;
        }
        this.connectivity = connectivity;
        this.connectedItem = item;
        this.connectedItem.connectedBacklink = this;
    }

    @Override
    public Item getConnectedItem() {
        return this.connectedItem;
    }

    @Override
    public double getConnectivity() {
        return this.connectivity;
    }

    @Override
    public void setSignificance(double significance) {
        this.setHasUniqueID(true);
        this.setExplicitSignificance(true);
        this.significance = significance;
    }

    @Override
    public void setExplicitSignificance(boolean explicitSignificance) {
        this.explicitSignificance = explicitSignificance;
    }

    @Override
    public boolean hasExplicitSignificance() {
        return this.explicitSignificance;
    }

    @Override
    public double getSignificance() {
        return this.significance;
    }

    @Override
    public void setDocumentFrequency(DocumentFrequency documentFrequency) {
        this.documentFrequency = documentFrequency;
    }

    @Override
    public Optional<DocumentFrequency> getDocumentFrequency() {
        return Optional.ofNullable(this.documentFrequency);
    }

    @Override
    public boolean hasUniqueID() {
        return super.hasUniqueID();
    }
}

