/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.Substring;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.processing.IllegalInputException;
import java.nio.ByteBuffer;

public class BoolItem
extends TermItem {
    private boolean value;

    public BoolItem(boolean value) {
        this(value, "");
    }

    public BoolItem(boolean value, String indexName) {
        this(value, indexName, false);
    }

    public BoolItem(boolean value, String indexName, boolean isFromQuery) {
        super(indexName, isFromQuery, new Substring(String.valueOf(value)));
        this.value = value;
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.WORD;
    }

    @Override
    public String getName() {
        return "BOOL";
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        BoolItem.putString(this.stringValue(), buffer);
    }

    public boolean value() {
        return this.value;
    }

    @Override
    public String stringValue() {
        return this.value ? "true" : "false";
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    @Override
    public void setValue(String stringValue) {
        this.value = this.toBoolean(stringValue);
    }

    private boolean toBoolean(String stringValue) {
        return switch (stringValue.toLowerCase()) {
            case "true" -> true;
            case "false" -> false;
            default -> throw new IllegalInputException("Expected 'true' or 'false', got '" + stringValue + "'");
        };
    }

    @Override
    public String getRawWord() {
        return this.stringValue();
    }

    @Override
    public boolean isStemmed() {
        return false;
    }

    @Override
    protected void appendHeadingString(StringBuilder buffer) {
    }

    @Override
    public int hashCode() {
        return Boolean.hashCode(this.value);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        BoolItem other = (BoolItem)object;
        return this.value == other.value;
    }

    @Override
    public int getNumWords() {
        return 1;
    }

    @Override
    public String getIndexedString() {
        return this.stringValue();
    }

    @Override
    public boolean isWords() {
        return false;
    }
}

