/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.hitfield;

import com.yahoo.prelude.hitfield.FieldPart;
import com.yahoo.prelude.hitfield.HitField;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class TokenFieldIterator
implements ListIterator<FieldPart> {
    private int index = 0;
    private int prevReturned = 0;
    private final List<FieldPart> fieldList;
    private final HitField hitField;

    public TokenFieldIterator(List<FieldPart> fieldList, HitField hitField) {
        this.fieldList = fieldList;
        this.hitField = hitField;
    }

    @Override
    public void add(FieldPart o) {
        this.fieldList.add(this.index, o);
        ++this.index;
        this.hitField.markDirty();
    }

    @Override
    public boolean hasNext() {
        for (int i = this.index; i < this.fieldList.size(); ++i) {
            if (!this.fieldList.get(i).isToken()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPrevious() {
        int i = this.index;
        while (i > 0) {
            if (!this.fieldList.get(--i).isToken()) continue;
            return true;
        }
        return false;
    }

    @Override
    public FieldPart next() {
        for (int i = this.index; i < this.fieldList.size(); ++i) {
            if (!this.fieldList.get(i).isToken()) continue;
            this.index = i + 1;
            this.prevReturned = i;
            return this.fieldList.get(i);
        }
        throw new NoSuchElementException("No more tokens available.");
    }

    @Override
    public int nextIndex() {
        for (int i = this.index; i < this.fieldList.size(); ++i) {
            if (!this.fieldList.get(i).isToken()) continue;
            return i;
        }
        return this.fieldList.size();
    }

    @Override
    public FieldPart previous() {
        int i = this.index;
        while (i > 0) {
            if (!this.fieldList.get(--i).isToken()) continue;
            this.index = i;
            this.prevReturned = i;
            return this.fieldList.get(i);
        }
        throw new NoSuchElementException("Trying to go before first token available.");
    }

    @Override
    public int previousIndex() {
        int i = this.index;
        while (i > 0) {
            if (!this.fieldList.get(--i).isToken()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void remove() {
        this.fieldList.remove(this.prevReturned);
        if (this.prevReturned < this.index) {
            --this.index;
        }
        this.hitField.markDirty();
    }

    @Override
    public void set(FieldPart o) {
        this.fieldList.set(this.prevReturned, o);
        this.hitField.markDirty();
    }
}

