/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.search.llm;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.FileReference;
import com.yahoo.config.OptionalPathNode;
import com.yahoo.config.StringNode;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public final class LlmSearcherConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "104a672574a9dbdc37322dbff0003b92";
    public static final String CONFIG_DEF_NAME = "llm-searcher";
    public static final String CONFIG_DEF_NAMESPACE = "ai.vespa.search.llm";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=ai.vespa.search.llm", "propertyPrefix string default=\"llm\"", "stream bool default=true", "providerId string default=\"\"", "prompt string default=\"\"", "promptTemplate path optional"};
    private final StringNode propertyPrefix;
    private final BooleanNode stream;
    private final StringNode providerId;
    private final StringNode prompt;
    private final OptionalPathNode promptTemplate;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public LlmSearcherConfig(Builder builder) {
        this(builder, true);
    }

    private LlmSearcherConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for llm-searcher must be initialized: " + builder.__uninitialized);
        }
        this.propertyPrefix = builder.propertyPrefix == null ? new StringNode("llm") : new StringNode(builder.propertyPrefix);
        this.stream = builder.stream == null ? new BooleanNode(true) : new BooleanNode(builder.stream.booleanValue());
        this.providerId = builder.providerId == null ? new StringNode("") : new StringNode(builder.providerId);
        this.prompt = builder.prompt == null ? new StringNode("") : new StringNode(builder.prompt);
        this.promptTemplate = builder.promptTemplate == null ? new OptionalPathNode() : new OptionalPathNode(builder.promptTemplate);
    }

    public String propertyPrefix() {
        return this.propertyPrefix.value();
    }

    public boolean stream() {
        return this.stream.value();
    }

    public String providerId() {
        return this.providerId.value();
    }

    public String prompt() {
        return this.prompt.value();
    }

    public Optional<Path> promptTemplate() {
        return this.promptTemplate.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(LlmSearcherConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private String propertyPrefix = null;
        private Boolean stream = null;
        private String providerId = null;
        private String prompt = null;
        private Optional<FileReference> promptTemplate = Optional.empty();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(LlmSearcherConfig config) {
            this.propertyPrefix(config.propertyPrefix());
            this.stream(config.stream());
            this.providerId(config.providerId());
            this.prompt(config.prompt());
            this.promptTemplate(config.promptTemplate.getFileReference());
        }

        private Builder override(Builder __superior) {
            if (__superior.propertyPrefix != null) {
                this.propertyPrefix(__superior.propertyPrefix);
            }
            if (__superior.stream != null) {
                this.stream(__superior.stream);
            }
            if (__superior.providerId != null) {
                this.providerId(__superior.providerId);
            }
            if (__superior.prompt != null) {
                this.prompt(__superior.prompt);
            }
            if (__superior.promptTemplate != null) {
                this.promptTemplate(__superior.promptTemplate);
            }
            return this;
        }

        public Builder propertyPrefix(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.propertyPrefix = __value;
            return this;
        }

        public Builder stream(boolean __value) {
            this.stream = __value;
            return this;
        }

        private Builder stream(String __value) {
            return this.stream(Boolean.valueOf(__value));
        }

        public Builder providerId(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.providerId = __value;
            return this;
        }

        public Builder prompt(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.prompt = __value;
            return this;
        }

        public Builder promptTemplate(Optional<FileReference> __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.promptTemplate = __value;
            this.__uninitialized.remove("promptTemplate");
            return this;
        }

        private Builder promptTemplate(FileReference __value) {
            return this.promptTemplate(Optional.of(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return LlmSearcherConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return LlmSearcherConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return LlmSearcherConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public LlmSearcherConfig build() {
            return new LlmSearcherConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

