/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.protect.Process;
import com.yahoo.vespa.defaults.Defaults;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

class ShutdownDeadline
implements AutoCloseable {
    private final String configId;
    private final ScheduledThreadPoolExecutor executor;

    ShutdownDeadline(String configId) {
        this.configId = configId;
        this.executor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new DaemonThreadFactory("Shutdown deadline timer"));
        this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
    }

    ShutdownDeadline schedule(long millis, boolean heapdumpOnShutdown) {
        this.executor.schedule(() -> this.onDeadline(heapdumpOnShutdown), millis, TimeUnit.MILLISECONDS);
        return this;
    }

    void cancel() {
        this.executor.shutdownNow();
    }

    @Override
    public void close() {
        this.cancel();
    }

    private void onDeadline(boolean heapdumpOnShutdown) {
        if (heapdumpOnShutdown) {
            Process.dumpHeap((String)this.heapdumpFilename(), (boolean)true);
        }
        Process.logAndDie((String)"Timed out waiting for application shutdown. Please check that all your request handlers drain their request content channels.", (boolean)true);
    }

    private String heapdumpFilename() {
        return Defaults.getDefaults().underVespaHome("var/crash/java_pid.") + ShutdownDeadline.sanitizeFileName(this.configId) + "." + ProcessHandle.current().pid() + ".hprof";
    }

    static String sanitizeFileName(String s) {
        return s.trim().replace('\\', '.').replaceAll("[/,;]", ".");
    }
}

