/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.codegen;

import com.yahoo.config.codegen.CNode;
import com.yahoo.config.codegen.ClassBuilder;
import com.yahoo.config.codegen.CodegenRuntimeException;
import com.yahoo.config.codegen.ConfigGenerator;
import com.yahoo.config.codegen.ConfiggenUtil;
import com.yahoo.config.codegen.InnerCNode;
import com.yahoo.config.codegen.NormalizedDefinition;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;

public class JavaClassBuilder
implements ClassBuilder {
    static final String INDENTATION = "  ";
    private final InnerCNode root;
    private final NormalizedDefinition nd;
    private final String javaPackage;
    private final String className;
    private final File destDir;

    public JavaClassBuilder(InnerCNode root, NormalizedDefinition nd, File destDir, String rawPackagePrefix) {
        this.root = root;
        this.nd = nd;
        String packagePrefix = rawPackagePrefix != null ? rawPackagePrefix : "com.yahoo.";
        this.javaPackage = root.getPackage() != null ? root.getPackage() : packagePrefix + root.getNamespace();
        this.className = ConfiggenUtil.createClassName(root.getName());
        this.destDir = destDir;
    }

    @Override
    public void createConfigClasses() {
        try {
            File outFile = new File(this.getDestPath(this.destDir, this.javaPackage), this.className + ".java");
            try (PrintStream out = new PrintStream(new FileOutputStream(outFile));){
                out.print(this.getConfigClass(this.className));
            }
        }
        catch (FileNotFoundException e) {
            throw new CodegenRuntimeException(e);
        }
    }

    public String getConfigClass(String className) {
        return this.getHeader() + "\n\n" + this.getRootClassDeclaration(this.root, className) + "\n\n" + ConfigGenerator.indentCode(INDENTATION, this.getFrameworkCode()) + "\n\n" + ConfigGenerator.generateContent(INDENTATION, this.root, true) + "\n}\n";
    }

    private String getHeader() {
        return "// ------------   D O   N O T   E D I T !   ------------\n// This file is generated from a config definition file.\n\npackage " + this.javaPackage + ";\n\nimport java.util.*;\nimport java.io.File;\nimport java.nio.file.Path;\nimport com.yahoo.config.*;";
    }

    private String getRootClassDeclaration(InnerCNode root, String className) {
        return "/**\n * This class represents the root node of " + root.getFullName() + "\n *\n" + root.getCommentBlock(" *") + " */\npublic final class " + className + " extends ConfigInstance {\n\n  public final static String CONFIG_DEF_MD5 = \"" + root.getMd5() + "\";\n  public final static String CONFIG_DEF_NAME = \"" + root.getName() + "\";\n  public final static String CONFIG_DEF_NAMESPACE = \"" + root.getNamespace() + "\";\n  public final static String[] CONFIG_DEF_SCHEMA = {\n" + ConfigGenerator.indentCode("    ", this.getDefSchema()) + "\n  };\n\n  public static String getDefMd5()       { return CONFIG_DEF_MD5; }\n  public static String getDefName()      { return CONFIG_DEF_NAME; }\n  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }";
    }

    private String getDefSchema() {
        return this.nd.getNormalizedContent().stream().map(l -> "\"" + l.replace("\"", "\\\"") + "\"").collect(Collectors.joining(",\n"));
    }

    private String getFrameworkCode() {
        return "public interface Producer extends ConfigInstance.Producer {\n  void getConfig(Builder builder);\n}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getDestPath(File rootDir, String javaPackage) {
        File dir = rootDir;
        for (String subDir : javaPackage.split("\\.")) {
            dir = new File(dir, subDir);
            JavaClassBuilder javaClassBuilder = this;
            synchronized (javaClassBuilder) {
                if (!dir.isDirectory() && !dir.mkdir()) {
                    throw new CodegenRuntimeException("Could not create " + dir.getPath());
                }
            }
        }
        return dir;
    }

    static String createUniqueSymbol(CNode node, String basis) {
        Set usedSymbols = Arrays.stream(node.getChildren()).map(CNode::getName).collect(Collectors.toSet());
        Random rng = new Random();
        int i = 1;
        while (true) {
            Object candidate;
            Object object = candidate = i < basis.length() ? basis.substring(0, i) : "__" + basis + rng.nextInt(Integer.MAX_VALUE);
            if (!usedSymbols.contains(candidate)) {
                return candidate;
            }
            ++i;
        }
    }

    public String className() {
        return this.className;
    }

    public String javaPackage() {
        return this.javaPackage;
    }
}

