/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.embedding.config;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class VoyageAiEmbedderConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "f540c47ce2a3c103a4be6f670faefc08";
    public static final String CONFIG_DEF_NAME = "voyage-ai-embedder";
    public static final String CONFIG_DEF_NAMESPACE = "ai.vespa.embedding.config";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=ai.vespa.embedding.config", "apiKeySecretRef string", "endpoint string default=\"https://api.voyageai.com/v1/embeddings\"", "model string", "timeout int default=30000", "maxRetries int default=10", "defaultInputType enum { query, document } default=document", "autoDetectInputType bool default=true", "truncate bool default=true", "maxIdleConnections int default=5", "normalize bool default=false"};
    private final StringNode apiKeySecretRef;
    private final StringNode endpoint;
    private final StringNode model;
    private final IntegerNode timeout;
    private final IntegerNode maxRetries;
    private final DefaultInputType defaultInputType;
    private final BooleanNode autoDetectInputType;
    private final BooleanNode truncate;
    private final IntegerNode maxIdleConnections;
    private final BooleanNode normalize;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public VoyageAiEmbedderConfig(Builder builder) {
        this(builder, true);
    }

    private VoyageAiEmbedderConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for voyage-ai-embedder must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.apiKeySecretRef = builder.apiKeySecretRef == null ? new StringNode() : new StringNode(builder.apiKeySecretRef);
        this.endpoint = builder.endpoint == null ? new StringNode("https://api.voyageai.com/v1/embeddings") : new StringNode(builder.endpoint);
        this.model = builder.model == null ? new StringNode() : new StringNode(builder.model);
        this.timeout = builder.timeout == null ? new IntegerNode(30000) : new IntegerNode(builder.timeout.intValue());
        this.maxRetries = builder.maxRetries == null ? new IntegerNode(10) : new IntegerNode(builder.maxRetries.intValue());
        this.defaultInputType = builder.defaultInputType == null ? new DefaultInputType(DefaultInputType.document) : new DefaultInputType(builder.defaultInputType);
        this.autoDetectInputType = builder.autoDetectInputType == null ? new BooleanNode(true) : new BooleanNode(builder.autoDetectInputType.booleanValue());
        this.truncate = builder.truncate == null ? new BooleanNode(true) : new BooleanNode(builder.truncate.booleanValue());
        this.maxIdleConnections = builder.maxIdleConnections == null ? new IntegerNode(5) : new IntegerNode(builder.maxIdleConnections.intValue());
        this.normalize = builder.normalize == null ? new BooleanNode(false) : new BooleanNode(builder.normalize.booleanValue());
    }

    public String apiKeySecretRef() {
        return this.apiKeySecretRef.value();
    }

    public String endpoint() {
        return this.endpoint.value();
    }

    public String model() {
        return this.model.value();
    }

    public int timeout() {
        return this.timeout.value();
    }

    public int maxRetries() {
        return this.maxRetries.value();
    }

    public DefaultInputType.Enum defaultInputType() {
        return (DefaultInputType.Enum)((Object)this.defaultInputType.value());
    }

    public boolean autoDetectInputType() {
        return this.autoDetectInputType.value();
    }

    public boolean truncate() {
        return this.truncate.value();
    }

    public int maxIdleConnections() {
        return this.maxIdleConnections.value();
    }

    public boolean normalize() {
        return this.normalize.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(VoyageAiEmbedderConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(List.of("apiKeySecretRef", "model"));
        private String apiKeySecretRef = null;
        private String endpoint = null;
        private String model = null;
        private Integer timeout = null;
        private Integer maxRetries = null;
        private DefaultInputType.Enum defaultInputType = null;
        private Boolean autoDetectInputType = null;
        private Boolean truncate = null;
        private Integer maxIdleConnections = null;
        private Boolean normalize = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(VoyageAiEmbedderConfig config) {
            this.apiKeySecretRef(config.apiKeySecretRef());
            this.endpoint(config.endpoint());
            this.model(config.model());
            this.timeout(config.timeout());
            this.maxRetries(config.maxRetries());
            this.defaultInputType(config.defaultInputType());
            this.autoDetectInputType(config.autoDetectInputType());
            this.truncate(config.truncate());
            this.maxIdleConnections(config.maxIdleConnections());
            this.normalize(config.normalize());
        }

        private Builder override(Builder __superior) {
            if (__superior.apiKeySecretRef != null) {
                this.apiKeySecretRef(__superior.apiKeySecretRef);
            }
            if (__superior.endpoint != null) {
                this.endpoint(__superior.endpoint);
            }
            if (__superior.model != null) {
                this.model(__superior.model);
            }
            if (__superior.timeout != null) {
                this.timeout(__superior.timeout);
            }
            if (__superior.maxRetries != null) {
                this.maxRetries(__superior.maxRetries);
            }
            if (__superior.defaultInputType != null) {
                this.defaultInputType(__superior.defaultInputType);
            }
            if (__superior.autoDetectInputType != null) {
                this.autoDetectInputType(__superior.autoDetectInputType);
            }
            if (__superior.truncate != null) {
                this.truncate(__superior.truncate);
            }
            if (__superior.maxIdleConnections != null) {
                this.maxIdleConnections(__superior.maxIdleConnections);
            }
            if (__superior.normalize != null) {
                this.normalize(__superior.normalize);
            }
            return this;
        }

        public Builder apiKeySecretRef(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.apiKeySecretRef = __value;
            this.__uninitialized.remove("apiKeySecretRef");
            return this;
        }

        public Builder endpoint(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.endpoint = __value;
            return this;
        }

        public Builder model(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.model = __value;
            this.__uninitialized.remove("model");
            return this;
        }

        public Builder timeout(int __value) {
            this.timeout = __value;
            return this;
        }

        private Builder timeout(String __value) {
            return this.timeout(Integer.valueOf(__value));
        }

        public Builder maxRetries(int __value) {
            this.maxRetries = __value;
            return this;
        }

        private Builder maxRetries(String __value) {
            return this.maxRetries(Integer.valueOf(__value));
        }

        public Builder defaultInputType(DefaultInputType.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.defaultInputType = __value;
            return this;
        }

        private Builder defaultInputType(String __value) {
            return this.defaultInputType(DefaultInputType.Enum.valueOf(__value));
        }

        public Builder autoDetectInputType(boolean __value) {
            this.autoDetectInputType = __value;
            return this;
        }

        private Builder autoDetectInputType(String __value) {
            return this.autoDetectInputType(Boolean.valueOf(__value));
        }

        public Builder truncate(boolean __value) {
            this.truncate = __value;
            return this;
        }

        private Builder truncate(String __value) {
            return this.truncate(Boolean.valueOf(__value));
        }

        public Builder maxIdleConnections(int __value) {
            this.maxIdleConnections = __value;
            return this;
        }

        private Builder maxIdleConnections(String __value) {
            return this.maxIdleConnections(Integer.valueOf(__value));
        }

        public Builder normalize(boolean __value) {
            this.normalize = __value;
            return this;
        }

        private Builder normalize(String __value) {
            return this.normalize(Boolean.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return VoyageAiEmbedderConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return VoyageAiEmbedderConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return VoyageAiEmbedderConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public VoyageAiEmbedderConfig build() {
            return new VoyageAiEmbedderConfig(this);
        }
    }

    public static final class DefaultInputType
    extends EnumNode<Enum> {
        public static final Enum query = Enum.query;
        public static final Enum document = Enum.document;

        public DefaultInputType() {
            this.value = null;
        }

        public DefaultInputType(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            query,
            document;

        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

