/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.restapi;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.IntegerNode;
import java.util.HashSet;
import java.util.Set;

public final class DocumentOperationExecutorConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "100acebba4d953d02822b77e09cc8873";
    public static final String CONFIG_DEF_NAME = "document-operation-executor";
    public static final String CONFIG_DEF_NAMESPACE = "com.yahoo.document.restapi";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"package=com.yahoo.document.restapi", "resendDelayMillis int default=10", "maxThrottled int default=256", "maxThrottledAge double default=3.0", "maxThrottledBytes double default=-0.25", "maxDocumentOperationRequestSizeMib int default=2048"};
    private final IntegerNode resendDelayMillis;
    private final IntegerNode maxThrottled;
    private final DoubleNode maxThrottledAge;
    private final DoubleNode maxThrottledBytes;
    private final IntegerNode maxDocumentOperationRequestSizeMib;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public DocumentOperationExecutorConfig(Builder builder) {
        this(builder, true);
    }

    private DocumentOperationExecutorConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for document-operation-executor must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.resendDelayMillis = builder.resendDelayMillis == null ? new IntegerNode(10) : new IntegerNode(builder.resendDelayMillis.intValue());
        this.maxThrottled = builder.maxThrottled == null ? new IntegerNode(256) : new IntegerNode(builder.maxThrottled.intValue());
        this.maxThrottledAge = builder.maxThrottledAge == null ? new DoubleNode(3.0) : new DoubleNode(builder.maxThrottledAge.doubleValue());
        this.maxThrottledBytes = builder.maxThrottledBytes == null ? new DoubleNode(-0.25) : new DoubleNode(builder.maxThrottledBytes.doubleValue());
        this.maxDocumentOperationRequestSizeMib = builder.maxDocumentOperationRequestSizeMib == null ? new IntegerNode(2048) : new IntegerNode(builder.maxDocumentOperationRequestSizeMib.intValue());
    }

    public int resendDelayMillis() {
        return this.resendDelayMillis.value();
    }

    public int maxThrottled() {
        return this.maxThrottled.value();
    }

    public double maxThrottledAge() {
        return this.maxThrottledAge.value();
    }

    public double maxThrottledBytes() {
        return this.maxThrottledBytes.value();
    }

    public int maxDocumentOperationRequestSizeMib() {
        return this.maxDocumentOperationRequestSizeMib.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(DocumentOperationExecutorConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer resendDelayMillis = null;
        private Integer maxThrottled = null;
        private Double maxThrottledAge = null;
        private Double maxThrottledBytes = null;
        private Integer maxDocumentOperationRequestSizeMib = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(DocumentOperationExecutorConfig config) {
            this.resendDelayMillis(config.resendDelayMillis());
            this.maxThrottled(config.maxThrottled());
            this.maxThrottledAge(config.maxThrottledAge());
            this.maxThrottledBytes(config.maxThrottledBytes());
            this.maxDocumentOperationRequestSizeMib(config.maxDocumentOperationRequestSizeMib());
        }

        private Builder override(Builder __superior) {
            if (__superior.resendDelayMillis != null) {
                this.resendDelayMillis(__superior.resendDelayMillis);
            }
            if (__superior.maxThrottled != null) {
                this.maxThrottled(__superior.maxThrottled);
            }
            if (__superior.maxThrottledAge != null) {
                this.maxThrottledAge(__superior.maxThrottledAge);
            }
            if (__superior.maxThrottledBytes != null) {
                this.maxThrottledBytes(__superior.maxThrottledBytes);
            }
            if (__superior.maxDocumentOperationRequestSizeMib != null) {
                this.maxDocumentOperationRequestSizeMib(__superior.maxDocumentOperationRequestSizeMib);
            }
            return this;
        }

        public Builder resendDelayMillis(int __value) {
            this.resendDelayMillis = __value;
            return this;
        }

        private Builder resendDelayMillis(String __value) {
            return this.resendDelayMillis(Integer.valueOf(__value));
        }

        public Builder maxThrottled(int __value) {
            this.maxThrottled = __value;
            return this;
        }

        private Builder maxThrottled(String __value) {
            return this.maxThrottled(Integer.valueOf(__value));
        }

        public Builder maxThrottledAge(double __value) {
            this.maxThrottledAge = __value;
            return this;
        }

        private Builder maxThrottledAge(String __value) {
            return this.maxThrottledAge(Double.valueOf(__value));
        }

        public Builder maxThrottledBytes(double __value) {
            this.maxThrottledBytes = __value;
            return this;
        }

        private Builder maxThrottledBytes(String __value) {
            return this.maxThrottledBytes(Double.valueOf(__value));
        }

        public Builder maxDocumentOperationRequestSizeMib(int __value) {
            this.maxDocumentOperationRequestSizeMib = __value;
            return this;
        }

        private Builder maxDocumentOperationRequestSizeMib(String __value) {
            return this.maxDocumentOperationRequestSizeMib(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return DocumentOperationExecutorConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return DocumentOperationExecutorConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return DocumentOperationExecutorConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public DocumentOperationExecutorConfig build() {
            return new DocumentOperationExecutorConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

