/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.config.UrlReference;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Target;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.Value;
import com.yahoo.vespa.defaults.Defaults;
import java.io.File;
import java.time.Duration;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UrlDownloader {
    private static final Logger log = Logger.getLogger(UrlDownloader.class.getName());
    private static final int BASE_ERROR_CODE = 65536;
    public static final int DOES_NOT_EXIST = 65537;
    public static final int INTERNAL_ERROR = 65538;
    public static final int HTTP_ERROR = 65539;
    private final Supervisor supervisor = new Supervisor(new Transport("url-downloader"));
    private final Spec spec = new Spec(Defaults.getDefaults().vespaHostname(), Defaults.getDefaults().vespaConfigProxyRpcPort());
    private Target target;

    public void shutdown() {
        this.supervisor.transport().shutdown().join();
    }

    private void connect() {
        try {
            for (int timeRemaining = 5000; timeRemaining > 0; timeRemaining -= 500) {
                this.target = this.supervisor.connect(this.spec);
                Request request = new Request("frt.rpc.ping");
                this.target.invokeSync(request, Duration.ofSeconds(5L));
                if (!request.isError()) {
                    log.log(Level.FINE, () -> "Successfully connected to '" + String.valueOf(this.spec) + "', this = " + System.identityHashCode(this));
                    return;
                }
                this.target.close();
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isValid() {
        return this.target != null && this.target.isValid();
    }

    public File waitFor(UrlReference urlReference, Duration timeout) {
        return this.waitFor(urlReference, DownloadOptions.defaultOptions(), timeout);
    }

    public File waitFor(UrlReference urlReference, DownloadOptions downloadOptions, Duration timeout) {
        if (!this.isValid()) {
            this.connect();
        }
        Request request = new Request("url.waitFor");
        request.parameters().add((Value)new StringValue(urlReference.value()));
        downloadOptions.authToken().ifPresent(token -> request.parameters().add((Value)new StringValue(token)));
        double rpcTimeout = timeout.toSeconds();
        log.log(Level.FINE, () -> "InvokeSync waitFor " + String.valueOf(urlReference) + " with " + rpcTimeout + " seconds timeout");
        this.target.invokeSync(request, rpcTimeout);
        if (request.checkReturnTypes("s")) {
            return new File(request.returnValues().get(0).asString());
        }
        if (!request.isError()) {
            throw new RuntimeException("Invalid response: " + String.valueOf(request.returnValues()));
        }
        throw new RuntimeException("Wait for " + String.valueOf(urlReference) + " failed: " + request.errorMessage() + " (" + request.errorCode() + ")");
    }

    public record DownloadOptions(Optional<String> authToken) {
        public static DownloadOptions defaultOptions() {
            return new DownloadOptions(Optional.empty());
        }

        public static DownloadOptions ofAuthToken(String authToken) {
            return new DownloadOptions(Optional.ofNullable(authToken));
        }
    }
}

