/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.ConfigSet;
import com.yahoo.config.subscription.impl.ConfigSubscription;
import com.yahoo.vespa.config.ConfigKey;
import java.lang.reflect.Constructor;

public class ConfigSetSubscription<T extends ConfigInstance>
extends ConfigSubscription<T> {
    private final ConfigSet set;
    private final ConfigKey<T> subKey;

    ConfigSetSubscription(ConfigKey<T> key, ConfigSet cset) {
        super(key);
        this.set = cset;
        this.subKey = new ConfigKey(this.configClass, key.getConfigId());
        if (!this.set.contains(this.subKey)) {
            throw new IllegalArgumentException("The given ConfigSet " + String.valueOf(this.set) + " does not contain a config for " + String.valueOf(this.subKey));
        }
        this.setGeneration(0L);
    }

    private boolean hasConfigChanged() {
        T myInstance = this.getNewInstance();
        ConfigSubscription.ConfigState configState = this.getConfigState();
        if (this.checkReloaded()) {
            this.setConfigIfChanged(myInstance);
            return true;
        }
        if (!myInstance.equals(configState.getConfig())) {
            this.setConfigIncGen(myInstance);
            return true;
        }
        return false;
    }

    @Override
    public boolean nextConfig(long timeout) {
        if (this.hasConfigChanged()) {
            return true;
        }
        if (timeout <= 0L) {
            return false;
        }
        long startNanos = System.nanoTime();
        do {
            this.sleep();
            if (!this.hasConfigChanged()) continue;
            return true;
        } while (System.nanoTime() - startNanos < timeout * 1000000L);
        return false;
    }

    private void sleep() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("nextConfig aborted", e);
        }
    }

    @Override
    public boolean subscribe(long timeout) {
        return true;
    }

    private T getNewInstance() {
        try {
            ConfigInstance.Builder builder = this.set.get(this.subKey);
            Constructor<?> constructor = builder.getClass().getDeclaringClass().getConstructor(builder.getClass());
            return (T)((ConfigInstance)constructor.newInstance(builder));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

