/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.benchmark;

import com.yahoo.jrt.Acceptor;
import com.yahoo.jrt.Int32Value;
import com.yahoo.jrt.ListenFailedException;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.Value;
import com.yahoo.system.CommandLineParser;
import com.yahoo.vespa.config.benchmark.Tester;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StressTester {
    private static boolean debug = false;
    private final String testClassName;
    private final List<Thread> threadList = new ArrayList<Thread>();
    private final List<TestRunner> testRunners = new ArrayList<TestRunner>();

    public StressTester(String testClass) {
        this.testClassName = testClass;
    }

    public static void main(String[] args) {
        CommandLineParser parser = new CommandLineParser("StressTester", args);
        parser.addLegalUnarySwitch("-d", "debug");
        parser.addRequiredBinarySwitch("-c", "host (config proxy or server)");
        parser.addRequiredBinarySwitch("-p", "port");
        parser.addLegalBinarySwitch("-class", "Use class with this name from test bundle (must be given in class path)");
        parser.addLegalBinarySwitch("-serverport", "port for rpc server");
        parser.parse();
        String host = (String)parser.getBinarySwitches().get("-c");
        int port = Integer.parseInt((String)parser.getBinarySwitches().get("-p"));
        debug = parser.getUnarySwitches().contains("-d");
        String classNameInBundle = (String)parser.getBinarySwitches().get("-class");
        int serverPort = Integer.parseInt((String)parser.getBinarySwitches().get("-serverport"));
        RpcServer rpcServer = new RpcServer(null, serverPort, new StressTester(classNameInBundle));
        new Thread(rpcServer).start();
    }

    private Map<String, Map<String, String>> getVerificationMap(String verificationFile) {
        HashMap<String, Map<String, String>> verificationMap = new HashMap<String, Map<String, String>>();
        if (verificationFile != null) {
            BufferedReader reader = null;
            try {
                String l;
                reader = new BufferedReader(new FileReader(verificationFile));
                while ((l = reader.readLine()) != null) {
                    String[] line = l.split(",");
                    String defFile = line[0];
                    String fieldName = line[1];
                    String expectedValue = line[2];
                    HashMap<String, String> defExpected = (HashMap<String, String>)verificationMap.get(defFile);
                    if (defExpected == null) {
                        defExpected = new HashMap<String, String>();
                    }
                    defExpected.put(fieldName, expectedValue);
                    verificationMap.put(defFile, defExpected);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to load verification file " + verificationFile);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return verificationMap;
    }

    private void startTesters(int threads) {
        try {
            Class<?> testClass = Class.forName(this.testClassName);
            this.threadList.clear();
            this.testRunners.clear();
            for (int i = 0; i < threads; ++i) {
                Tester tester = (Tester)testClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                TestRunner testRunner = new TestRunner(tester);
                this.testRunners.add(testRunner);
                Thread t = new Thread(testRunner);
                this.threadList.add(t);
            }
            StressTester.debug("Starting testers");
            for (Thread t : this.threadList) {
                StressTester.debug("Starting thread");
                t.start();
            }
        }
        catch (Exception e) {
            StressTester.debug("error in startTesters");
            throw new IllegalArgumentException("Unable to load class with name " + this.testClassName, e);
        }
        StressTester.debug("After starting testers");
    }

    public boolean verify(long generation, long timeout, String verificationFile) throws InterruptedException {
        Map<String, Map<String, String>> verificationMap = this.getVerificationMap(verificationFile);
        for (TestRunner testRunner : this.testRunners) {
            long start = System.currentTimeMillis();
            boolean ok = false;
            do {
                if (testRunner.tester.verify(verificationMap, generation)) {
                    ok = true;
                }
                Thread.sleep(10L);
            } while (!ok && System.currentTimeMillis() - start < timeout);
            if (ok) continue;
            return false;
        }
        return true;
    }

    public void stop() {
        StressTester.debug("Stopping test runners");
        for (TestRunner testRunner : this.testRunners) {
            testRunner.stop();
        }
        StressTester.debug("Stopping threads");
        for (Thread t : this.threadList) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        StressTester.debug("End of stop");
    }

    private static void debug(String s) {
        if (debug) {
            System.out.println(s);
        }
    }

    public static class RpcServer
    implements Runnable {
        private Transport transport = new Transport("rpc-server");
        protected Supervisor supervisor = new Supervisor(this.transport);
        private final Spec spec;
        private final StressTester tester;

        RpcServer(String host, int port, StressTester tester) {
            this.tester = tester;
            this.setUp();
            this.spec = new Spec(host, port);
        }

        @Override
        public void run() {
            try {
                Acceptor acceptor = this.supervisor.listen(this.spec);
                this.supervisor.transport().join();
                acceptor.shutdown().join();
            }
            catch (ListenFailedException e) {
                throw new RuntimeException("Could not listen to " + String.valueOf(this.spec));
            }
        }

        public void shutdown() {
            this.supervisor.transport().shutdown().join();
        }

        private void start(Request request) {
            StressTester.debug("start: Got " + String.valueOf(request));
            int ret = 1;
            int clients = request.parameters().get(0).asInt32();
            StressTester.debug("start: starting testers");
            try {
                this.tester.startTesters(clients);
                ret = 0;
            }
            catch (Exception e) {
                StressTester.debug("start: error: " + e.getMessage());
                e.printStackTrace();
            }
            StressTester.debug("start: Returning " + ret);
            request.returnValues().add((Value)new Int32Value(ret));
        }

        private void verify(Request request) {
            StressTester.debug("verify: Got " + String.valueOf(request));
            long generation = request.parameters().get(0).asInt64();
            String verificationFile = request.parameters().get(1).asString();
            long timeout = request.parameters().get(2).asInt64();
            int ret = 0;
            Object errorMessage = "";
            try {
                if (!this.tester.verify(generation, timeout, verificationFile)) {
                    ret = 1;
                    errorMessage = "Unable to get generation " + generation + " within timeout " + timeout;
                }
            }
            catch (Exception e) {
                ret = 1;
                errorMessage = e.getMessage();
                e.printStackTrace();
            }
            catch (AssertionError e) {
                ret = 1;
                errorMessage = ((Throwable)((Object)e)).getMessage();
            }
            StressTester.debug("verify: Returning " + ret);
            request.returnValues().add((Value)new Int32Value(ret));
            request.returnValues().add((Value)new StringValue((String)errorMessage));
        }

        private void stop(Request request) {
            StressTester.debug("stop: Got " + String.valueOf(request));
            int ret = 1;
            try {
                this.tester.stop();
                ret = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            StressTester.debug("stop: Returning " + ret);
            request.returnValues().add((Value)new Int32Value(ret));
        }

        protected void setUp() {
            this.supervisor.addMethod(new Method("start", "i", "i", this::start).methodDesc("start").paramDesc(0, "clients", "number of clients").returnDesc(0, "ret code", "return code, 0 is OK"));
            this.supervisor.addMethod(new Method("verify", "lsl", "is", this::verify).methodDesc("verify").paramDesc(0, "generation", "config generation").paramDesc(1, "verification file", "name of verification file").paramDesc(2, "timeout", "timeout when verifying").returnDesc(0, "ret code", "return code, 0 is OK").returnDesc(1, "error message", "error message, if non zero return code"));
            this.supervisor.addMethod(new Method("stop", "", "i", this::stop).methodDesc("stop").returnDesc(0, "ret code", "return code, 0 is OK"));
        }
    }

    static class TestRunner
    implements Runnable {
        private final Tester tester;
        private volatile boolean stop = false;

        TestRunner(Tester tester) {
            this.tester = tester;
        }

        @Override
        public void run() {
            this.tester.subscribe();
            while (!this.stop) {
                this.tester.fetch();
            }
            this.tester.close();
        }

        public void stop() {
            this.stop = true;
        }
    }
}

