/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription;

import com.yahoo.config.subscription.ConfigSource;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;

public class FileSource
implements ConfigSource {
    private final File file;

    public FileSource(File file) {
        this.file = file;
        this.validateFile();
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    public List<String> getContent() throws IOException {
        return Files.readAllLines(this.file.toPath());
    }

    public void validateFile() {
        if (!this.file.isFile()) {
            throw new IllegalArgumentException("Not a file: " + this.file);
        }
    }
}

