/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision.security;

import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.NodeType;
import java.util.Objects;
import java.util.Optional;

public class NodeIdentity {
    private final NodeType nodeType;
    private final String identityName;
    private final HostName hostname;
    private final ApplicationId applicationId;

    private NodeIdentity(NodeType nodeType, String identityName, HostName hostname, ApplicationId applicationId) {
        this.nodeType = nodeType;
        this.identityName = identityName;
        this.hostname = hostname;
        this.applicationId = applicationId;
    }

    public NodeType nodeType() {
        return this.nodeType;
    }

    public Optional<String> identityName() {
        return Optional.ofNullable(this.identityName);
    }

    public Optional<HostName> hostname() {
        return Optional.ofNullable(this.hostname);
    }

    public Optional<ApplicationId> applicationId() {
        return Optional.ofNullable(this.applicationId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeIdentity that = (NodeIdentity)o;
        return this.nodeType == that.nodeType && Objects.equals(this.identityName, that.identityName) && Objects.equals((Object)this.hostname, (Object)that.hostname) && Objects.equals(this.applicationId, that.applicationId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.identityName, this.hostname, this.applicationId});
    }

    public String toString() {
        return "NodeIdentity{nodeType=" + String.valueOf((Object)this.nodeType) + ", identityName='" + this.identityName + "', hostname=" + String.valueOf((Object)this.hostname) + ", applicationId=" + String.valueOf(this.applicationId) + "}";
    }

    public static class Builder {
        private final NodeType nodeType;
        private String identityName;
        private HostName hostname;
        private ApplicationId applicationId;

        public Builder(NodeType nodeType) {
            this.nodeType = nodeType;
        }

        public Builder identityName(String identityName) {
            this.identityName = identityName;
            return this;
        }

        public Builder hostname(HostName hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder applicationId(ApplicationId applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public NodeIdentity build() {
            return new NodeIdentity(this.nodeType, this.identityName, this.hostname, this.applicationId);
        }
    }
}

