/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision.zone;

import com.yahoo.config.provision.zone.NodeSlice;
import com.yahoo.config.provision.zone.ZoneApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public record UpgradePolicy(List<Step> steps) {
    public UpgradePolicy(List<Step> steps) {
        Objects.requireNonNull(steps);
        for (int i = 0; i < steps.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (Collections.disjoint(steps.get(i).zones(), steps.get(j).zones())) continue;
                throw new IllegalArgumentException("One or more zones are declared in multiple steps");
            }
        }
        this.steps = List.copyOf(steps);
    }

    public UpgradePolicy inverted() {
        ArrayList<Step> copy = new ArrayList<Step>(this.steps);
        Collections.reverse(copy);
        return new UpgradePolicy(copy);
    }

    public static Builder builder() {
        return new Builder();
    }

    public record Step(Set<ZoneApi> zones, NodeSlice nodeSlice) {
        public Step(Set<ZoneApi> zones, NodeSlice nodeSlice) {
            if (zones.isEmpty()) {
                throw new IllegalArgumentException("A step must contain at least one zone");
            }
            this.zones = Set.copyOf((Collection)Objects.requireNonNull(zones));
            this.nodeSlice = Objects.requireNonNull(nodeSlice);
        }

        public static Step of(ZoneApi ... zone) {
            return new Step(Set.of(zone), NodeSlice.ALL);
        }

        public Step require(NodeSlice slice) {
            return new Step(this.zones, slice);
        }
    }

    public record Builder(List<Step> steps) {
        private Builder() {
            this(new ArrayList<Step>());
        }

        public Builder upgrade(Step step) {
            this.steps.add(step);
            return this;
        }

        public Builder upgrade(ZoneApi zone) {
            return this.upgradeInParallel(zone);
        }

        public Builder upgradeInParallel(ZoneApi ... zone) {
            return this.upgrade(Step.of(zone));
        }

        public UpgradePolicy build() {
            return new UpgradePolicy(this.steps);
        }
    }
}

