/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.SharedHosts;
import com.yahoo.config.provision.Zone;

public class Exclusivity {
    private final Zone zone;
    private final SharedHosts sharedHost;

    public Exclusivity(Zone zone, SharedHosts sharedHost) {
        this.zone = zone;
        this.sharedHost = sharedHost;
    }

    public boolean clusterType(ClusterSpec cluster) {
        return this.sharedHost.hasClusterType(cluster.type());
    }

    public boolean provisioning(ClusterSpec clusterSpec) {
        return !this.zone.cloud().allowHostSharing() && clusterSpec.isExclusive();
    }

    public boolean allocation(ClusterSpec clusterSpec) {
        return clusterSpec.isExclusive() || clusterSpec.type().isContainer() && this.zone.system().isPublic() && !this.zone.environment().isTest() || !this.zone.cloud().allowHostSharing() && !this.sharedHost.supportsClusterType(clusterSpec.type());
    }
}

