/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.documentmodel.NewDocumentType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TopologicalDocumentTypeSorter {
    private final Map<String, NewDocumentType> unsortedTypes = new LinkedHashMap<String, NewDocumentType>();
    private final Map<String, NewDocumentType> sortedTypes = new LinkedHashMap<String, NewDocumentType>();

    private TopologicalDocumentTypeSorter(Collection<NewDocumentType> documentTypes) {
        documentTypes.forEach(docType -> this.unsortedTypes.put(docType.getName(), (NewDocumentType)docType));
        this.unsortedTypes.values().forEach(docType -> this.depthFirstTraverse((NewDocumentType)docType));
    }

    private void depthFirstTraverse(NewDocumentType docType) {
        if (this.sortedTypes.containsKey(docType.getName())) {
            return;
        }
        for (NewDocumentType.Name referenceDocTypeName : docType.getDocumentReferences()) {
            NewDocumentType referenceDocType = this.unsortedTypes.get(referenceDocTypeName.getName());
            this.depthFirstTraverse(referenceDocType);
        }
        this.sortedTypes.put(docType.getName(), docType);
    }

    public static List<NewDocumentType> sort(Collection<NewDocumentType> documentTypes) {
        TopologicalDocumentTypeSorter sorter = new TopologicalDocumentTypeSorter(documentTypes);
        return new ArrayList<NewDocumentType>(sorter.sortedTypes.values());
    }
}

