/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.component;

import com.yahoo.collections.Pair;
import com.yahoo.container.ComponentsConfig;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.component.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ComponentsConfigGenerator {
    public static List<ComponentsConfig.Components.Builder> generate(Collection<? extends Component<?, ?>> components) {
        ArrayList<ComponentsConfig.Components.Builder> result = new ArrayList<ComponentsConfig.Components.Builder>();
        for (Component<?, ?> component : components) {
            result.add(ComponentsConfigGenerator.componentsConfig(component));
        }
        return result;
    }

    public static ComponentsConfig.Components.Builder componentsConfig(Component<?, ?> component) {
        ComponentsConfig.Components.Builder builder = new ComponentsConfig.Components.Builder();
        builder.id(component.getGlobalComponentId().stringValue());
        builder.configId(component.getConfigId());
        ComponentsConfigGenerator.bundleInstantiationSpecification(builder, ((ComponentModel)component.model).bundleInstantiationSpec);
        builder.inject.addAll(ComponentsConfigGenerator.componentsToInject(component.injectedComponents));
        return builder;
    }

    private static void bundleInstantiationSpecification(ComponentsConfig.Components.Builder config, BundleInstantiationSpecification spec) {
        config.classId(spec.classId.stringValue());
        config.bundle(spec.bundle.stringValue());
    }

    private static List<ComponentsConfig.Components.Inject.Builder> componentsToInject(Collection<Pair<String, Component>> injectedComponents) {
        ArrayList<ComponentsConfig.Components.Inject.Builder> result = new ArrayList<ComponentsConfig.Components.Inject.Builder>();
        for (Pair<String, Component> injected : injectedComponents) {
            ComponentsConfig.Components.Inject.Builder builder = new ComponentsConfig.Components.Inject.Builder();
            builder.id(((Component)injected.getSecond()).getGlobalComponentId().stringValue());
            builder.name((String)injected.getFirst());
            result.add(builder);
        }
        return result;
    }
}

