/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container;

import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.handler.threadpool.ContainerThreadpoolConfig;
import com.yahoo.container.handler.threadpool.ContainerThreadpoolImpl;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import java.util.logging.Level;
import org.w3c.dom.Element;

public abstract class ContainerThreadpool
extends SimpleComponent
implements ContainerThreadpoolConfig.Producer {
    private final String name;
    private final UserOptions options;

    protected ContainerThreadpool(DeployState ds, String name, Element parent) {
        super(new ComponentModel(BundleInstantiationSpecification.fromStrings((String)("threadpool@" + name), (String)ContainerThreadpoolImpl.class.getName(), null)));
        this.name = name;
        Element threadpoolElem = XmlHelper.getOptionalChild(parent, "threadpool").orElse(null);
        if (threadpoolElem == null) {
            this.options = new UserOptions(null, null, null);
        } else {
            Element threadsElem;
            Element maxElem;
            Double max = null;
            Double min = null;
            Double queue = null;
            Element minElem = XmlHelper.getOptionalChild(threadpoolElem, "min-threads").orElse(null);
            if (minElem != null) {
                ds.getDeployLogger().logApplicationPackage(Level.WARNING, "For <threadpool>: <min-threads> is deprecated, use <threads> instead");
            }
            if ((maxElem = (Element)XmlHelper.getOptionalChild(threadpoolElem, "max-threads").orElse(null)) != null) {
                ds.getDeployLogger().logApplicationPackage(Level.WARNING, "For <threadpool>: <max-threads> is deprecated, use <threads> with 'boost' instead");
            }
            Element queueElem = XmlHelper.getOptionalChild(threadpoolElem, "queue").orElse(null);
            Element queueSizeElem = XmlHelper.getOptionalChild(threadpoolElem, "queue-size").orElse(null);
            if (queueSizeElem != null) {
                ds.getDeployLogger().logApplicationPackage(Level.WARNING, "For <threadpool>: <queue-size> is deprecated, use <queue> instead");
            }
            if ((threadsElem = (Element)XmlHelper.getOptionalChild(threadpoolElem, "threads").orElse(null)) != null) {
                min = ContainerThreadpool.parseMultiplier(threadsElem.getTextContent());
                max = threadsElem.hasAttribute("boost") ? ContainerThreadpool.parseMultiplier(threadsElem.getAttribute("boost")) : min;
            } else if (minElem != null) {
                min = ContainerThreadpool.parseFixed(minElem.getTextContent());
            }
            if (max == null && maxElem != null) {
                max = ContainerThreadpool.parseFixed(maxElem.getTextContent());
            }
            if (queueElem != null) {
                queue = ContainerThreadpool.parseMultiplier(queueElem.getTextContent());
            } else if (queueSizeElem != null) {
                queue = ContainerThreadpool.parseFixed(queueSizeElem.getTextContent());
            }
            this.options = new UserOptions(max, min, queue);
        }
    }

    private static Double parseMultiplier(String text) {
        return -ContainerThreadpool.parseFixed(text).doubleValue();
    }

    private static Double parseFixed(String text) {
        return Double.parseDouble(text);
    }

    protected abstract void setDefaultConfigValues(ContainerThreadpoolConfig.Builder var1);

    public void getConfig(ContainerThreadpoolConfig.Builder builder) {
        this.setDefaultConfigValues(builder);
        builder.name(this.name);
        if (this.options.max() != null) {
            int max = (int)Math.round(this.options.max());
            if (this.options.max() != 0.0 && max == 0) {
                max = this.options.max() > 0.0 ? 1 : -1;
            }
            builder.maxThreads(max);
        }
        if (this.options.min() != null) {
            int min = (int)Math.round(this.options.min());
            if (this.options.min() != 0.0 && min == 0) {
                min = this.options.min() > 0.0 ? 1 : -1;
            }
            builder.minThreads(min);
        }
        if (this.options.queue() != null) {
            int queue = (int)Math.round(this.options.queue());
            if (this.options.queue() != 0.0 && queue == 0) {
                queue = this.options.queue() > 0.0 ? 1 : -1;
            }
            builder.queueSize(queue);
        }
    }

    record UserOptions(Double max, Double min, Double queue) {
    }
}

