/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.model.api.ConfigChangeRefeedAction;
import com.yahoo.config.model.api.ServiceInfo;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.vespa.model.application.validation.change.VespaConfigChangeAction;
import java.util.List;
import java.util.Optional;

public class VespaRefeedAction
extends VespaConfigChangeAction
implements ConfigChangeRefeedAction {
    private final ValidationId validationId;
    private final String documentType;

    private VespaRefeedAction(ClusterSpec.Id id, ValidationId validationId, String message, List<ServiceInfo> services, String documentType) {
        super(id, message, services);
        this.validationId = validationId;
        this.documentType = documentType;
    }

    public static VespaRefeedAction of(ClusterSpec.Id id, ValidationId validationId, String message) {
        return new VespaRefeedAction(id, validationId, message, List.of(), "");
    }

    public static VespaRefeedAction of(ClusterSpec.Id id, ValidationId validationId, String message, List<ServiceInfo> services, String documentType) {
        return new VespaRefeedAction(id, validationId, message, services, documentType);
    }

    @Override
    public VespaConfigChangeAction modifyAction(String newMessage, List<ServiceInfo> newServices, String documentType) {
        return new VespaRefeedAction(this.clusterId(), this.validationId, newMessage, newServices, documentType);
    }

    public Optional<ValidationId> validationId() {
        return Optional.of(this.validationId);
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public boolean ignoreForInternalRedeploy() {
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + ", documentType='" + this.documentType + "'";
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof VespaRefeedAction)) {
            return false;
        }
        VespaRefeedAction other = (VespaRefeedAction)o;
        if (!this.documentType.equals(other.documentType)) {
            return false;
        }
        return this.validationId.equals((Object)other.validationId);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + 11 * this.validationId.hashCode() + this.documentType.hashCode();
    }
}

