/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import com.yahoo.cloud.config.SentinelConfig;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.vespa.model.ConfigSentinel;
import com.yahoo.vespa.model.HostSystem;
import java.util.Objects;

public final class Host
extends TreeConfigProducer<AnyConfigProducer>
implements SentinelConfig.Producer,
Comparable<Host> {
    public static final double memoryOverheadGb = 0.7;
    private ConfigSentinel configSentinel = null;
    private final String hostname;
    private final boolean runsConfigServer;

    public Host(TreeConfigProducer<? super Host> parent, String hostname) {
        this(parent, hostname, false);
    }

    private Host(TreeConfigProducer<? super Host> parent, String hostname, boolean runsConfigServer) {
        super(parent, hostname);
        Objects.requireNonNull(hostname, "The host name of a host cannot be null");
        this.runsConfigServer = runsConfigServer;
        this.hostname = hostname;
    }

    public static Host createConfigServerHost(HostSystem hostSystem, String hostname) {
        return new Host(hostSystem, hostname, true);
    }

    public static Host createHost(HostSystem hostSystem, String hostname) {
        return new Host(hostSystem, hostname, false);
    }

    public String getHostname() {
        return this.hostname;
    }

    public boolean runsConfigServer() {
        return this.runsConfigServer;
    }

    public String toString() {
        return "host '" + this.getHostname() + "'";
    }

    public void getConfig(SentinelConfig.Builder builder) {
        if (this.configSentinel != null) {
            this.configSentinel.getConfig(builder);
        }
    }

    public void setConfigSentinel(ConfigSentinel configSentinel) {
        this.configSentinel = configSentinel;
    }

    public int hashCode() {
        return this.hostname.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Host)) {
            return false;
        }
        return ((Host)other).hostname.equals(this.hostname);
    }

    @Override
    public int compareTo(Host other) {
        return this.hostname.compareTo(other.hostname);
    }
}

