/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.documentmodel;

import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.vespa.documentmodel.FieldView;
import com.yahoo.vespa.documentmodel.SearchField;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class SchemaDef {
    private static final Logger log = Logger.getLogger(SchemaDef.class.getName());
    private final String name;
    private final DocumentTypeManager sources = new DocumentTypeManager();
    private final Map<String, SearchField> fields = new HashMap<String, SearchField>();
    private final Map<String, FieldView> views = new HashMap<String, FieldView>();
    private final Map<String, String> aliases = new HashMap<String, String>();

    public SchemaDef(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, SearchField> getFields() {
        return this.fields;
    }

    public Map<String, FieldView> getViews() {
        return this.views;
    }

    public SchemaDef add(DocumentType source) {
        this.sources.registerDocumentType(source);
        return this;
    }

    private void noShadowing(String name) {
        this.noFieldShadowing(name);
        this.noViewShadowing(name);
    }

    private void noFieldShadowing(String name) {
        if (this.fields.containsKey(name)) {
            throw new IllegalArgumentException("Schema '" + this.getName() + "' already contains the fields '" + this.fields + "'. You are trying to add '" + name + "'. Shadowing is not supported");
        }
    }

    private void noViewShadowing(String name) {
        if (this.views.containsKey(name)) {
            throw new IllegalArgumentException("Searchdef '" + this.getName() + "' already contains a view with name '" + name + "'. Shadowing is not supported.");
        }
    }

    public SchemaDef add(SearchField field) {
        block2: {
            try {
                this.noFieldShadowing(field.getName());
                this.fields.put(field.getName(), field);
            }
            catch (IllegalArgumentException e) {
                if (!this.views.containsKey(field.getName())) break block2;
                throw e;
            }
        }
        return this;
    }

    public SchemaDef addAlias(String alias, String aliased) {
        String oldAliased;
        this.noShadowing(alias);
        if (!this.fields.containsKey(aliased) && !this.views.containsKey(aliased)) {
            if (aliased.contains(".")) {
                log.warning("Aliased item '" + aliased + "' not verifiable. Allowing it to be aliased to '" + alias + " for now. Validation will come when URL/Position is structified.");
            } else {
                throw new IllegalArgumentException("Searchdef '" + this.getName() + "' has nothing named '" + aliased + "'to alias to '" + alias + "'.");
            }
        }
        if ((oldAliased = this.aliases.get(alias)) != null) {
            if (oldAliased.equals(aliased)) {
                throw new IllegalArgumentException("Searchdef '" + this.getName() + "' already has the alias '" + alias + "' to '" + aliased + ". Why do you want to add it again.");
            }
            throw new IllegalArgumentException("Searchdef '" + this.getName() + "' already has the alias '" + alias + "' to '" + oldAliased + ". Cannot change it to alias '" + aliased + "'.");
        }
        this.aliases.put(alias, aliased);
        return this;
    }

    public SchemaDef add(FieldView view) {
        this.noViewShadowing(view.getName());
        if (this.views.containsKey(view.getName())) {
            this.views.get(view.getName()).add(view);
        }
        this.views.put(view.getName(), view);
        return this;
    }
}

