/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.document.PositionDataType;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.ImmutableImportedComplexSDField;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.stream.Stream;

public class AddDataTypeAndTransformToSummaryOfImportedFields
extends Processor {
    public AddDataTypeAndTransformToSummaryOfImportedFields(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        this.schema.allImportedFields().forEach(this::setTransform);
    }

    private Stream<SummaryField> getSummaryFieldsForImportedField(ImmutableSDField importedField) {
        return this.schema.getSummaryFields(importedField).stream();
    }

    private void setTransform(ImmutableSDField field) {
        if (field instanceof ImmutableImportedComplexSDField) {
            this.getSummaryFieldsForImportedField(field).forEach(summaryField -> AddDataTypeAndTransformToSummaryOfImportedFields.setAttributeCombinerTransform(field, summaryField));
        } else {
            this.getSummaryFieldsForImportedField(field).forEach(summaryField -> AddDataTypeAndTransformToSummaryOfImportedFields.setAttributeTransform(field, summaryField));
        }
    }

    private static void setAttributeTransform(ImmutableSDField field, SummaryField summaryField) {
        if (summaryField.hasUnresolvedType()) {
            if (field.getDataType().equals((Object)DataType.LONG) && summaryField.getTransform().equals((Object)SummaryTransform.GEOPOS)) {
                summaryField.setResolvedDataType((DataType)PositionDataType.INSTANCE);
            } else {
                summaryField.setResolvedDataType(field.getDataType());
            }
        }
        if (summaryField.getTransform() == SummaryTransform.NONE) {
            summaryField.setTransform(SummaryTransform.ATTRIBUTE);
        }
    }

    private static void setAttributeCombinerTransform(ImmutableSDField field, SummaryField summaryField) {
        if (summaryField.hasUnresolvedType()) {
            summaryField.setResolvedDataType(field.getDataType());
        }
        if (summaryField.getTransform() == SummaryTransform.MATCHED_ATTRIBUTE_ELEMENTS_FILTER) {
            return;
        }
        if (summaryField.getTransform() == SummaryTransform.MATCHED_ELEMENTS_FILTER) {
            summaryField.setTransform(SummaryTransform.MATCHED_ATTRIBUTE_ELEMENTS_FILTER);
        } else {
            summaryField.setTransform(SummaryTransform.ATTRIBUTECOMBINER);
        }
    }
}

