/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.parser;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.language.Linguistics;
import com.yahoo.language.process.Embedder;
import com.yahoo.language.process.TextGenerator;
import com.yahoo.language.simple.SimpleLinguistics;
import com.yahoo.path.Path;
import com.yahoo.schema.DistributableResource;
import com.yahoo.schema.FeatureNames;
import com.yahoo.schema.OnnxModel;
import com.yahoo.schema.RankProfile;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Case;
import com.yahoo.schema.document.HnswIndexParams;
import com.yahoo.schema.document.MatchAlgorithm;
import com.yahoo.schema.document.MatchType;
import com.yahoo.schema.document.Sorting;
import com.yahoo.schema.document.Stemming;
import com.yahoo.schema.fieldoperation.IndexingOperation;
import com.yahoo.schema.parser.CharStream;
import com.yahoo.schema.parser.DictionaryOption;
import com.yahoo.schema.parser.ParseException;
import com.yahoo.schema.parser.ParsedAnnotation;
import com.yahoo.schema.parser.ParsedAttribute;
import com.yahoo.schema.parser.ParsedDocument;
import com.yahoo.schema.parser.ParsedDocumentSummary;
import com.yahoo.schema.parser.ParsedField;
import com.yahoo.schema.parser.ParsedFieldSet;
import com.yahoo.schema.parser.ParsedIndex;
import com.yahoo.schema.parser.ParsedIndexingOp;
import com.yahoo.schema.parser.ParsedMatchSettings;
import com.yahoo.schema.parser.ParsedRankFunction;
import com.yahoo.schema.parser.ParsedRankProfile;
import com.yahoo.schema.parser.ParsedSchema;
import com.yahoo.schema.parser.ParsedSorting;
import com.yahoo.schema.parser.ParsedStruct;
import com.yahoo.schema.parser.ParsedSummaryField;
import com.yahoo.schema.parser.ParsedType;
import com.yahoo.schema.parser.SchemaParserConstants;
import com.yahoo.schema.parser.SchemaParserTokenManager;
import com.yahoo.schema.parser.SimpleCharStream;
import com.yahoo.schema.parser.Token;
import com.yahoo.schema.parser.Utils;
import com.yahoo.search.query.ranking.Diversity;
import com.yahoo.search.schema.RankProfile;
import com.yahoo.searchlib.rankingexpression.FeatureList;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.tensor.IndexedTensor;
import com.yahoo.tensor.MixedTensor;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;
import com.yahoo.tensor.TensorType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;

public class SchemaParser
implements SchemaParserConstants {
    private DeployLogger deployLogger;
    private ModelContext.Properties properties;
    public SchemaParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[239];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private static int[] jj_la1_6;
    private static int[] jj_la1_7;
    private final JJCalls[] jj_2_rtns = new JJCalls[10];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public SchemaParser(SimpleCharStream stream, DeployLogger deployLogger, ModelContext.Properties properties) {
        this(stream);
        this.deployLogger = deployLogger;
        this.properties = properties;
    }

    private IndexingOperation newIndexingOperation(boolean multiline) throws ParseException {
        return this.newIndexingOperation(multiline, (Linguistics)new SimpleLinguistics(), Embedder.throwsOnUse.asMap(), TextGenerator.throwsOnUse.asMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexingOperation newIndexingOperation(boolean multiline, Linguistics linguistics, Map<String, Embedder> embedders, Map<String, TextGenerator> generators) throws ParseException {
        SimpleCharStream input = (SimpleCharStream)this.token_source.input_stream;
        if (this.token.next != null) {
            input.backup(this.token.next.image.length());
        }
        try {
            IndexingOperation indexingOperation = IndexingOperation.fromStream(input, multiline, linguistics, embedders, generators);
            return indexingOperation;
        }
        finally {
            this.token.next = null;
            this.jj_ntk = -1;
        }
    }

    private FeatureList getFeatureList(String image) throws ParseException {
        try {
            return new FeatureList(image);
        }
        catch (com.yahoo.searchlib.rankingexpression.parser.ParseException e) {
            throw (ParseException)new ParseException("Could not parse feature list '" + image + "' at line " + this.token_source.input_stream.getBeginLine() + ", column " + this.token_source.input_stream.getBeginColumn() + ".").initCause(e);
        }
    }

    public final ParsedSchema schema() throws ParseException {
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(5);
        }
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8, 9 -> this.rootSchema();
            case 0, 16 -> this.rootDocument();
            default -> {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final ParsedSchema rootSchema() throws ParseException {
        String inherited = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String name = this.identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                inherited = this.identifier();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        ParsedSchema schema = new ParsedSchema(name);
        if (inherited != null) {
            schema.inherit(inherited);
        }
        this.lbrace();
        block16: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 16: 
                case 22: 
                case 24: 
                case 26: 
                case 28: 
                case 32: 
                case 36: 
                case 49: 
                case 50: 
                case 63: 
                case 66: 
                case 67: 
                case 95: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block16;
                }
            }
            this.rootSchemaItem(schema);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        continue block16;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(138);
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block18;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(0);
        return schema;
    }

    public final void rootSchemaItem(ParsedSchema schema) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: {
                this.document(schema);
                break;
            }
            case 67: {
                this.rawAsBase64(schema);
                break;
            }
            case 95: {
                this.searchStemming(schema);
                break;
            }
            case 28: {
                this.importField(schema);
                break;
            }
            case 49: {
                this.rankingConstant(schema);
                break;
            }
            case 63: 
            case 66: {
                this.rankProfile(schema);
                break;
            }
            case 32: {
                this.documentSummary(schema);
                break;
            }
            case 24: {
                this.fieldOutsideDoc(schema);
                break;
            }
            case 36: {
                this.indexOutsideDoc(schema);
                break;
            }
            case 22: {
                this.structOutside(schema);
                break;
            }
            case 6: {
                this.annotationOutside(schema);
                break;
            }
            case 26: {
                this.fieldSet(schema);
                break;
            }
            case 50: {
                this.onnxModelInSchema(schema);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final ParsedSchema rootDocument() throws ParseException {
        ParsedSchema schema = null;
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block6;
                }
            }
            schema = this.rootDocumentItem(schema);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(0);
        return schema;
    }

    public final ParsedSchema rootDocumentItem(ParsedSchema schema) throws ParseException {
        ParsedDocument doc = null;
        doc = this.namedDocument();
        if (schema == null) {
            schema = new ParsedSchema(doc.name());
        }
        schema.addDocument(doc);
        schema.setDocumentWithoutSchema();
        return schema;
    }

    public final void document(ParsedSchema schema) throws ParseException {
        String name = schema.name();
        this.jj_consume_token(16);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 124: 
            case 126: 
            case 130: 
            case 131: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 152: 
            case 158: 
            case 159: 
            case 160: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 211: 
            case 213: 
            case 214: 
            case 215: 
            case 221: {
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block21;
                }
            }
            this.jj_consume_token(5);
        }
        ParsedDocument document = new ParsedDocument(name);
        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.inheritsDocument(document);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[12] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        this.jj_consume_token(137);
        block23: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block23;
                }
            }
            this.jj_consume_token(5);
        }
        block24: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 22: 
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block24;
                }
            }
            this.documentBody(document);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                        continue block24;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(138);
        schema.addDocument(document);
    }

    public final ParsedDocument namedDocument() throws ParseException {
        this.jj_consume_token(16);
        String name = this.identifier();
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block18;
                }
            }
            this.jj_consume_token(5);
        }
        ParsedDocument document = new ParsedDocument(name);
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.inheritsDocument(document);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[18] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        this.jj_consume_token(137);
        block20: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block20;
                }
            }
            this.jj_consume_token(5);
        }
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 22: 
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block21;
                }
            }
            this.documentBody(document);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        continue block21;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(138);
        return document;
    }

    public final void documentBody(ParsedDocument document) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: {
                this.annotation(document);
                break;
            }
            case 22: {
                this.structInside(document);
                break;
            }
            case 24: {
                this.fieldInsideDoc(document);
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void rawAsBase64(ParsedSchema schema) throws ParseException {
        boolean enabled = false;
        this.jj_consume_token(67);
        enabled = true;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 139: {
                this.jj_consume_token(139);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 105: {
                        this.jj_consume_token(105);
                        break block0;
                    }
                    case 106: {
                        this.jj_consume_token(106);
                        enabled = false;
                        break block0;
                    }
                }
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        schema.enableRawAsBase64(enabled);
    }

    public final void inheritsStruct(ParsedStruct struct) throws ParseException {
        this.jj_consume_token(23);
        String name = this.identifier();
        struct.inherit(name);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 141: {
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(141);
            name = this.identifier();
            struct.inherit(name);
        }
    }

    public final void inheritsDocument(ParsedDocument document) throws ParseException {
        this.jj_consume_token(23);
        String name = this.identifier();
        document.inherit(name);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 141: {
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(141);
            name = this.identifier();
            document.inherit(name);
        }
    }

    public final void fieldInsideDoc(ParsedDocument document) throws ParseException {
        ParsedField field = this.field();
        document.addField(field);
    }

    public final void fieldOutsideDoc(ParsedSchema schema) throws ParseException {
        ParsedField field = this.field();
        schema.addField(field);
    }

    public final ParsedField field() throws ParseException {
        this.jj_consume_token(24);
        String name = this.identifier();
        this.jj_consume_token(35);
        ParsedType type = this.dataType();
        if (name != null && Schema.isReservedName(name.toLowerCase())) {
            throw new IllegalArgumentException("Reserved name '" + name + "' can not be used as a field name.");
        }
        ParsedField field = new ParsedField(name, type);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 27: 
                case 30: 
                case 31: 
                case 33: 
                case 34: 
                case 36: 
                case 68: 
                case 79: 
                case 80: 
                case 81: 
                case 95: 
                case 96: 
                case 101: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 118: 
                case 143: {
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                    break block6;
                }
            }
            this.fieldBody(field);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[29] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(138);
        return field;
    }

    public final void fieldSet(ParsedSchema schema) throws ParseException {
        this.jj_consume_token(26);
        String name = this.identifier();
        this.lbrace();
        ParsedFieldSet fieldSet = new ParsedFieldSet(name);
        block18: while (true) {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 25: {
                    this.jj_consume_token(25);
                    this.jj_consume_token(139);
                    name = this.identifier();
                    fieldSet.addField(name);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 141: {
                                break;
                            }
                            default: {
                                this.jj_la1[30] = this.jj_gen;
                                break block0;
                            }
                        }
                        this.jj_consume_token(141);
                        name = this.identifier();
                        fieldSet.addField(name);
                    }
                }
                case 108: {
                    this.jj_consume_token(108);
                    this.jj_consume_token(139);
                    fieldSet.addQueryCommand(switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 142, 143, 144, 145, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 211, 213, 214, 215, 221 -> this.identifierWithDash();
                        case 209, 210 -> this.quotedString();
                        default -> {
                            this.jj_la1[31] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    });
                    break;
                }
                case 110: {
                    this.matchSettings(fieldSet.matchSettings());
                    break;
                }
                default: {
                    this.jj_la1[32] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block20: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[33] = this.jj_gen;
                        break block20;
                    }
                }
                this.jj_consume_token(5);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 25: 
                case 108: 
                case 110: {
                    continue block18;
                }
            }
            break;
        }
        this.jj_la1[34] = this.jj_gen;
        this.jj_consume_token(138);
        schema.addFieldSet(fieldSet);
    }

    public final void annotationOutside(ParsedSchema schema) throws ParseException {
        this.jj_consume_token(6);
        String name = this.identifier();
        ParsedAnnotation type = new ParsedAnnotation(name);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.inheritsAnnotation(type);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[35] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
        this.lbrace();
        this.annotationBody(type);
        this.jj_consume_token(138);
        schema.addAnnotation(type);
    }

    public final void annotation(ParsedDocument document) throws ParseException {
        this.jj_consume_token(6);
        String name = this.identifier();
        ParsedAnnotation type = new ParsedAnnotation(name);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.inheritsAnnotation(type);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[37] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
        this.lbrace();
        this.annotationBody(type);
        this.jj_consume_token(138);
        document.addAnnotation(type);
    }

    public final void annotationBody(ParsedAnnotation type) throws ParseException {
        ParsedStruct struct = new ParsedStruct("annotation." + type.name());
        boolean seenField = false;
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                    break block6;
                }
            }
            this.structFieldDefinition(struct);
            seenField = true;
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[40] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        if (seenField) {
            type.setStruct(struct);
        }
    }

    public final void inheritsAnnotation(ParsedAnnotation annotation) throws ParseException {
        this.jj_consume_token(23);
        String name = this.identifier();
        annotation.inherit(name);
    }

    public final void structInside(ParsedDocument document) throws ParseException {
        ParsedStruct struct = this.structDefinition();
        document.addStruct(struct);
    }

    public final void structOutside(ParsedSchema schema) throws ParseException {
        ParsedStruct struct = this.structDefinition();
        schema.addStruct(struct);
    }

    public final ParsedStruct structDefinition() throws ParseException {
        this.jj_consume_token(22);
        String name = this.identifier();
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[41] = this.jj_gen;
                    break block15;
                }
            }
            this.jj_consume_token(5);
        }
        ParsedStruct struct = new ParsedStruct(name);
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.inheritsStruct(struct);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[42] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
        this.lbrace();
        block17: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 24: {
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                    break block17;
                }
            }
            this.structFieldDefinition(struct);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[45] = this.jj_gen;
                        continue block17;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(138);
        return struct;
    }

    public final ParsedType dataType() throws ParseException {
        String typeName = null;
        boolean isArrayOldStyle = false;
        ParsedType mapType = null;
        ParsedType arrayType = null;
        ParsedType wsetType = null;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            this.jj_consume_token(142);
            this.jj_consume_token(219);
            arrayType = this.dataType();
            this.jj_consume_token(220);
            return ParsedType.arrayOf(arrayType);
        }
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            this.jj_consume_token(143);
            this.jj_consume_token(219);
            wsetType = this.dataType();
            this.jj_consume_token(220);
            return ParsedType.wsetOf(wsetType);
        }
        if (this.jj_2_3(Integer.MAX_VALUE)) {
            mapType = this.mapDataType();
            return mapType;
        }
        if (this.jj_2_4(Integer.MAX_VALUE)) {
            mapType = this.annotationRefDataType();
            return mapType;
        }
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            TensorType tensorType = this.tensorType("Field type");
            return ParsedType.tensorType(tensorType);
        }
        if (this.jj_2_6(Integer.MAX_VALUE)) {
            this.jj_consume_token(145);
            this.jj_consume_token(219);
            ParsedType referenceType = this.referenceType();
            this.jj_consume_token(220);
            return ParsedType.documentRef(referenceType);
        }
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 124: 
            case 126: 
            case 130: 
            case 131: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 152: 
            case 158: 
            case 159: 
            case 160: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 211: 
            case 213: 
            case 214: 
            case 215: 
            case 221: {
                typeName = this.identifier();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 225: {
                        this.jj_consume_token(225);
                        isArrayOldStyle = true;
                        break block0;
                    }
                }
                this.jj_la1[46] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        ParsedType type = ParsedType.fromName(typeName);
        if (isArrayOldStyle) {
            this.deployLogger.logApplicationPackage(Level.WARNING, "Data type syntax '" + typeName + "[]' is deprecated, use 'array<" + typeName + ">' instead.");
            type = ParsedType.arrayOf(type);
        }
        return type;
    }

    public final ParsedType referenceType() throws ParseException {
        String documentName = this.identifier();
        return ParsedType.documentType(documentName);
    }

    public final ParsedType annotationRefDataType() throws ParseException {
        this.jj_consume_token(7);
        this.jj_consume_token(219);
        String targetName = this.identifier();
        this.jj_consume_token(220);
        return ParsedType.annotationRef(targetName);
    }

    public final ParsedType mapDataType() throws ParseException {
        this.jj_consume_token(144);
        this.jj_consume_token(219);
        ParsedType keyType = this.dataType();
        this.jj_consume_token(141);
        ParsedType valType = this.dataType();
        this.jj_consume_token(220);
        return ParsedType.mapType(keyType, valType);
    }

    public final void structFieldDefinition(ParsedStruct struct) throws ParseException {
        this.jj_consume_token(24);
        String name = this.identifier();
        this.jj_consume_token(35);
        ParsedType type = this.dataType();
        if (name != null && Schema.isReservedName(name.toLowerCase())) {
            throw new IllegalArgumentException("Reserved name '" + name + "' can not be used as a field name.");
        }
        ParsedField field = new ParsedField(name, type);
        this.lbrace();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 118: {
                this.id(field);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[48] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(5);
                }
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
            }
        }
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 110: {
                    break;
                }
                default: {
                    this.jj_la1[50] = this.jj_gen;
                    break block13;
                }
            }
            this.matchSettings(field.matchSettings());
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[51] = this.jj_gen;
                        continue block13;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(138);
        struct.addField(field);
    }

    public final void structField(ParsedField field) throws ParseException {
        this.jj_consume_token(27);
        String name = this.identifier();
        if (name != null && Schema.isReservedName(name.toLowerCase())) {
            throw new IllegalArgumentException("Reserved name '" + name + "' can not be used as a field name.");
        }
        ParsedField structField = new ParsedField(name, null);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 27: 
                case 30: 
                case 31: 
                case 68: 
                case 79: 
                case 108: 
                case 110: 
                case 111: {
                    break;
                }
                default: {
                    this.jj_la1[52] = this.jj_gen;
                    break block6;
                }
            }
            this.structFieldBody(structField);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[53] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(138);
        field.addStructField(structField);
    }

    public final void fieldBody(ParsedField field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 109: {
                this.alias(field);
                break;
            }
            case 79: {
                this.attribute(field);
                break;
            }
            case 101: {
                this.bolding(field);
                break;
            }
            case 81: {
                this.dictionary(field);
                break;
            }
            case 95: {
                this.fieldStemming(field);
                break;
            }
            case 118: {
                this.id(field);
                break;
            }
            case 68: {
                this.summaryInField(field);
                break;
            }
            case 36: {
                this.indexInsideField(field);
                break;
            }
            case 30: {
                this.indexing(field);
                break;
            }
            case 110: {
                this.matchSettings(field.matchSettings());
                break;
            }
            case 96: {
                this.normalizing(field);
                break;
            }
            case 108: {
                this.queryCommand(field);
                break;
            }
            case 111: {
                this.rank(field);
                break;
            }
            case 33: {
                this.rankType(field);
                break;
            }
            case 80: {
                this.fieldSorting(field);
                break;
            }
            case 27: {
                this.structField(field);
                break;
            }
            case 31: {
                this.summaryTo(field);
                break;
            }
            case 34: {
                this.weight(field);
                break;
            }
            case 143: {
                this.weightedset(field.getType());
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void structFieldBody(ParsedField field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 68: {
                this.summaryInField(field);
                break;
            }
            case 30: {
                this.indexing(field);
                break;
            }
            case 79: {
                this.attribute(field);
                break;
            }
            case 110: {
                this.matchSettings(field.matchSettings());
                break;
            }
            case 108: {
                this.queryCommand(field);
                break;
            }
            case 111: {
                this.rank(field);
                break;
            }
            case 27: {
                this.structField(field);
                break;
            }
            case 31: {
                this.summaryTo(field);
                break;
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void indexing(ParsedField field) throws ParseException {
        this.jj_consume_token(30);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 139: {
                this.jj_consume_token(139);
                this.indexingOperation(field, false);
                break;
            }
            default: {
                this.jj_la1[56] = this.jj_gen;
                this.indexingOperation(field, true);
            }
        }
    }

    public final void indexingOperation(ParsedField field, boolean multiLine) throws ParseException {
        IndexingOperation oldOp = this.newIndexingOperation(multiLine);
        ParsedIndexingOp newOp = new ParsedIndexingOp(oldOp.getScript());
        field.setIndexingOperation(newOp);
    }

    public final void summaryTo(ParsedField field) throws ParseException {
        String name = field.name();
        this.jj_consume_token(31);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 124: 
            case 126: 
            case 130: 
            case 131: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 152: 
            case 158: 
            case 159: 
            case 160: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 211: 
            case 213: 
            case 214: 
            case 215: 
            case 221: {
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
            }
        }
        this.jj_consume_token(139);
        String destination = this.identifier();
        ParsedSummaryField psf = field.summaryFieldFor(name);
        psf.addDestination(destination);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 141: {
                    break;
                }
                default: {
                    this.jj_la1[58] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(141);
            destination = this.identifier();
            psf.addDestination(destination);
        }
    }

    public final void weight(ParsedField field) throws ParseException {
        this.jj_consume_token(34);
        this.jj_consume_token(139);
        int num = this.integer();
        field.setWeight(num);
    }

    public final void weightedset(ParsedType fieldType) throws ParseException {
        this.jj_consume_token(143);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 139: {
                this.jj_consume_token(139);
                this.weightedsetBody(fieldType);
                break;
            }
            case 5: 
            case 137: {
                this.lbrace();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 147: 
                        case 148: {
                            break;
                        }
                        default: {
                            this.jj_la1[59] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.weightedsetBody(fieldType);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[60] = this.jj_gen;
                                continue block10;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(138);
                break;
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void weightedsetBody(ParsedType type) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 147: {
                this.jj_consume_token(147);
                type.setCreateIfNonExistent(true);
                break;
            }
            case 148: {
                this.jj_consume_token(148);
                type.setRemoveIfZero(true);
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void rankType(ParsedField field) throws ParseException {
        String indexName = "";
        this.jj_consume_token(33);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 124: 
            case 126: 
            case 130: 
            case 131: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 152: 
            case 158: 
            case 159: 
            case 160: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 211: 
            case 213: 
            case 214: 
            case 215: 
            case 221: {
                indexName = this.identifier();
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
            }
        }
        this.jj_consume_token(139);
        String typeName = this.identifier();
        field.addRankType(indexName, typeName);
    }

    public final void attribute(ParsedField field) throws ParseException {
        String name = field.name();
        this.jj_consume_token(79);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 124: 
            case 126: 
            case 130: 
            case 131: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 152: 
            case 158: 
            case 159: 
            case 160: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 211: 
            case 213: 
            case 214: 
            case 215: 
            case 221: {
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[64] = this.jj_gen;
            }
        }
        if (!name.equals(field.name())) {
            this.deployLogger.logApplicationPackage(Level.WARNING, "Creating an attribute for field '" + field.name() + "' with a different name '" + name + "' than the field name is deprecated, and support will be removed in Vespa 9. Define a field with the wanted name outside the document instead.");
        }
        ParsedAttribute attr = field.attributeFor(name);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 139: {
                this.jj_consume_token(139);
                this.attributeSetting(attr);
                break;
            }
            case 5: 
            case 137: {
                this.lbrace();
                block13: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 80: 
                        case 109: 
                        case 127: 
                        case 128: 
                        case 129: 
                        case 130: 
                        case 131: 
                        case 132: 
                        case 133: 
                        case 171: {
                            break;
                        }
                        default: {
                            this.jj_la1[65] = this.jj_gen;
                            break block13;
                        }
                    }
                    this.attributeSetting(attr);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[66] = this.jj_gen;
                                continue block13;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(138);
                break;
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void fieldSorting(ParsedField field) throws ParseException {
        this.sorting(field.sortInfo());
    }

    public final void attributeSorting(ParsedAttribute attribute) throws ParseException {
        this.sorting(attribute.sortInfo());
    }

    public final void sorting(ParsedSorting sort) throws ParseException {
        this.jj_consume_token(80);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 139: {
                this.jj_consume_token(139);
                this.sortingSetting(sort);
                break;
            }
            case 5: 
            case 137: {
                this.lbrace();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 82: 
                        case 83: 
                        case 87: 
                        case 88: 
                        case 89: {
                            break;
                        }
                        default: {
                            this.jj_la1[68] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.sortingSetting(sort);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[69] = this.jj_gen;
                                continue block10;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(138);
                break;
            }
            default: {
                this.jj_la1[70] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void sortingSetting(ParsedSorting sorting) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 82: {
                this.jj_consume_token(82);
                sorting.setAscending();
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                sorting.setDescending();
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                this.jj_consume_token(139);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 84: {
                        this.jj_consume_token(84);
                        sorting.setFunction(Sorting.Function.UCA);
                        break block0;
                    }
                    case 85: {
                        this.jj_consume_token(85);
                        sorting.setFunction(Sorting.Function.RAW);
                        break block0;
                    }
                    case 86: {
                        this.jj_consume_token(86);
                        sorting.setFunction(Sorting.Function.LOWERCASE);
                        break block0;
                    }
                }
                this.jj_la1[71] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 89: {
                this.jj_consume_token(89);
                this.jj_consume_token(139);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 90: {
                        this.jj_consume_token(90);
                        sorting.setStrength(Sorting.Strength.PRIMARY);
                        break block0;
                    }
                    case 91: {
                        this.jj_consume_token(91);
                        sorting.setStrength(Sorting.Strength.SECONDARY);
                        break block0;
                    }
                    case 92: {
                        this.jj_consume_token(92);
                        sorting.setStrength(Sorting.Strength.TERTIARY);
                        break block0;
                    }
                    case 93: {
                        this.jj_consume_token(93);
                        sorting.setStrength(Sorting.Strength.QUATERNARY);
                        break block0;
                    }
                    case 94: {
                        this.jj_consume_token(94);
                        sorting.setStrength(Sorting.Strength.IDENTICAL);
                        break block0;
                    }
                }
                this.jj_la1[72] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 88: {
                this.jj_consume_token(88);
                this.jj_consume_token(139);
                String locale = this.identifierWithDash();
                sorting.setLocale(locale);
                break;
            }
            default: {
                this.jj_la1[73] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void attributeSetting(ParsedAttribute attribute) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 132: {
                this.jj_consume_token(132);
                attribute.setFastRank(true);
                break;
            }
            case 133: {
                this.jj_consume_token(133);
                attribute.setFastSearch(true);
                break;
            }
            case 129: {
                this.jj_consume_token(129);
                attribute.setFastAccess(true);
                break;
            }
            case 130: {
                this.jj_consume_token(130);
                attribute.setMutable(true);
                break;
            }
            case 131: {
                this.jj_consume_token(131);
                attribute.setPaged(true);
                break;
            }
            case 127: {
                this.jj_consume_token(127);
                this.deployLogger.logApplicationPackage(Level.WARNING, "'enable-bit-vectors' is deprecated and void -> remove it. Will be removed in vespa-9");
                break;
            }
            case 128: {
                this.jj_consume_token(128);
                attribute.setEnableOnlyBitVector(true);
                break;
            }
            case 80: {
                this.attributeSorting(attribute);
                break;
            }
            case 109: {
                this.jj_consume_token(109);
                String aliasedName = attribute.name();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 53: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 124: 
                    case 126: 
                    case 130: 
                    case 131: 
                    case 142: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 152: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 165: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: 
                    case 204: 
                    case 205: 
                    case 206: 
                    case 207: 
                    case 211: 
                    case 213: 
                    case 214: 
                    case 215: 
                    case 221: {
                        aliasedName = this.identifier();
                        break;
                    }
                    default: {
                        this.jj_la1[74] = this.jj_gen;
                    }
                }
                this.jj_consume_token(139);
                String alias = this.identifierWithDash();
                attribute.addAlias(aliasedName, alias);
                break;
            }
            case 171: {
                this.jj_consume_token(171);
                this.jj_consume_token(139);
                String str = this.identifierWithDash();
                attribute.setDistanceMetric(str);
                break;
            }
            default: {
                this.jj_la1[75] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void summaryInDocument(ParsedDocumentSummary docsum) throws ParseException {
        ParsedType type = null;
        this.jj_consume_token(68);
        String name = this.identifierWithDash();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: {
                this.jj_consume_token(35);
                type = this.dataType();
                break;
            }
            default: {
                this.jj_la1[76] = this.jj_gen;
            }
        }
        this.lbrace();
        ParsedSummaryField psf = new ParsedSummaryField(name, type);
        if (type != null) {
            psf.setHasExplicitType();
        }
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 101: 
                case 119: 
                case 120: {
                    break;
                }
                default: {
                    this.jj_la1[77] = this.jj_gen;
                    break block9;
                }
            }
            this.summaryItem(psf);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[78] = this.jj_gen;
                        continue block9;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(138);
        ParsedSummaryField old = docsum.addField(psf);
        if (old != null) {
            this.deployLogger.logApplicationPackage(Level.WARNING, "Summary field '" + psf.name() + "' is defined twice in document-summary '" + docsum.name() + "'");
        }
    }

    public final void summaryInField(ParsedField field) throws ParseException {
        this.jj_consume_token(68);
        if (this.jj_2_7(2)) {
            this.summaryInFieldShort(field);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 30: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 51: 
                case 53: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 124: 
                case 126: 
                case 130: 
                case 131: 
                case 137: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 152: 
                case 158: 
                case 159: 
                case 160: 
                case 165: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 211: 
                case 213: 
                case 214: 
                case 215: 
                case 221: {
                    this.summaryInFieldLong(field);
                    break;
                }
                default: {
                    this.jj_la1[79] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void summaryInFieldShort(ParsedField field) throws ParseException {
        String name = field.name();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 124: 
            case 126: 
            case 130: 
            case 131: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 152: 
            case 158: 
            case 159: 
            case 160: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 211: 
            case 213: 
            case 214: 
            case 215: 
            case 221: {
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[80] = this.jj_gen;
            }
        }
        ParsedSummaryField psf = field.summaryFieldFor(name);
        this.jj_consume_token(139);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 71: {
                this.jj_consume_token(71);
                psf.setDynamic();
                break;
            }
            case 73: {
                this.jj_consume_token(73);
                psf.setMatchedElementsOnly();
                break;
            }
            case 69: 
            case 70: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 69: {
                        this.jj_consume_token(69);
                        break;
                    }
                    case 70: {
                        this.jj_consume_token(70);
                        break;
                    }
                    default: {
                        this.jj_la1[81] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                psf.setFull();
                break;
            }
            case 72: {
                this.jj_consume_token(72);
                psf.setTokens();
                break;
            }
            default: {
                this.jj_la1[82] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void summaryInFieldLong(ParsedField field) throws ParseException {
        String name = field.name();
        ParsedType type = field.getType();
        boolean explicitType = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 124: 
            case 126: 
            case 130: 
            case 131: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 152: 
            case 158: 
            case 159: 
            case 160: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 211: 
            case 213: 
            case 214: 
            case 215: 
            case 221: {
                name = this.identifier();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 35: {
                        this.jj_consume_token(35);
                        type = this.dataType();
                        explicitType = true;
                        break block0;
                    }
                }
                this.jj_la1[83] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[84] = this.jj_gen;
            }
        }
        this.lbrace();
        ParsedSummaryField psf = field.summaryFieldFor(name, type);
        if (explicitType) {
            psf.setHasExplicitType();
        }
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 101: 
                case 119: 
                case 120: {
                    break;
                }
                default: {
                    this.jj_la1[85] = this.jj_gen;
                    break block12;
                }
            }
            this.summaryItem(psf);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[86] = this.jj_gen;
                        continue block12;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(138);
    }

    public final void summaryItem(ParsedSummaryField field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                this.summaryTransform(field);
                break;
            }
            case 101: {
                this.summaryBolding(field);
                break;
            }
            case 119: {
                this.summarySourceList(field);
                break;
            }
            case 120: {
                this.summaryDestinationList(field);
                break;
            }
            default: {
                this.jj_la1[87] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void summaryTransform(ParsedSummaryField field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 71: {
                this.jj_consume_token(71);
                field.setDynamic();
                break;
            }
            case 73: {
                this.jj_consume_token(73);
                field.setMatchedElementsOnly();
                break;
            }
            case 69: 
            case 70: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 69: {
                        this.jj_consume_token(69);
                        break;
                    }
                    case 70: {
                        this.jj_consume_token(70);
                        break;
                    }
                    default: {
                        this.jj_la1[88] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                field.setFull();
                break;
            }
            case 72: {
                this.jj_consume_token(72);
                field.setTokens();
                break;
            }
            default: {
                this.jj_la1[89] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void summaryBolding(ParsedSummaryField field) throws ParseException {
        this.jj_consume_token(101);
        this.jj_consume_token(139);
        boolean bold = this.bool();
        field.setBold(bold);
    }

    public final void summarySourceList(ParsedSummaryField field) throws ParseException {
        block6: while (true) {
            this.jj_consume_token(119);
            this.jj_consume_token(139);
            String str = this.identifier();
            field.addSource(str);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 141: {
                        break;
                    }
                    default: {
                        this.jj_la1[90] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(141);
                str = this.identifier();
                field.addSource(str);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 119: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[91] = this.jj_gen;
    }

    public final void summaryDestinationList(ParsedSummaryField field) throws ParseException {
        this.jj_consume_token(120);
        this.jj_consume_token(139);
        String str = this.identifier();
        field.addDestination(str);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 141: {
                    break;
                }
                default: {
                    this.jj_la1[92] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(141);
            str = this.identifier();
            field.addDestination(str);
        }
    }

    public final void fieldStemming(ParsedField field) throws ParseException {
        this.jj_consume_token(95);
        this.jj_consume_token(139);
        String setting = this.identifierWithDash();
        field.setStemming(Stemming.get(setting));
    }

    public final void searchStemming(ParsedSchema schema) throws ParseException {
        this.jj_consume_token(95);
        this.jj_consume_token(139);
        String setting = this.identifierWithDash();
        schema.setStemming(Stemming.get(setting));
    }

    public final void normalizing(ParsedField field) throws ParseException {
        this.jj_consume_token(96);
        this.jj_consume_token(139);
        String setting = this.identifierWithDash();
        field.setNormalizing(setting);
    }

    public final void bolding(ParsedField field) throws ParseException {
        this.jj_consume_token(101);
        this.jj_consume_token(139);
        boolean bold = this.bool();
        field.setBolding(bold);
    }

    public final void dictionary(ParsedField field) throws ParseException {
        this.jj_consume_token(81);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 139: {
                this.jj_consume_token(139);
                this.dictionarySetting(field);
                break;
            }
            case 5: 
            case 137: {
                this.lbrace();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: {
                            break;
                        }
                        default: {
                            this.jj_la1[93] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.dictionarySetting(field);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[94] = this.jj_gen;
                                continue block10;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(138);
                break;
            }
            default: {
                this.jj_la1[95] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void dictionarySetting(ParsedField field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 97: {
                this.jj_consume_token(97);
                field.dictionary(DictionaryOption.HASH);
                break;
            }
            case 98: {
                this.jj_consume_token(98);
                field.dictionary(DictionaryOption.BTREE);
                break;
            }
            case 99: {
                this.jj_consume_token(99);
                field.dictionary(DictionaryOption.CASED);
                break;
            }
            case 100: {
                this.jj_consume_token(100);
                field.dictionary(DictionaryOption.UNCASED);
                break;
            }
            default: {
                this.jj_la1[96] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void queryCommand(ParsedField field) throws ParseException {
        this.jj_consume_token(108);
        this.jj_consume_token(139);
        field.addQueryCommand(switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 142, 143, 144, 145, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 211, 213, 214, 215, 221 -> this.identifierWithDash();
            case 209, 210 -> this.quotedString();
            default -> {
                this.jj_la1[97] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        });
    }

    public final void alias(ParsedField field) throws ParseException {
        String aliasedName = field.name();
        this.jj_consume_token(109);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 124: 
            case 126: 
            case 130: 
            case 131: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 152: 
            case 158: 
            case 159: 
            case 160: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 211: 
            case 213: 
            case 214: 
            case 215: 
            case 221: {
                aliasedName = this.identifier();
                break;
            }
            default: {
                this.jj_la1[98] = this.jj_gen;
            }
        }
        this.jj_consume_token(139);
        String alias = this.identifierWithDash();
        field.addAlias(aliasedName, alias);
    }

    public final void matchSettings(ParsedMatchSettings matchInfo) throws ParseException {
        this.jj_consume_token(110);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 139: {
                this.jj_consume_token(139);
                this.matchType(matchInfo);
                break;
            }
            case 5: 
            case 137: {
                this.lbrace();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 99: 
                        case 100: 
                        case 113: 
                        case 116: {
                            break;
                        }
                        default: {
                            this.jj_la1[99] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.matchItem(matchInfo);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[100] = this.jj_gen;
                                continue block10;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(138);
                break;
            }
            default: {
                this.jj_la1[101] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void matchType(ParsedMatchSettings matchInfo) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 38: {
                this.jj_consume_token(38);
                matchInfo.setType(MatchType.TEXT);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                matchInfo.setType(MatchType.TEXT);
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                matchInfo.setType(MatchType.WORD);
                break;
            }
            case 113: {
                this.jj_consume_token(113);
                matchInfo.setType(MatchType.EXACT);
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                matchInfo.setType(MatchType.GRAM);
                break;
            }
            case 99: {
                this.jj_consume_token(99);
                matchInfo.setCase(Case.CASED);
                break;
            }
            case 100: {
                this.jj_consume_token(100);
                matchInfo.setCase(Case.UNCASED);
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                matchInfo.setAlgorithm(MatchAlgorithm.PREFIX);
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                matchInfo.setAlgorithm(MatchAlgorithm.SUBSTRING);
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                matchInfo.setAlgorithm(MatchAlgorithm.SUFFIX);
                break;
            }
            default: {
                this.jj_la1[102] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void matchItem(ParsedMatchSettings matchInfo) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 99: 
            case 100: 
            case 113: {
                this.matchType(matchInfo);
                break;
            }
            case 116: {
                this.exactTerminator(matchInfo);
                break;
            }
            case 42: {
                this.gramSize(matchInfo);
                break;
            }
            case 43: {
                this.matchSize(matchInfo);
                break;
            }
            case 44: {
                this.maxTermOccurrences(matchInfo);
                break;
            }
            case 45: {
                this.maxTokenLength(matchInfo);
                break;
            }
            default: {
                this.jj_la1[103] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void exactTerminator(ParsedMatchSettings matchInfo) throws ParseException {
        this.jj_consume_token(116);
        this.jj_consume_token(139);
        String terminator = this.quotedString();
        matchInfo.setExactTerminator(terminator);
    }

    public final void gramSize(ParsedMatchSettings matchInfo) throws ParseException {
        this.jj_consume_token(42);
        this.jj_consume_token(139);
        int gramSize = this.integer();
        matchInfo.setGramSize(gramSize);
    }

    public final void matchSize(ParsedMatchSettings matchInfo) throws ParseException {
        this.jj_consume_token(43);
        this.jj_consume_token(139);
        int matchSize = this.integer();
        matchInfo.setMaxLength(matchSize);
    }

    public final void maxTermOccurrences(ParsedMatchSettings matchInfo) throws ParseException {
        this.jj_consume_token(44);
        this.jj_consume_token(139);
        int maxTermOccurrences = this.integer();
        matchInfo.setMaxTermOccurrences(maxTermOccurrences);
    }

    public final void maxTokenLength(ParsedMatchSettings matchInfo) throws ParseException {
        this.jj_consume_token(45);
        this.jj_consume_token(139);
        int maxTokenLength = this.integer();
        matchInfo.setMaxTokenLength(maxTokenLength);
    }

    public final void rank(ParsedField field) throws ParseException {
        this.jj_consume_token(111);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 139: {
                this.jj_consume_token(139);
                this.rankSetting(field);
                break;
            }
            case 5: 
            case 137: {
                this.lbrace();
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 112: 
                        case 114: 
                        case 115: {
                            break;
                        }
                        default: {
                            this.jj_la1[104] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.rankSetting(field);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[105] = this.jj_gen;
                                continue block10;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(138);
                break;
            }
            default: {
                this.jj_la1[106] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void rankSetting(ParsedField field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 112: {
                this.jj_consume_token(112);
                field.setLiteral(true);
                break;
            }
            case 115: {
                this.jj_consume_token(115);
                field.setNormal(true);
                break;
            }
            case 114: {
                this.jj_consume_token(114);
                field.setFilter(true);
                break;
            }
            default: {
                this.jj_la1[107] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void id(ParsedField field) throws ParseException {
        this.jj_consume_token(118);
        this.jj_consume_token(139);
        int fieldId = this.integer();
        field.setId(fieldId);
    }

    public final void documentSummary(ParsedSchema schema) throws ParseException {
        ParsedDocumentSummary summary;
        block13: {
            this.jj_consume_token(32);
            String name = this.identifierWithDash();
            summary = new ParsedDocumentSummary(name);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 23: {
                    this.inheritsDocumentSummary(summary);
                    break;
                }
                default: {
                    this.jj_la1[108] = this.jj_gen;
                }
            }
            this.lbrace();
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: 
                    case 68: 
                    case 122: 
                    case 123: {
                        break;
                    }
                    default: {
                        this.jj_la1[109] = this.jj_gen;
                        break block13;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 122: {
                        this.jj_consume_token(122);
                        summary.setFromDisk(true);
                        continue block12;
                    }
                    case 123: {
                        this.jj_consume_token(123);
                        summary.setOmitSummaryFeatures(true);
                        continue block12;
                    }
                    case 68: {
                        this.documentSummaryItem(summary);
                        continue block12;
                    }
                    case 5: {
                        this.jj_consume_token(5);
                        continue block12;
                    }
                }
                break;
            }
            this.jj_la1[110] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(138);
        schema.addDocumentSummary(summary);
    }

    public final void inheritsDocumentSummary(ParsedDocumentSummary documentSummary) throws ParseException {
        this.jj_consume_token(23);
        String name = this.identifierWithDash();
        documentSummary.inherit(name);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 141: {
                    break;
                }
                default: {
                    this.jj_la1[111] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(141);
            name = this.identifierWithDash();
            documentSummary.inherit(name);
        }
    }

    public final void documentSummaryItem(ParsedDocumentSummary summary) throws ParseException {
        this.summaryInDocument(summary);
    }

    public final void indexOutsideDoc(ParsedSchema schema) throws ParseException {
        this.jj_consume_token(36);
        String indexName = this.identifier();
        ParsedIndex op = new ParsedIndex(indexName);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 139: {
                this.jj_consume_token(139);
                this.indexBody(op);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 141: {
                            break;
                        }
                        default: {
                            this.jj_la1[112] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(141);
                    this.indexBody(op);
                }
            }
            case 5: 
            case 137: {
                this.lbrace();
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 46: 
                        case 95: 
                        case 109: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 165: {
                            break;
                        }
                        default: {
                            this.jj_la1[113] = this.jj_gen;
                            break block14;
                        }
                    }
                    this.indexBody(op);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[114] = this.jj_gen;
                                continue block14;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(138);
                break;
            }
            default: {
                this.jj_la1[115] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        schema.addIndex(op);
    }

    public final void indexInsideField(ParsedField field) throws ParseException {
        String indexName = field.name();
        this.jj_consume_token(36);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 124: 
            case 126: 
            case 130: 
            case 131: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 152: 
            case 158: 
            case 159: 
            case 160: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 211: 
            case 213: 
            case 214: 
            case 215: 
            case 221: {
                indexName = this.identifier();
                break;
            }
            default: {
                this.jj_la1[116] = this.jj_gen;
            }
        }
        if (!indexName.equals(field.name())) {
            this.deployLogger.logApplicationPackage(Level.WARNING, "Creating an index for field '" + field.name() + "' with a different name '" + indexName + "' than the field name is deprecated, and support will be removed in Vespa 9. Define a field with the wanted name outside the document instead.");
        }
        ParsedIndex op = new ParsedIndex(indexName);
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 139: {
                this.jj_consume_token(139);
                this.indexBody(op);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 141: {
                            break;
                        }
                        default: {
                            this.jj_la1[117] = this.jj_gen;
                            break block3;
                        }
                    }
                    this.jj_consume_token(141);
                    this.indexBody(op);
                }
            }
            case 5: 
            case 137: {
                this.lbrace();
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 46: 
                        case 95: 
                        case 109: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 165: {
                            break;
                        }
                        default: {
                            this.jj_la1[118] = this.jj_gen;
                            break block17;
                        }
                    }
                    this.indexBody(op);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[119] = this.jj_gen;
                                continue block17;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                    break;
                }
                this.jj_consume_token(138);
                break;
            }
            default: {
                this.jj_la1[120] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        field.addIndex(op);
    }

    public final void indexBody(ParsedIndex index) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 46: {
                this.jj_consume_token(46);
                index.setPrefix(true);
                break;
            }
            case 109: {
                this.jj_consume_token(109);
                this.jj_consume_token(139);
                String str = this.identifierWithDash();
                index.addAlias(str);
                break;
            }
            case 95: {
                this.jj_consume_token(95);
                this.jj_consume_token(139);
                String str = this.identifierWithDash();
                index.setStemming(Stemming.get(str));
                break;
            }
            case 160: {
                this.jj_consume_token(160);
                this.jj_consume_token(139);
                int arity = this.integer();
                index.setArity(arity);
                break;
            }
            case 161: {
                this.jj_consume_token(161);
                this.jj_consume_token(139);
                long num = this.longValue();
                index.setLowerBound(num);
                break;
            }
            case 162: {
                this.jj_consume_token(162);
                this.jj_consume_token(139);
                long num = this.longValue();
                index.setUpperBound(num);
                break;
            }
            case 163: {
                this.jj_consume_token(163);
                this.jj_consume_token(139);
                double threshold = this.floatValue();
                index.setDensePostingListThreshold(threshold);
                break;
            }
            case 164: {
                this.jj_consume_token(164);
                index.setEnableBm25(true);
                break;
            }
            case 165: {
                this.hnswIndex(index);
                break;
            }
            default: {
                this.jj_la1[121] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void hnswIndex(ParsedIndex index) throws ParseException {
        HnswIndexParams.Builder params = new HnswIndexParams.Builder();
        if (this.jj_2_8(Integer.MAX_VALUE)) {
            this.jj_consume_token(165);
            this.lbrace();
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 166: 
                    case 172: 
                    case 173: {
                        break;
                    }
                    default: {
                        this.jj_la1[122] = this.jj_gen;
                        break block9;
                    }
                }
                this.hnswIndexBody(params);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[123] = this.jj_gen;
                            continue block9;
                        }
                    }
                    this.jj_consume_token(5);
                }
                break;
            }
            this.jj_consume_token(138);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 165: {
                    this.jj_consume_token(165);
                    break;
                }
                default: {
                    this.jj_la1[124] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        index.setHnswIndexParams(params.build());
    }

    public final void hnswIndexBody(HnswIndexParams.Builder params) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 166: {
                this.jj_consume_token(166);
                this.jj_consume_token(139);
                int num = this.integer();
                params.setMaxLinksPerNode(num);
                break;
            }
            case 172: {
                this.jj_consume_token(172);
                this.jj_consume_token(139);
                int num = this.integer();
                params.setNeighborsToExploreAtInsert(num);
                break;
            }
            case 173: {
                this.jj_consume_token(173);
                this.jj_consume_token(139);
                boolean bool = this.bool();
                params.setMultiThreadedIndexing(bool);
                break;
            }
            default: {
                this.jj_la1[125] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void onnxModelInSchema(ParsedSchema schema) throws ParseException {
        OnnxModel onnxModel = this.onnxModel();
        schema.add(onnxModel);
    }

    public final void onnxModelInProfile(ParsedRankProfile profile) throws ParseException {
        OnnxModel onnxModel = this.onnxModel();
        profile.add(onnxModel);
    }

    public final OnnxModel onnxModel() throws ParseException {
        this.jj_consume_token(50);
        String name = this.identifier();
        OnnxModel onnxModel = new OnnxModel(name);
        this.lbrace();
        block6: while (true) {
            this.onnxModelItem(onnxModel);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[126] = this.jj_gen;
                        break block7;
                    }
                }
                this.jj_consume_token(5);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 205: 
                case 206: 
                case 222: 
                case 223: {
                    continue block6;
                }
            }
            break;
        }
        this.jj_la1[127] = this.jj_gen;
        this.jj_consume_token(138);
        return onnxModel;
    }

    public final void onnxModelItem(OnnxModel onnxModel) throws ParseException {
        String path = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 205: {
                path = this.fileItem();
                onnxModel.setFileName(path);
                break;
            }
            case 206: {
                path = this.uriItem();
                onnxModel.setUri(path);
                break;
            }
            case 59: {
                this.jj_consume_token(59);
                this.jj_consume_token(139);
                int num = this.integer();
                onnxModel.setGpuDevice(num, false);
                break;
            }
            case 57: {
                this.jj_consume_token(57);
                this.jj_consume_token(139);
                int num = this.integer();
                onnxModel.setStatelessIntraOpThreads(num);
                break;
            }
            case 58: {
                this.jj_consume_token(58);
                this.jj_consume_token(139);
                int num = this.integer();
                onnxModel.setStatelessInterOpThreads(num);
                break;
            }
            case 60: {
                this.jj_consume_token(60);
                this.jj_consume_token(139);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 61: {
                        this.jj_consume_token(61);
                        onnxModel.setStatelessExecutionMode("parallel");
                        break block0;
                    }
                    case 62: {
                        this.jj_consume_token(62);
                        onnxModel.setStatelessExecutionMode("sequential");
                        break block0;
                    }
                }
                this.jj_la1[128] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 222: {
                this.jj_consume_token(222);
                String name = this.token.image.substring(5, this.token.image.lastIndexOf(":")).trim();
                if (name.startsWith("\"")) {
                    name = name.substring(1, name.length() - 1);
                }
                String source = this.token.image.substring(this.token.image.lastIndexOf(":") + 1).trim();
                onnxModel.addInputNameMapping(name, source);
                break;
            }
            case 223: {
                this.jj_consume_token(223);
                String name = this.token.image.substring(6, this.token.image.lastIndexOf(":")).trim();
                if (name.startsWith("\"")) {
                    name = name.substring(1, name.length() - 1);
                }
                String as = this.token.image.substring(this.token.image.lastIndexOf(":") + 1).trim();
                onnxModel.addOutputNameMapping(name, as);
                break;
            }
            default: {
                this.jj_la1[129] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void rankingConstant(ParsedSchema schema) throws ParseException {
        String path = null;
        DistributableResource.PathType pathType = DistributableResource.PathType.FILE;
        TensorType type = null;
        this.jj_consume_token(49);
        String name = this.identifier();
        this.lbrace();
        block11: while (true) {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 205: {
                    path = this.fileItem();
                    pathType = DistributableResource.PathType.FILE;
                    break;
                }
                case 206: {
                    path = this.uriItem();
                    pathType = DistributableResource.PathType.URI;
                    break;
                }
                case 35: {
                    type = this.tensorTypeWithPrefix(this.rankingConstantErrorMessage(name));
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 5: {
                                break;
                            }
                            default: {
                                this.jj_la1[130] = this.jj_gen;
                                break block0;
                            }
                        }
                        this.jj_consume_token(5);
                    }
                }
                default: {
                    this.jj_la1[131] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 205: 
                case 206: {
                    continue block11;
                }
            }
            break;
        }
        this.jj_la1[132] = this.jj_gen;
        this.jj_consume_token(138);
        if (type == null) {
            throw new IllegalArgumentException("constant '" + name + "' must have a type");
        }
        if (path == null) {
            throw new IllegalArgumentException("constant '" + name + "' must have a file");
        }
        schema.add(new RankProfile.Constant(FeatureNames.asConstantFeature(name), type, path, pathType));
    }

    public final String fileItem() throws ParseException {
        this.jj_consume_token(205);
        this.jj_consume_token(139);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 216: {
                this.jj_consume_token(216);
                break;
            }
            case 215: {
                this.jj_consume_token(215);
                break;
            }
            case 207: {
                this.jj_consume_token(207);
                break;
            }
            default: {
                this.jj_la1[133] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String path = Path.fromString((String)this.token.image).getRelative();
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[134] = this.jj_gen;
                    break block8;
                }
            }
            this.jj_consume_token(5);
        }
        return path;
    }

    public final String uriItem() throws ParseException {
        this.jj_consume_token(206);
        this.jj_consume_token(139);
        this.jj_consume_token(218);
        String path = this.token.image;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[135] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(5);
        }
        return path;
    }

    public final String rankingConstantErrorMessage(String name) throws ParseException {
        return "For ranking constant ' " + name + "'";
    }

    public final void rankProfile(ParsedSchema schema) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 63: {
                this.jj_consume_token(63);
                break;
            }
            case 66: {
                this.jj_consume_token(66);
                break;
            }
            default: {
                this.jj_la1[136] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String name = this.identifierWithDash();
        ParsedRankProfile profile = new ParsedRankProfile(name);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                this.inheritsRankProfile(profile);
                break;
            }
            default: {
                this.jj_la1[137] = this.jj_gen;
            }
        }
        this.lbrace();
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: 
                case 15: 
                case 33: 
                case 34: 
                case 37: 
                case 50: 
                case 51: 
                case 53: 
                case 56: 
                case 64: 
                case 87: 
                case 111: 
                case 117: 
                case 149: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 193: 
                case 195: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 200: 
                case 201: 
                case 204: {
                    break;
                }
                default: {
                    this.jj_la1[138] = this.jj_gen;
                    break block13;
                }
            }
            this.rankProfileItem(schema, profile);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[139] = this.jj_gen;
                        continue block13;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(138);
        schema.addRankProfile(profile);
    }

    public final void rankProfileItem(ParsedSchema schema, ParsedRankProfile profile) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 33: {
                this.fieldRankType(profile);
                break;
            }
            case 34: {
                this.fieldWeight(profile);
                break;
            }
            case 111: {
                this.fieldRankFilter(profile);
                break;
            }
            case 155: {
                this.firstPhase(profile);
                break;
            }
            case 149: {
                this.matchPhase(profile);
                break;
            }
            case 10: {
                this.diversity(profile);
                break;
            }
            case 87: 
            case 158: {
                this.function(profile);
                break;
            }
            case 64: {
                this.mutate(profile);
                break;
            }
            case 117: {
                this.ignoreRankFeatures(profile);
                break;
            }
            case 195: {
                this.numThreadsPerSearch(profile);
                break;
            }
            case 196: {
                this.minHitsPerThread(profile);
                break;
            }
            case 197: {
                this.numSearchPartitions(profile);
                break;
            }
            case 198: {
                this.termwiseLimit(profile);
                break;
            }
            case 199: {
                this.postFilterThreshold(profile);
                break;
            }
            case 200: {
                this.approximateThreshold(profile);
                break;
            }
            case 201: {
                this.targetHitsMaxAdjustmentFactor(profile);
                break;
            }
            case 180: 
            case 181: {
                this.rankFeatures(profile);
                break;
            }
            case 193: {
                this.rankProperties(profile);
                break;
            }
            case 156: {
                this.secondPhase(profile);
                break;
            }
            case 157: {
                this.globalPhase(profile);
                break;
            }
            case 37: {
                this.inputs(profile);
                break;
            }
            case 204: {
                this.constants(schema, profile);
                break;
            }
            case 174: 
            case 175: 
            case 176: {
                this.matchFeatures(profile);
                break;
            }
            case 177: 
            case 178: 
            case 179: {
                this.summaryFeatures(profile);
                break;
            }
            case 50: {
                this.onnxModelInProfile(profile);
                break;
            }
            case 15: {
                this.strict(profile);
                break;
            }
            case 51: {
                this.significance(profile);
                break;
            }
            case 53: {
                this.weakand(profile);
                break;
            }
            case 56: {
                this.filterThreshold(profile);
                break;
            }
            default: {
                this.jj_la1[140] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void inheritsRankProfile(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(23);
        String name = this.identifierWithDash();
        profile.inherit(name);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 141: {
                    break;
                }
                default: {
                    this.jj_la1[141] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(141);
            name = this.identifierWithDash();
            profile.inherit(name);
        }
    }

    public final void mutate(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(64);
        this.lbrace();
        block3: while (true) {
            this.mutate_operation(profile);
            this.jj_consume_token(5);
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[142] = this.jj_gen;
        this.jj_consume_token(138);
    }

    public final void mutate_operation(ParsedRankProfile profile) throws ParseException {
        RankProfile.MutateOperation.Phase phase = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18 -> {
                this.jj_consume_token(18);
                yield RankProfile.MutateOperation.Phase.on_match;
            }
            case 19 -> {
                this.jj_consume_token(19);
                yield RankProfile.MutateOperation.Phase.on_first_phase;
            }
            case 20 -> {
                this.jj_consume_token(20);
                yield RankProfile.MutateOperation.Phase.on_second_phase;
            }
            case 21 -> {
                this.jj_consume_token(21);
                yield RankProfile.MutateOperation.Phase.on_summary;
            }
            default -> {
                this.jj_la1[143] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        this.lbrace();
        String attribute = this.identifier();
        String operation = this.mutate_expr();
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[144] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(138);
        profile.addMutateOperation(phase, attribute, operation);
    }

    public final String mutate_expr() throws ParseException {
        Number constant = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 226: {
                this.jj_consume_token(226);
                break;
            }
            case 227: {
                this.jj_consume_token(227);
                break;
            }
            case 228: {
                this.jj_consume_token(228);
                break;
            }
            default: {
                this.jj_la1[145] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String op = this.token.image;
        constant = this.number();
        return constant != null ? op + constant : op;
    }

    public final void function(ParsedRankProfile profile) throws ParseException {
        boolean inline = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 87: {
                this.jj_consume_token(87);
                break;
            }
            case 158: {
                this.jj_consume_token(158);
                break;
            }
            default: {
                this.jj_la1[146] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        inline = this.inline();
        Object name = this.identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 229: {
                this.jj_consume_token(229);
                name = (String)name + this.token.image;
                break;
            }
            default: {
                this.jj_la1[147] = this.jj_gen;
            }
        }
        this.jj_consume_token(230);
        ParsedRankFunction func = new ParsedRankFunction((String)name);
        block7 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 124: 
            case 126: 
            case 130: 
            case 131: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 152: 
            case 158: 
            case 159: 
            case 160: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 211: 
            case 213: 
            case 214: 
            case 215: 
            case 221: {
                String parameter = this.identifier();
                func.addParameter(parameter);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 141: {
                            break;
                        }
                        default: {
                            this.jj_la1[148] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(141);
                    parameter = this.identifier();
                    func.addParameter(parameter);
                }
            }
            default: {
                this.jj_la1[149] = this.jj_gen;
            }
        }
        this.jj_consume_token(231);
        this.lbrace();
        String expression = this.expression();
        block17: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[150] = this.jj_gen;
                    break block17;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(138);
        func.setExpression(expression);
        func.setInline(inline);
        ParsedRankFunction old = profile.addOrReplaceFunction(func);
        if (old != null) {
            throw new IllegalArgumentException("Function '" + func.name() + "' is defined twice in rank profile '" + profile.name() + "'");
        }
    }

    public final boolean inline() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 159: {
                this.jj_consume_token(159);
                return true;
            }
        }
        this.jj_la1[151] = this.jj_gen;
        return false;
    }

    public final void matchPhase(ParsedRankProfile profile) throws ParseException {
        RankProfile.MatchPhaseSettings settings = new RankProfile.MatchPhaseSettings();
        this.jj_consume_token(149);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: 
                case 79: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: {
                    break;
                }
                default: {
                    this.jj_la1[152] = this.jj_gen;
                    break block6;
                }
            }
            this.matchPhaseItem(profile, settings);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[153] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(138);
        settings.checkValid();
        profile.setMatchPhase(settings);
    }

    public final void matchPhaseItem(ParsedRankProfile profile, RankProfile.MatchPhaseSettings settings) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 79: {
                this.jj_consume_token(79);
                this.jj_consume_token(139);
                String str = this.identifier();
                settings.setAttribute(str);
                break;
            }
            case 10: {
                this.diversityDeprecated(profile);
                break;
            }
            case 152: {
                this.jj_consume_token(152);
                this.jj_consume_token(139);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 82: {
                        this.jj_consume_token(82);
                        settings.setAscending(true);
                        break block0;
                    }
                    case 83: {
                        this.jj_consume_token(83);
                        settings.setAscending(false);
                        break block0;
                    }
                }
                this.jj_la1[154] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 154: {
                this.jj_consume_token(154);
                this.jj_consume_token(139);
                int num = this.integer();
                settings.setMaxHits(num);
                break;
            }
            case 153: {
                this.jj_consume_token(153);
                this.jj_consume_token(139);
                double coverage = this.floatValue();
                settings.setMaxFilterCoverage(coverage);
                break;
            }
            case 150: {
                this.jj_consume_token(150);
                this.jj_consume_token(139);
                double multiplier = this.floatValue();
                settings.setEvaluationPoint(multiplier);
                break;
            }
            case 151: {
                this.jj_consume_token(151);
                this.jj_consume_token(139);
                double multiplier = this.floatValue();
                settings.setPrePostFilterTippingPoint(multiplier);
                break;
            }
            default: {
                this.jj_la1[155] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void diversity(ParsedRankProfile profile) throws ParseException {
        RankProfile.DiversitySettings settings = new RankProfile.DiversitySettings();
        this.jj_consume_token(10);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: 
                case 12: 
                case 13: 
                case 79: {
                    break;
                }
                default: {
                    this.jj_la1[156] = this.jj_gen;
                    break block6;
                }
            }
            this.diversityItem(settings);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[157] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(138);
        profile.setDiversity(settings);
    }

    public final void diversityDeprecated(ParsedRankProfile profile) throws ParseException {
        RankProfile.DiversitySettings settings = new RankProfile.DiversitySettings();
        this.jj_consume_token(10);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 11: 
                case 12: 
                case 13: 
                case 79: {
                    break;
                }
                default: {
                    this.jj_la1[158] = this.jj_gen;
                    break block6;
                }
            }
            this.diversityItem(settings);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[159] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(138);
        profile.setDiversity(settings);
        this.deployLogger.logApplicationPackage(Level.WARNING, "'diversity is deprecated inside 'match-phase'. Specify it at 'rank-profile' level.");
    }

    public final void diversityItem(RankProfile.DiversitySettings settings) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 79: {
                this.jj_consume_token(79);
                this.jj_consume_token(139);
                String str = this.identifier();
                settings.setAttribute(str);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                this.jj_consume_token(139);
                int num = this.integer();
                settings.setMinGroups(num);
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                this.jj_consume_token(139);
                double multiplier = this.floatValue();
                settings.setCutoffFactor(multiplier);
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                this.jj_consume_token(139);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 15: {
                        this.jj_consume_token(15);
                        settings.setCutoffStrategy(Diversity.CutoffStrategy.strict);
                        break block0;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        settings.setCutoffStrategy(Diversity.CutoffStrategy.loose);
                        break block0;
                    }
                }
                this.jj_la1[160] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[161] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void firstPhase(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(155);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 182: 
                case 183: 
                case 202: 
                case 203: {
                    break;
                }
                default: {
                    this.jj_la1[162] = this.jj_gen;
                    break block6;
                }
            }
            this.firstPhaseItem(profile);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[163] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(138);
    }

    public final void firstPhaseItem(ParsedRankProfile profile) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 182: 
            case 183: {
                String expression = this.expression();
                profile.setFirstPhaseRanking(expression);
                break;
            }
            case 202: {
                this.jj_consume_token(202);
                this.jj_consume_token(139);
                int keepRankCount = this.integer();
                profile.setKeepRankCount(keepRankCount);
                break;
            }
            case 203: {
                this.jj_consume_token(203);
                this.jj_consume_token(139);
                double dropLimit = this.floatValue();
                profile.setRankScoreDropLimit(dropLimit);
                break;
            }
            default: {
                this.jj_la1[164] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void secondPhase(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(156);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 182: 
                case 183: 
                case 194: 
                case 203: {
                    break;
                }
                default: {
                    this.jj_la1[165] = this.jj_gen;
                    break block6;
                }
            }
            this.secondPhaseItem(profile);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[166] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(138);
    }

    public final void secondPhaseItem(ParsedRankProfile profile) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 182: 
            case 183: {
                String expression = this.expression();
                profile.setSecondPhaseRanking(expression);
                break;
            }
            case 194: {
                this.jj_consume_token(194);
                this.jj_consume_token(139);
                int rerankCount = this.integer();
                profile.setRerankCount(rerankCount);
                break;
            }
            case 203: {
                this.jj_consume_token(203);
                this.jj_consume_token(139);
                double dropLimit = this.floatValue();
                profile.setSecondPhaseRankScoreDropLimit(dropLimit);
                break;
            }
            default: {
                this.jj_la1[167] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void globalPhase(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(157);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 182: 
                case 183: 
                case 194: {
                    break;
                }
                default: {
                    this.jj_la1[168] = this.jj_gen;
                    break block6;
                }
            }
            this.globalPhaseItem(profile);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[169] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(138);
    }

    public final void globalPhaseItem(ParsedRankProfile profile) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 182: 
            case 183: {
                String expression = this.expression();
                profile.setGlobalPhaseExpression(expression);
                break;
            }
            case 194: {
                this.jj_consume_token(194);
                this.jj_consume_token(139);
                int rerankCount = this.integer();
                profile.setGlobalPhaseRerankCount(rerankCount);
                break;
            }
            default: {
                this.jj_la1[170] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void inputs(ParsedRankProfile profile) throws ParseException {
        ArrayList<Reference> seenInputs = new ArrayList<Reference>();
        this.jj_consume_token(37);
        this.jj_consume_token(137);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[171] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(5);
        }
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 30: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 51: 
                case 53: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 124: 
                case 126: 
                case 130: 
                case 131: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 152: 
                case 158: 
                case 159: 
                case 160: 
                case 165: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 211: 
                case 213: 
                case 214: 
                case 215: 
                case 221: {
                    break;
                }
                default: {
                    this.jj_la1[172] = this.jj_gen;
                    break block10;
                }
            }
            Reference reference = this.input(profile);
            seenInputs.add(reference);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[173] = this.jj_gen;
                        continue block10;
                    }
                }
                this.jj_consume_token(5);
                seenInputs.add(null);
            }
            break;
        }
        this.jj_consume_token(138);
        Reference last = null;
        for (Reference current : seenInputs) {
            if (last != null && current != null) {
                this.deployLogger.logApplicationPackage(Level.WARNING, "Expected newline between inputs " + last + " and " + current);
            }
            last = current;
        }
    }

    public final Reference input(ParsedRankProfile profile) throws ParseException {
        RankProfile.InputType type = new RankProfile.InputType(TensorType.empty, false);
        Tensor defaultValue = null;
        Reference reference = this.inputName();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 134: 
            case 167: 
            case 168: 
            case 169: 
            case 170: {
                type = this.valueType(reference);
                break;
            }
            default: {
                this.jj_la1[174] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 139: {
                this.jj_consume_token(139);
                block9: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[175] = this.jj_gen;
                            break block9;
                        }
                    }
                    this.jj_consume_token(5);
                }
                defaultValue = this.tensorValue(type.tensorType());
                break;
            }
            default: {
                this.jj_la1[176] = this.jj_gen;
            }
        }
        profile.addInput(reference, new RankProfile.Input(reference, type, Optional.ofNullable(defaultValue)));
        return reference;
    }

    public final Reference inputName() throws ParseException {
        String name;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 65: {
                this.jj_consume_token(65);
                this.jj_consume_token(230);
                name = this.identifier();
                this.jj_consume_token(231);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 124: 
            case 126: 
            case 130: 
            case 131: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 152: 
            case 158: 
            case 159: 
            case 160: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 211: 
            case 213: 
            case 214: 
            case 215: 
            case 221: {
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[177] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return FeatureNames.asQueryFeature(name);
    }

    public final RankProfile.InputType valueType(Reference reference) throws ParseException {
        RankProfile.InputType result;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 134: {
                TensorType type = this.tensorType("Type of " + reference);
                result = new RankProfile.InputType(type, false);
                break;
            }
            case 167: {
                this.jj_consume_token(167);
                result = new RankProfile.InputType(TensorType.empty, false);
                break;
            }
            case 169: {
                this.jj_consume_token(169);
                result = new RankProfile.InputType(TensorType.empty, false);
                this.deployLogger.logApplicationPackage(Level.WARNING, "Input " + reference + ": 'long' is not possible, treated as 'double'");
                break;
            }
            case 168: {
                this.jj_consume_token(168);
                result = new RankProfile.InputType(TensorType.empty, false);
                this.deployLogger.logApplicationPackage(Level.WARNING, "Input " + reference + ": 'float' is not possible, treated as 'double'");
                break;
            }
            case 170: {
                this.jj_consume_token(170);
                result = new RankProfile.InputType(TensorType.empty, true);
                break;
            }
            default: {
                this.jj_la1[178] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return result;
    }

    public final void summaryFeatures(ParsedRankProfile profile) throws ParseException {
        Object inherited = null;
        profile.addSummaryFeatures(this.getFeatureList(switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 177 -> {
                this.jj_consume_token(177);
                yield this.token.image.substring(this.token.image.indexOf(":") + 1).trim();
            }
            case 178 -> {
                this.jj_consume_token(178);
                yield this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}")).trim();
            }
            case 179 -> {
                this.jj_consume_token(179);
                int inheritsIndex = this.token.image.indexOf("inherits ");
                String rest = this.token.image.substring(inheritsIndex + "inherits ".length());
                profile.setInheritedSummaryFeatures(rest.substring(0, rest.indexOf(" ")).trim());
                yield this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}")).trim();
            }
            default -> {
                this.jj_la1[179] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }));
    }

    public final void strict(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(15);
        this.jj_consume_token(139);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 105: {
                this.jj_consume_token(105);
                profile.setStrict(true);
                break;
            }
            case 106: {
                this.jj_consume_token(106);
                profile.setStrict(false);
                break;
            }
            default: {
                this.jj_la1[180] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void significance(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(51);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 52: {
                    break;
                }
                default: {
                    this.jj_la1[181] = this.jj_gen;
                    break block6;
                }
            }
            this.significanceItem(profile);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[182] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(138);
    }

    public final void significanceItem(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(52);
        this.jj_consume_token(139);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 105: {
                this.jj_consume_token(105);
                profile.setUseSignificanceModel(true);
                break;
            }
            case 106: {
                this.jj_consume_token(106);
                profile.setUseSignificanceModel(false);
                break;
            }
            default: {
                this.jj_la1[183] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void weakand(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(53);
        this.lbrace();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 54: 
                case 55: {
                    break;
                }
                default: {
                    this.jj_la1[184] = this.jj_gen;
                    break block6;
                }
            }
            this.weakandItem(profile);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[185] = this.jj_gen;
                        continue block6;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(138);
    }

    public final void weakandItem(ParsedRankProfile profile) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 54: {
                this.weakandStopwordLimit(profile);
                break;
            }
            case 55: {
                this.weakandAdjustTarget(profile);
                break;
            }
            default: {
                this.jj_la1[186] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void weakandStopwordLimit(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(54);
        this.jj_consume_token(139);
        double limit = this.floatValue();
        profile.setWeakandStopwordLimit(limit);
    }

    public final void weakandAdjustTarget(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(55);
        this.jj_consume_token(139);
        double target = this.floatValue();
        profile.setWeakandAdjustTarget(target);
    }

    public final void filterThreshold(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(56);
        this.jj_consume_token(139);
        double threshold = this.floatValue();
        profile.setFilterThreshold(threshold);
    }

    public final void matchFeatures(ParsedRankProfile profile) throws ParseException {
        profile.addMatchFeatures(this.getFeatureList(switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 174 -> {
                this.jj_consume_token(174);
                yield this.token.image.substring(this.token.image.indexOf(":") + 1).trim();
            }
            case 175 -> {
                this.jj_consume_token(175);
                yield this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}")).trim();
            }
            case 176 -> {
                this.jj_consume_token(176);
                int inheritsIndex = this.token.image.indexOf("inherits ");
                String rest = this.token.image.substring(inheritsIndex + "inherits ".length());
                profile.setInheritedMatchFeatures(rest.substring(0, rest.indexOf(" ")).trim());
                yield this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}")).trim();
            }
            default -> {
                this.jj_la1[187] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }));
    }

    public final void rankFeatures(ParsedRankProfile profile) throws ParseException {
        profile.addRankFeatures(this.getFeatureList(switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 180 -> {
                this.jj_consume_token(180);
                yield this.token.image.substring(this.token.image.indexOf(":") + 1).trim();
            }
            case 181 -> {
                this.jj_consume_token(181);
                yield this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}")).trim();
            }
            default -> {
                this.jj_la1[188] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }));
    }

    public final void ignoreRankFeatures(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(117);
        profile.setIgnoreDefaultRankFeatures(true);
    }

    public final void numThreadsPerSearch(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(195);
        this.jj_consume_token(139);
        int num = this.integer();
        profile.setNumThreadsPerSearch(num);
    }

    public final void minHitsPerThread(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(196);
        this.jj_consume_token(139);
        int num = this.integer();
        profile.setMinHitsPerThread(num);
    }

    public final void numSearchPartitions(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(197);
        this.jj_consume_token(139);
        int num = this.integer();
        profile.setNumSearchPartitions(num);
    }

    public final void termwiseLimit(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(198);
        this.jj_consume_token(139);
        double num = this.floatValue();
        profile.setTermwiseLimit(num);
    }

    public final void postFilterThreshold(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(199);
        this.jj_consume_token(139);
        double threshold = this.floatValue();
        profile.setPostFilterThreshold(threshold);
    }

    public final void approximateThreshold(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(200);
        this.jj_consume_token(139);
        double threshold = this.floatValue();
        profile.setApproximateThreshold(threshold);
    }

    public final void targetHitsMaxAdjustmentFactor(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(201);
        this.jj_consume_token(139);
        double factor = this.floatValue();
        profile.setTargetHitsMaxAdjustmentFactor(factor);
    }

    public final void rankProperties(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(193);
        this.lbrace();
        while (this.jj_2_9(Integer.MAX_VALUE)) {
            this.rankProperty(profile);
            block7: while (true) {
                this.jj_consume_token(5);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[189] = this.jj_gen;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 221: 
            case 230: 
            case 231: {
                this.rankProperty(profile);
                break;
            }
            default: {
                this.jj_la1[190] = this.jj_gen;
            }
        }
        this.jj_consume_token(138);
    }

    public final void rankProperty(ParsedRankProfile profile) throws ParseException {
        String key = this.rankPropertyItem();
        this.jj_consume_token(139);
        String val = this.rankPropertyItem();
        profile.addRankProperty(key, val);
    }

    public final String rankPropertyItem() throws ParseException {
        String image = null;
        Object ret = "";
        Token dToken = null;
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 193: 
                case 194: 
                case 195: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 208: 
                case 211: 
                case 213: 
                case 214: 
                case 215: 
                case 221: {
                    image = this.identifierWithDash();
                    ret = (String)ret + image;
                    break;
                }
                case 212: {
                    dToken = this.jj_consume_token(212);
                    ret = (String)ret + dToken.image;
                    break;
                }
                case 209: 
                case 210: {
                    image = this.quotedString();
                    ret = (String)ret + image;
                    break;
                }
                case 140: 
                case 141: 
                case 230: 
                case 231: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 230: {
                            this.jj_consume_token(230);
                            break;
                        }
                        case 231: {
                            this.jj_consume_token(231);
                            break;
                        }
                        case 140: {
                            this.jj_consume_token(140);
                            break;
                        }
                        case 141: {
                            this.jj_consume_token(141);
                            break;
                        }
                        default: {
                            this.jj_la1[191] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    ret = (String)ret + this.token.image;
                    break;
                }
                default: {
                    this.jj_la1[192] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 140: 
                case 141: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 147: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 193: 
                case 194: 
                case 195: 
                case 196: 
                case 197: 
                case 198: 
                case 199: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: 
                case 221: 
                case 230: 
                case 231: {
                    continue block15;
                }
            }
            break;
        }
        this.jj_la1[193] = this.jj_gen;
        return ret;
    }

    public final void fieldWeight(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(34);
        String name = this.identifier();
        this.jj_consume_token(139);
        Integer num = this.integer();
        profile.addFieldRankWeight(name, num);
    }

    public final void fieldRankType(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(33);
        String name = this.identifier();
        this.jj_consume_token(139);
        String type = this.identifier();
        profile.addFieldRankType(name, type);
    }

    public final void fieldRankFilter(ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(111);
        String name = this.identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 139: {
                this.jj_consume_token(139);
                this.jj_consume_token(114);
                profile.addFieldRankFilter(name, true);
                break;
            }
            case 5: 
            case 137: {
                this.lbrace();
                this.jj_consume_token(56);
                this.jj_consume_token(139);
                double filterThreshold = this.floatValue();
                profile.addFieldRankFilterThreshold(name, filterThreshold);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[194] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(5);
                }
                this.jj_consume_token(138);
                break;
            }
            default: {
                this.jj_la1[195] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void constants(ParsedSchema schema, ParsedRankProfile profile) throws ParseException {
        this.jj_consume_token(204);
        this.jj_consume_token(137);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[196] = this.jj_gen;
                    break block9;
                }
            }
            this.jj_consume_token(5);
        }
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 30: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 51: 
                case 53: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 124: 
                case 126: 
                case 130: 
                case 131: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 152: 
                case 158: 
                case 159: 
                case 160: 
                case 165: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 211: 
                case 213: 
                case 214: 
                case 215: 
                case 221: {
                    break;
                }
                default: {
                    this.jj_la1[197] = this.jj_gen;
                    break block10;
                }
            }
            this.constant(schema, profile);
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[198] = this.jj_gen;
                        continue block10;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(138);
    }

    public final void constant(ParsedSchema schema, ParsedRankProfile profile) throws ParseException {
        Reference name = null;
        RankProfile.InputType type = new RankProfile.InputType(TensorType.empty, false);
        Tensor value = null;
        String valuePath = null;
        name = this.constantName();
        if (this.jj_2_10(4)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 134: 
                case 167: 
                case 168: 
                case 169: 
                case 170: {
                    type = this.valueType(name);
                    break;
                }
                default: {
                    this.jj_la1[199] = this.jj_gen;
                }
            }
            this.jj_consume_token(139);
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[200] = this.jj_gen;
                        break block17;
                    }
                }
                this.jj_consume_token(5);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 137: 
                case 212: 
                case 213: 
                case 214: 
                case 232: {
                    value = this.tensorValue(type.tensorType());
                    break;
                }
                case 205: {
                    valuePath = this.fileItem();
                    break;
                }
                default: {
                    this.jj_la1[201] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (value != null) {
                profile.add(new RankProfile.Constant(name, value));
            } else {
                profile.add(new RankProfile.Constant(name, type.tensorType(), valuePath));
            }
        } else {
            block10 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 137: 
                case 139: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 139: {
                            this.constantValue(profile, name);
                            break block10;
                        }
                        case 137: {
                            this.constantTensor(profile, name);
                            break block10;
                        }
                    }
                    this.jj_la1[202] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                default: {
                    this.jj_la1[203] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final Reference constantName() throws ParseException {
        String name;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 49: {
                this.jj_consume_token(49);
                this.jj_consume_token(230);
                name = this.identifier();
                this.jj_consume_token(231);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 51: 
            case 53: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 124: 
            case 126: 
            case 130: 
            case 131: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 152: 
            case 158: 
            case 159: 
            case 160: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 211: 
            case 213: 
            case 214: 
            case 215: 
            case 221: {
                name = this.identifier();
                break;
            }
            default: {
                this.jj_la1[204] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return FeatureNames.asConstantFeature(name);
    }

    public final void constantValue(ParsedRankProfile profile, Reference name) throws ParseException {
        this.jj_consume_token(139);
        Token value = switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 212 -> this.jj_consume_token(212);
            case 213 -> this.jj_consume_token(213);
            case 207 -> this.jj_consume_token(207);
            default -> {
                this.jj_la1[205] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        profile.add(new RankProfile.Constant(name, Tensor.from((String)value.image)));
    }

    public final void constantTensor(ParsedRankProfile profile, Reference name) throws ParseException {
        String tensorString = "";
        TensorType type = null;
        this.jj_consume_token(137);
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[206] = this.jj_gen;
                    break block13;
                }
            }
            this.jj_consume_token(5);
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 135: 
                case 136: {
                    break;
                }
                default: {
                    this.jj_la1[207] = this.jj_gen;
                    break block14;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 135: 
                case 136: {
                    tensorString = this.tensorValuePrefixedByValue();
                    break;
                }
                case 35: {
                    type = this.tensorTypeWithPrefix(this.constantTensorErrorMessage(profile.name(), name));
                    break;
                }
                default: {
                    this.jj_la1[208] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[209] = this.jj_gen;
                        continue block14;
                    }
                }
                this.jj_consume_token(5);
            }
            break;
        }
        this.jj_consume_token(138);
        profile.add(new RankProfile.Constant(name, type != null ? Tensor.from((TensorType)type, (String)tensorString) : Tensor.from((String)tensorString)));
    }

    public final String constantTensorErrorMessage(String rankProfileName, Reference name) throws ParseException {
        return "For constant tensor '" + name + "' in rank profile '" + rankProfileName + "'";
    }

    public final Tensor tensorValue(TensorType type) throws ParseException {
        Tensor.Builder builder = Tensor.Builder.of((TensorType)type);
        Number doubleValue = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 137: {
                this.mappedTensorValue(builder);
                break;
            }
            case 232: {
                this.indexedTensorValues(builder);
                break;
            }
            case 212: 
            case 213: 
            case 214: {
                doubleValue = this.number();
                break;
            }
            default: {
                this.jj_la1[210] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (doubleValue != null) {
            if (type.rank() > 0) {
                throw new IllegalArgumentException("A tensor of type " + type + " cannot be a number");
            }
            builder.cell(doubleValue.doubleValue(), new long[0]);
        }
        return builder.build();
    }

    public final void mappedTensorValue(Tensor.Builder builder) throws ParseException {
        this.jj_consume_token(137);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 29: 
                case 30: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 51: 
                case 53: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 124: 
                case 126: 
                case 130: 
                case 131: 
                case 137: 
                case 142: 
                case 143: 
                case 144: 
                case 145: 
                case 152: 
                case 158: 
                case 159: 
                case 160: 
                case 165: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 204: 
                case 205: 
                case 206: 
                case 207: 
                case 209: 
                case 210: 
                case 211: 
                case 213: 
                case 214: 
                case 215: 
                case 221: {
                    break;
                }
                default: {
                    this.jj_la1[211] = this.jj_gen;
                    break block9;
                }
            }
            this.mappedTensorBlock(builder);
        }
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 141: {
                    break;
                }
                default: {
                    this.jj_la1[212] = this.jj_gen;
                    break block10;
                }
            }
            this.jj_consume_token(141);
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 5: {
                        break;
                    }
                    default: {
                        this.jj_la1[213] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(5);
            }
            this.mappedTensorBlock(builder);
        }
        this.jj_consume_token(138);
    }

    public final void mappedTensorBlock(Tensor.Builder builder) throws ParseException {
        TensorAddress mappedAddress = this.tensorAddress(builder.type());
        this.jj_consume_token(139);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[214] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(5);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 212: 
            case 213: 
            case 214: {
                this.mappedTensorCellValue(mappedAddress, builder);
                break;
            }
            case 232: {
                this.indexedTensorBlockValues(mappedAddress, builder);
                break;
            }
            default: {
                this.jj_la1[215] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void indexedTensorBlockValues(TensorAddress mappedAddress, Tensor.Builder builder) throws ParseException {
        ArrayList<Double> values = new ArrayList<Double>();
        this.arrayTensorValues(values);
        MixedTensor.BoundBuilder boundBuilder = (MixedTensor.BoundBuilder)builder;
        double[] arrayValues = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            arrayValues[i] = (Double)values.get(i);
        }
        boundBuilder.block(mappedAddress, arrayValues);
    }

    public final void indexedTensorValues(Tensor.Builder builder) throws ParseException {
        ArrayList<Double> values = new ArrayList<Double>();
        this.arrayTensorValues(values);
        IndexedTensor.BoundBuilder boundBuilder = (IndexedTensor.BoundBuilder)builder;
        double[] arrayValues = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            arrayValues[i] = (Double)values.get(i);
        }
        boundBuilder.fill(arrayValues);
    }

    public final void arrayTensorValues(List<Double> values) throws ParseException {
        block21: {
            block20: {
                this.jj_consume_token(232);
                block17: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 212: 
                        case 213: 
                        case 214: 
                        case 232: {
                            break;
                        }
                        default: {
                            this.jj_la1[216] = this.jj_gen;
                            break block20;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 212: 
                        case 213: 
                        case 214: {
                            this.indexedTensorValue(values);
                            continue block17;
                        }
                        case 232: {
                            this.arrayTensorValues(values);
                            continue block17;
                        }
                    }
                    break;
                }
                this.jj_la1[217] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 141: {
                        break;
                    }
                    default: {
                        this.jj_la1[218] = this.jj_gen;
                        break block21;
                    }
                }
                this.jj_consume_token(141);
                block19: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 5: {
                            break;
                        }
                        default: {
                            this.jj_la1[219] = this.jj_gen;
                            break block19;
                        }
                    }
                    this.jj_consume_token(5);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 212: 
                    case 213: 
                    case 214: {
                        this.indexedTensorValue(values);
                        continue block18;
                    }
                    case 232: {
                        this.arrayTensorValues(values);
                        continue block18;
                    }
                }
                break;
            }
            this.jj_la1[220] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(233);
    }

    public final void indexedTensorValue(List<Double> values) throws ParseException {
        Number value = this.number();
        values.add(value.doubleValue());
    }

    public final void mappedTensorCellValue(TensorAddress address, Tensor.Builder builder) throws ParseException {
        double value = this.tensorCellValue();
        builder.cell(address, value);
    }

    public final TensorAddress tensorAddress(TensorType type) throws ParseException {
        TensorAddress.PartialBuilder builder = new TensorAddress.PartialBuilder(type);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 124: 
            case 126: 
            case 130: 
            case 131: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 152: 
            case 158: 
            case 159: 
            case 160: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 209: 
            case 210: 
            case 211: 
            case 213: 
            case 214: 
            case 215: 
            case 221: {
                String label = this.tensorAddressLabel();
                builder.add(label);
                break;
            }
            case 137: {
                this.jj_consume_token(137);
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 28: 
                        case 29: 
                        case 30: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 41: 
                        case 46: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 51: 
                        case 53: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 68: 
                        case 69: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: 
                        case 87: 
                        case 88: 
                        case 89: 
                        case 90: 
                        case 91: 
                        case 92: 
                        case 93: 
                        case 94: 
                        case 95: 
                        case 96: 
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: 
                        case 103: 
                        case 104: 
                        case 105: 
                        case 106: 
                        case 107: 
                        case 109: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 118: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 124: 
                        case 126: 
                        case 130: 
                        case 131: 
                        case 142: 
                        case 143: 
                        case 144: 
                        case 145: 
                        case 152: 
                        case 158: 
                        case 159: 
                        case 160: 
                        case 165: 
                        case 167: 
                        case 168: 
                        case 169: 
                        case 170: 
                        case 204: 
                        case 205: 
                        case 206: 
                        case 207: 
                        case 211: 
                        case 213: 
                        case 214: 
                        case 215: 
                        case 221: {
                            break;
                        }
                        default: {
                            this.jj_la1[221] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.tensorAddressElement((TensorAddress.Builder)builder);
                }
                block11: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 141: {
                            break;
                        }
                        default: {
                            this.jj_la1[222] = this.jj_gen;
                            break block11;
                        }
                    }
                    this.jj_consume_token(141);
                    this.tensorAddressElement((TensorAddress.Builder)builder);
                }
                this.jj_consume_token(138);
                break;
            }
            default: {
                this.jj_la1[223] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return builder.build();
    }

    public final void tensorAddressElement(TensorAddress.Builder builder) throws ParseException {
        String dimension = this.identifier();
        this.jj_consume_token(139);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[224] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(5);
        }
        String label = this.tensorAddressLabel();
        builder.add(dimension, label);
    }

    public final String tensorAddressLabel() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6, 7, 8, 9, 10, 14, 15, 16, 17, 22, 23, 24, 25, 26, 28, 29, 30, 34, 35, 36, 37, 38, 39, 40, 41, 46, 47, 48, 49, 51, 53, 61, 62, 63, 64, 65, 68, 69, 70, 71, 72, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 109, 110, 111, 112, 113, 114, 115, 118, 119, 120, 121, 124, 126, 130, 131, 142, 143, 144, 145, 152, 158, 159, 160, 165, 167, 168, 169, 170, 204, 205, 206, 207, 211, 213, 214, 215, 221 -> this.identifier();
            case 209, 210 -> this.quotedString();
            default -> {
                this.jj_la1[225] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final double tensorCellValue() throws ParseException {
        Number value = this.number();
        return value.doubleValue();
    }

    public final String tensorValuePrefixedByValue() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 135 -> {
                this.jj_consume_token(135);
                yield this.token.image.substring(this.token.image.indexOf(":") + 1);
            }
            case 136 -> {
                this.jj_consume_token(136);
                yield this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}"));
            }
            default -> {
                this.jj_la1[226] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final TensorType tensorTypeWithPrefix(String errorMessage) throws ParseException {
        this.jj_consume_token(35);
        this.jj_consume_token(139);
        TensorType type = this.tensorType(errorMessage);
        return type;
    }

    public final TensorType tensorType(String errorMessage) throws ParseException {
        TensorType tensorType;
        this.jj_consume_token(134);
        String tensorTypeString = this.token.image;
        try {
            tensorType = TensorType.fromSpec((String)tensorTypeString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(errorMessage + ": Illegal tensor type spec: " + e.getMessage());
        }
        return tensorType;
    }

    public final void importField(ParsedSchema schema) throws ParseException {
        this.jj_consume_token(28);
        this.jj_consume_token(24);
        String fieldRefSpec = this.identifier();
        this.jj_consume_token(29);
        String aliasFieldName = this.identifier();
        this.lbrace();
        this.jj_consume_token(138);
        long nDots = Utils.count(fieldRefSpec, '.');
        if (nDots != 1L) {
            throw new IllegalArgumentException("Illegal field reference spec '" + fieldRefSpec + "': Does not include a single '.'");
        }
        int indexOfDot = fieldRefSpec.indexOf(46);
        String documentReferenceFieldName = fieldRefSpec.substring(0, indexOfDot);
        String foreignFieldName = fieldRefSpec.substring(indexOfDot + 1);
        schema.addImportedField(aliasFieldName, documentReferenceFieldName, foreignFieldName);
    }

    public final String expression() throws ParseException {
        return (switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 182 -> {
                this.jj_consume_token(182);
                yield this.token.image.substring(this.token.image.indexOf(":") + 1);
            }
            case 183 -> {
                this.jj_consume_token(183);
                yield this.token.image.substring(this.token.image.indexOf("{") + 1, this.token.image.lastIndexOf("}"));
            }
            default -> {
                this.jj_la1[227] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }).trim();
    }

    public final String identifierWithDash() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 124: 
            case 126: 
            case 130: 
            case 131: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 152: 
            case 158: 
            case 159: 
            case 160: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 211: 
            case 213: 
            case 214: 
            case 215: 
            case 221: {
                String identifier = this.identifier();
                return identifier;
            }
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 42: 
            case 43: 
            case 50: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 66: 
            case 67: 
            case 73: 
            case 108: 
            case 116: 
            case 117: 
            case 122: 
            case 123: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 132: 
            case 133: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 166: 
            case 171: 
            case 172: 
            case 173: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 208: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 208: {
                        this.jj_consume_token(208);
                        break;
                    }
                    case 55: {
                        this.jj_consume_token(55);
                        break;
                    }
                    case 200: {
                        this.jj_consume_token(200);
                        break;
                    }
                    case 147: {
                        this.jj_consume_token(147);
                        break;
                    }
                    case 12: {
                        this.jj_consume_token(12);
                        break;
                    }
                    case 13: {
                        this.jj_consume_token(13);
                        break;
                    }
                    case 163: {
                        this.jj_consume_token(163);
                        break;
                    }
                    case 171: {
                        this.jj_consume_token(171);
                        break;
                    }
                    case 32: {
                        this.jj_consume_token(32);
                        break;
                    }
                    case 127: {
                        this.jj_consume_token(127);
                        break;
                    }
                    case 164: {
                        this.jj_consume_token(164);
                        break;
                    }
                    case 128: {
                        this.jj_consume_token(128);
                        break;
                    }
                    case 150: {
                        this.jj_consume_token(150);
                        break;
                    }
                    case 116: {
                        this.jj_consume_token(116);
                        break;
                    }
                    case 60: {
                        this.jj_consume_token(60);
                        break;
                    }
                    case 129: {
                        this.jj_consume_token(129);
                        break;
                    }
                    case 132: {
                        this.jj_consume_token(132);
                        break;
                    }
                    case 133: {
                        this.jj_consume_token(133);
                        break;
                    }
                    case 56: {
                        this.jj_consume_token(56);
                        break;
                    }
                    case 155: {
                        this.jj_consume_token(155);
                        break;
                    }
                    case 122: {
                        this.jj_consume_token(122);
                        break;
                    }
                    case 157: {
                        this.jj_consume_token(157);
                        break;
                    }
                    case 59: {
                        this.jj_consume_token(59);
                        break;
                    }
                    case 42: {
                        this.jj_consume_token(42);
                        break;
                    }
                    case 117: {
                        this.jj_consume_token(117);
                        break;
                    }
                    case 58: {
                        this.jj_consume_token(58);
                        break;
                    }
                    case 57: {
                        this.jj_consume_token(57);
                        break;
                    }
                    case 202: {
                        this.jj_consume_token(202);
                        break;
                    }
                    case 161: {
                        this.jj_consume_token(161);
                        break;
                    }
                    case 73: {
                        this.jj_consume_token(73);
                        break;
                    }
                    case 149: {
                        this.jj_consume_token(149);
                        break;
                    }
                    case 153: {
                        this.jj_consume_token(153);
                        break;
                    }
                    case 154: {
                        this.jj_consume_token(154);
                        break;
                    }
                    case 43: {
                        this.jj_consume_token(43);
                        break;
                    }
                    case 166: {
                        this.jj_consume_token(166);
                        break;
                    }
                    case 11: {
                        this.jj_consume_token(11);
                        break;
                    }
                    case 196: {
                        this.jj_consume_token(196);
                        break;
                    }
                    case 173: {
                        this.jj_consume_token(173);
                        break;
                    }
                    case 172: {
                        this.jj_consume_token(172);
                        break;
                    }
                    case 197: {
                        this.jj_consume_token(197);
                        break;
                    }
                    case 195: {
                        this.jj_consume_token(195);
                        break;
                    }
                    case 123: {
                        this.jj_consume_token(123);
                        break;
                    }
                    case 125: {
                        this.jj_consume_token(125);
                        break;
                    }
                    case 19: {
                        this.jj_consume_token(19);
                        break;
                    }
                    case 18: {
                        this.jj_consume_token(18);
                        break;
                    }
                    case 50: {
                        this.jj_consume_token(50);
                        break;
                    }
                    case 20: {
                        this.jj_consume_token(20);
                        break;
                    }
                    case 21: {
                        this.jj_consume_token(21);
                        break;
                    }
                    case 199: {
                        this.jj_consume_token(199);
                        break;
                    }
                    case 151: {
                        this.jj_consume_token(151);
                        break;
                    }
                    case 108: {
                        this.jj_consume_token(108);
                        break;
                    }
                    case 66: {
                        this.jj_consume_token(66);
                        break;
                    }
                    case 193: {
                        this.jj_consume_token(193);
                        break;
                    }
                    case 203: {
                        this.jj_consume_token(203);
                        break;
                    }
                    case 33: {
                        this.jj_consume_token(33);
                        break;
                    }
                    case 67: {
                        this.jj_consume_token(67);
                        break;
                    }
                    case 148: {
                        this.jj_consume_token(148);
                        break;
                    }
                    case 194: {
                        this.jj_consume_token(194);
                        break;
                    }
                    case 156: {
                        this.jj_consume_token(156);
                        break;
                    }
                    case 54: {
                        this.jj_consume_token(54);
                        break;
                    }
                    case 27: {
                        this.jj_consume_token(27);
                        break;
                    }
                    case 31: {
                        this.jj_consume_token(31);
                        break;
                    }
                    case 201: {
                        this.jj_consume_token(201);
                        break;
                    }
                    case 198: {
                        this.jj_consume_token(198);
                        break;
                    }
                    case 162: {
                        this.jj_consume_token(162);
                        break;
                    }
                    case 52: {
                        this.jj_consume_token(52);
                        break;
                    }
                    default: {
                        this.jj_la1[228] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return this.token.image;
            }
        }
        this.jj_la1[229] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String identifier() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 109: {
                this.jj_consume_token(109);
                break;
            }
            case 124: {
                this.jj_consume_token(124);
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                break;
            }
            case 160: {
                this.jj_consume_token(160);
                break;
            }
            case 142: {
                this.jj_consume_token(142);
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                break;
            }
            case 82: {
                this.jj_consume_token(82);
                break;
            }
            case 79: {
                this.jj_consume_token(79);
                break;
            }
            case 101: {
                this.jj_consume_token(101);
                break;
            }
            case 98: {
                this.jj_consume_token(98);
                break;
            }
            case 99: {
                this.jj_consume_token(99);
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                break;
            }
            case 204: {
                this.jj_consume_token(204);
                break;
            }
            case 211: {
                this.jj_consume_token(211);
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                break;
            }
            case 81: {
                this.jj_consume_token(81);
                break;
            }
            case 121: {
                this.jj_consume_token(121);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            case 167: {
                this.jj_consume_token(167);
                break;
            }
            case 168: {
                this.jj_consume_token(168);
                break;
            }
            case 169: {
                this.jj_consume_token(169);
                break;
            }
            case 170: {
                this.jj_consume_token(170);
                break;
            }
            case 71: {
                this.jj_consume_token(71);
                break;
            }
            case 113: {
                this.jj_consume_token(113);
                break;
            }
            case 106: {
                this.jj_consume_token(106);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                break;
            }
            case 205: {
                this.jj_consume_token(205);
                break;
            }
            case 114: {
                this.jj_consume_token(114);
                break;
            }
            case 69: {
                this.jj_consume_token(69);
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                break;
            }
            case 97: {
                this.jj_consume_token(97);
                break;
            }
            case 165: {
                this.jj_consume_token(165);
                break;
            }
            case 118: {
                this.jj_consume_token(118);
                break;
            }
            case 94: {
                this.jj_consume_token(94);
                break;
            }
            case 207: {
                this.jj_consume_token(207);
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                break;
            }
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                break;
            }
            case 159: {
                this.jj_consume_token(159);
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            case 213: {
                this.jj_consume_token(213);
                break;
            }
            case 112: {
                this.jj_consume_token(112);
                break;
            }
            case 88: {
                this.jj_consume_token(88);
                break;
            }
            case 214: {
                this.jj_consume_token(214);
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                break;
            }
            case 158: {
                this.jj_consume_token(158);
                break;
            }
            case 144: {
                this.jj_consume_token(144);
                break;
            }
            case 110: {
                this.jj_consume_token(110);
                break;
            }
            case 63: {
                this.jj_consume_token(63);
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                break;
            }
            case 130: {
                this.jj_consume_token(130);
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                break;
            }
            case 126: {
                this.jj_consume_token(126);
                break;
            }
            case 102: {
                this.jj_consume_token(102);
                break;
            }
            case 115: {
                this.jj_consume_token(115);
                break;
            }
            case 96: {
                this.jj_consume_token(96);
                break;
            }
            case 104: {
                this.jj_consume_token(104);
                break;
            }
            case 103: {
                this.jj_consume_token(103);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            case 152: {
                this.jj_consume_token(152);
                break;
            }
            case 131: {
                this.jj_consume_token(131);
                break;
            }
            case 61: {
                this.jj_consume_token(61);
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                break;
            }
            case 90: {
                this.jj_consume_token(90);
                break;
            }
            case 78: {
                this.jj_consume_token(78);
                break;
            }
            case 93: {
                this.jj_consume_token(93);
                break;
            }
            case 65: {
                this.jj_consume_token(65);
                break;
            }
            case 111: {
                this.jj_consume_token(111);
                break;
            }
            case 85: {
                this.jj_consume_token(85);
                break;
            }
            case 145: {
                this.jj_consume_token(145);
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            case 91: {
                this.jj_consume_token(91);
                break;
            }
            case 62: {
                this.jj_consume_token(62);
                break;
            }
            case 80: {
                this.jj_consume_token(80);
                break;
            }
            case 119: {
                this.jj_consume_token(119);
                break;
            }
            case 74: {
                this.jj_consume_token(74);
                break;
            }
            case 75: {
                this.jj_consume_token(75);
                break;
            }
            case 76: {
                this.jj_consume_token(76);
                break;
            }
            case 77: {
                this.jj_consume_token(77);
                break;
            }
            case 51: {
                this.jj_consume_token(51);
                break;
            }
            case 70: {
                this.jj_consume_token(70);
                break;
            }
            case 95: {
                this.jj_consume_token(95);
                break;
            }
            case 89: {
                this.jj_consume_token(89);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            case 215: {
                this.jj_consume_token(215);
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                break;
            }
            case 68: {
                this.jj_consume_token(68);
                break;
            }
            case 107: {
                this.jj_consume_token(107);
                break;
            }
            case 92: {
                this.jj_consume_token(92);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                break;
            }
            case 120: {
                this.jj_consume_token(120);
                break;
            }
            case 72: {
                this.jj_consume_token(72);
                break;
            }
            case 105: {
                this.jj_consume_token(105);
                break;
            }
            case 35: {
                this.jj_consume_token(35);
                break;
            }
            case 84: {
                this.jj_consume_token(84);
                break;
            }
            case 100: {
                this.jj_consume_token(100);
                break;
            }
            case 206: {
                this.jj_consume_token(206);
                break;
            }
            case 221: {
                this.jj_consume_token(221);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            case 143: {
                this.jj_consume_token(143);
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                break;
            }
            default: {
                this.jj_la1[230] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image;
    }

    public final String string() throws ParseException {
        this.jj_consume_token(215);
        return this.token.image;
    }

    public final String quotedString() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 209: {
                this.jj_consume_token(209);
                break;
            }
            case 210: {
                this.jj_consume_token(210);
                break;
            }
            default: {
                this.jj_la1[231] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image.substring(1, this.token.image.length() - 1);
    }

    public final Boolean bool() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 103: 
            case 105: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 103: {
                        this.jj_consume_token(103);
                        break;
                    }
                    case 105: {
                        this.jj_consume_token(105);
                        break;
                    }
                    default: {
                        this.jj_la1[232] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return true;
            }
            case 104: 
            case 106: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 104: {
                        this.jj_consume_token(104);
                        break;
                    }
                    case 106: {
                        this.jj_consume_token(106);
                        break;
                    }
                    default: {
                        this.jj_la1[233] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return false;
            }
        }
        this.jj_la1[234] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int integer() throws ParseException {
        this.jj_consume_token(213);
        return Integer.parseInt(this.token.image);
    }

    public final long longValue() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 213: {
                this.jj_consume_token(213);
                return Long.parseLong(this.token.image);
            }
            case 214: {
                this.jj_consume_token(214);
                return Long.parseLong(this.token.image.substring(0, this.token.image.length() - 1));
            }
        }
        this.jj_la1[235] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final double floatValue() throws ParseException {
        this.jj_consume_token(212);
        return Double.valueOf(this.token.image);
    }

    public final Number number() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 212 -> this.floatValue();
            case 213, 214 -> this.longValue();
            default -> {
                this.jj_la1[236] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final void lbrace() throws ParseException {
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[237] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(5);
        }
        this.jj_consume_token(137);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[238] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_scanpos = this.token;
        this.jj_lastpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    private boolean jj_3R_164() {
        if (this.jj_3R_169()) {
            return true;
        }
        return this.jj_scan_token(139);
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(142)) {
            return true;
        }
        return this.jj_scan_token(219);
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(143)) {
            return true;
        }
        return this.jj_scan_token(219);
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(144)) {
            return true;
        }
        return this.jj_scan_token(219);
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_scan_token(219);
    }

    private boolean jj_3R_149() {
        return this.jj_3R_155();
    }

    private boolean jj_3_5() {
        return this.jj_scan_token(134);
    }

    private boolean jj_3_6() {
        return this.jj_scan_token(145);
    }

    private boolean jj_3R_138() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(109)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(124)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(6)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(7)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(160)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(142)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(29)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(82)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(79)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(101)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(98)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(99)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(49)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(204)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(211)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(83)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(81)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(121)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(10)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(16)) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_scan_token(167)) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_scan_token(168)) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_scan_token(169)) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_scan_token(170)) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_scan_token(71)) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_scan_token(113)) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_scan_token(106)) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_scan_token(24)) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_scan_token(25)) {
                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                            if (this.jj_scan_token(26)) {
                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                if (this.jj_scan_token(205)) {
                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                    if (this.jj_scan_token(114)) {
                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                        if (this.jj_scan_token(69)) {
                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                            if (this.jj_scan_token(87)) {
                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                if (this.jj_scan_token(41)) {
                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                    if (this.jj_scan_token(97)) {
                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                        if (this.jj_scan_token(165)) {
                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                            if (this.jj_scan_token(118)) {
                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                if (this.jj_scan_token(94)) {
                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                    if (this.jj_scan_token(207)) {
                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                        if (this.jj_scan_token(28)) {
                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                            if (this.jj_scan_token(36)) {
                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                if (this.jj_scan_token(30)) {
                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                    if (this.jj_scan_token(23)) {
                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                        if (this.jj_scan_token(159)) {
                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                            if (this.jj_scan_token(37)) {
                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                if (this.jj_scan_token(213)) {
                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                    if (this.jj_scan_token(112)) {
                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                        if (this.jj_scan_token(88)) {
                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                            if (this.jj_scan_token(214)) {
                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                if (this.jj_scan_token(14)) {
                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                    if (this.jj_scan_token(86)) {
                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                        if (this.jj_scan_token(158)) {
                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                            if (this.jj_scan_token(144)) {
                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                if (this.jj_scan_token(110)) {
                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                    if (this.jj_scan_token(63)) {
                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                        if (this.jj_scan_token(38)) {
                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                            if (this.jj_scan_token(130)) {
                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                if (this.jj_scan_token(64)) {
                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                    if (this.jj_scan_token(126)) {
                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                        if (this.jj_scan_token(102)) {
                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                            if (this.jj_scan_token(115)) {
                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                if (this.jj_scan_token(96)) {
                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                    if (this.jj_scan_token(104)) {
                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                        if (this.jj_scan_token(103)) {
                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                            if (this.jj_scan_token(17)) {
                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                if (this.jj_scan_token(152)) {
                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(131)) {
                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(61)) {
                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(46)) {
                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(90)) {
                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(78)) {
                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(93)) {
                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(65)) {
                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(111)) {
                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(85)) {
                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(145)) {
                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(8)) {
                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(9)) {
                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(91)) {
                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(62)) {
                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(80)) {
                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(119)) {
                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(74)) {
                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(75)) {
                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(76)) {
                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(77)) {
                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(51)) {
                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(70)) {
                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(95)) {
                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(89)) {
                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(15)) {
                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(215)) {
                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(22)) {
                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(47)) {
                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(48)) {
                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(68)) {
                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(107)) {
                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(92)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(39)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(120)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(72)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(105)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(35)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(84)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(100)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(206)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(221)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(53)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(34)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(143)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(40)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_128() {
        return this.jj_3R_137();
    }

    private boolean jj_3R_155() {
        return this.jj_3R_161();
    }

    private boolean jj_3R_150() {
        return this.jj_3R_156();
    }

    private boolean jj_3R_161() {
        Token xsp;
        if (this.jj_scan_token(232)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_165());
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_166());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(233);
    }

    private boolean jj_3R_166() {
        Token xsp;
        if (this.jj_scan_token(141)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(5));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_172()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_173()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_178() {
        return this.jj_3R_156();
    }

    private boolean jj_3R_135() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_143()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_144()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_145()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_146()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_147()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_143() {
        return this.jj_3R_153();
    }

    private boolean jj_3R_144() {
        return this.jj_scan_token(167);
    }

    private boolean jj_3R_145() {
        return this.jj_scan_token(169);
    }

    private boolean jj_3R_165() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_170()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_171()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_146() {
        return this.jj_scan_token(168);
    }

    private boolean jj_3R_170() {
        return this.jj_3R_178();
    }

    private boolean jj_3R_172() {
        return this.jj_3R_178();
    }

    private boolean jj_3R_147() {
        return this.jj_scan_token(170);
    }

    private boolean jj_3R_169() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_176()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_177()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_176() {
        return this.jj_3R_179();
    }

    private boolean jj_3R_177() {
        Token xsp;
        if (this.jj_scan_token(137)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_180());
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_181());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(138);
    }

    private boolean jj_3_8() {
        if (this.jj_scan_token(165)) {
            return true;
        }
        return this.jj_3R_124();
    }

    private boolean jj_3R_184() {
        return this.jj_3R_138();
    }

    private boolean jj_3R_125() {
        Token xsp;
        if (this.jj_3R_134()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_134());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_180() {
        return this.jj_3R_184();
    }

    private boolean jj_3R_134() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_139()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_140()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_141()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_142()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_139() {
        return this.jj_3R_151();
    }

    private boolean jj_3R_140() {
        return this.jj_scan_token(212);
    }

    private boolean jj_3_9() {
        if (this.jj_3R_125()) {
            return true;
        }
        if (this.jj_scan_token(139)) {
            return true;
        }
        if (this.jj_3R_125()) {
            return true;
        }
        return this.jj_scan_token(5);
    }

    private boolean jj_3R_141() {
        return this.jj_3R_152();
    }

    private boolean jj_3R_179() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_182()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_183()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_142() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(230)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(231)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(140)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(141)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_171() {
        return this.jj_3R_161();
    }

    private boolean jj_3R_173() {
        return this.jj_3R_161();
    }

    private boolean jj_3R_182() {
        return this.jj_3R_138();
    }

    private boolean jj_3_7() {
        return this.jj_3R_123();
    }

    private boolean jj_3R_123() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_129()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(139)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_130()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_131()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_132()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_133()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_183() {
        return this.jj_3R_152();
    }

    private boolean jj_3R_129() {
        return this.jj_3R_138();
    }

    private boolean jj_3R_181() {
        return this.jj_scan_token(141);
    }

    private boolean jj_3R_130() {
        return this.jj_scan_token(71);
    }

    private boolean jj_3R_153() {
        return this.jj_scan_token(134);
    }

    private boolean jj_3R_131() {
        return this.jj_scan_token(73);
    }

    private boolean jj_3R_132() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(69)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(70)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_133() {
        return this.jj_scan_token(72);
    }

    private boolean jj_3R_152() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(209)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(210)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_168() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_174()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_175()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_174() {
        return this.jj_scan_token(213);
    }

    private boolean jj_3R_175() {
        return this.jj_scan_token(214);
    }

    private boolean jj_3_10() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_126()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(139)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(5));
        xsp = this.jj_scanpos = xsp;
        if (this.jj_3R_127()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_128()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_167() {
        return this.jj_scan_token(212);
    }

    private boolean jj_3R_137() {
        if (this.jj_scan_token(205)) {
            return true;
        }
        if (this.jj_scan_token(139)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(216)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(215)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(207)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_156() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_162()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_163()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_162() {
        return this.jj_3R_167();
    }

    private boolean jj_3R_124() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(5));
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(137)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(5));
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_126() {
        return this.jj_3R_135();
    }

    private boolean jj_3R_151() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_157()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_158()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_157() {
        return this.jj_3R_138();
    }

    private boolean jj_3R_158() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(208)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(55)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(200)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(147)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(12)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(13)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(163)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(171)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(32)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(127)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(164)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(128)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(150)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(116)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(60)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(129)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(132)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(133)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(56)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(155)) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_scan_token(122)) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_scan_token(157)) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_scan_token(59)) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_scan_token(42)) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_scan_token(117)) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_scan_token(58)) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_scan_token(57)) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_scan_token(202)) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_scan_token(161)) {
                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                            if (this.jj_scan_token(73)) {
                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                if (this.jj_scan_token(149)) {
                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                    if (this.jj_scan_token(153)) {
                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                        if (this.jj_scan_token(154)) {
                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                            if (this.jj_scan_token(43)) {
                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                if (this.jj_scan_token(166)) {
                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                    if (this.jj_scan_token(11)) {
                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                        if (this.jj_scan_token(196)) {
                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                            if (this.jj_scan_token(173)) {
                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                if (this.jj_scan_token(172)) {
                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                    if (this.jj_scan_token(197)) {
                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                        if (this.jj_scan_token(195)) {
                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                            if (this.jj_scan_token(123)) {
                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                if (this.jj_scan_token(125)) {
                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                    if (this.jj_scan_token(19)) {
                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                        if (this.jj_scan_token(18)) {
                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                            if (this.jj_scan_token(50)) {
                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                if (this.jj_scan_token(20)) {
                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                    if (this.jj_scan_token(21)) {
                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                        if (this.jj_scan_token(199)) {
                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                            if (this.jj_scan_token(151)) {
                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                if (this.jj_scan_token(108)) {
                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                    if (this.jj_scan_token(66)) {
                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                        if (this.jj_scan_token(193)) {
                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                            if (this.jj_scan_token(203)) {
                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                if (this.jj_scan_token(33)) {
                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                    if (this.jj_scan_token(67)) {
                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                        if (this.jj_scan_token(148)) {
                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                            if (this.jj_scan_token(194)) {
                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                if (this.jj_scan_token(156)) {
                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                    if (this.jj_scan_token(54)) {
                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                        if (this.jj_scan_token(27)) {
                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                            if (this.jj_scan_token(31)) {
                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                if (this.jj_scan_token(201)) {
                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                    if (this.jj_scan_token(198)) {
                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                        if (this.jj_scan_token(162)) {
                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                            if (this.jj_scan_token(52)) {
                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_163() {
        return this.jj_3R_168();
    }

    private boolean jj_3R_127() {
        return this.jj_3R_136();
    }

    private boolean jj_3R_136() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_148()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_149()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_150()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_148() {
        return this.jj_3R_154();
    }

    private boolean jj_3R_154() {
        Token xsp;
        if (this.jj_scan_token(137)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_159());
        this.jj_scanpos = xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_160());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(138);
    }

    private boolean jj_3R_159() {
        return this.jj_3R_164();
    }

    private boolean jj_3R_160() {
        Token xsp;
        if (this.jj_scan_token(141)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_scan_token(5));
        this.jj_scanpos = xsp;
        return this.jj_3R_164();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{32, 66305, 768, 0x800000, 356581440, 32, 32, 356581440, 65536, 32, 2009319360, 32, 32, 0x800000, 32, 0x1400040, 32, 32, 32, 0x800000, 32, 0x1400040, 32, 0x1400040, 0, 0, 0, 0, -939524096, 32, 0, -64, 0x2000000, 32, 0x2000000, 32, 0x800000, 32, 0x800000, 0x1000000, 32, 32, 32, 0x800000, 0x1000000, 32, 0, 2009319360, 32, 0, 0, 32, -939524096, 32, -939524096, -939524096, 0, 2009319360, 0, 0, 32, 32, 0, 2009319360, 2009319360, 0, 32, 32, 0, 32, 32, 0, 0, 0, 2009319360, 0, 0, 0, 32, 2009319392, 2009319360, 0, 0, 0, 2009319360, 0, 32, 0, 0, 0, 0, 0, 0, 0, 32, 32, 0, -64, 2009319360, 0, 32, 32, 0, 0, 0, 32, 32, 0, 0x800000, 32, 32, 0, 0, 0, 32, 32, 2009319360, 0, 0, 32, 32, 0, 0, 32, 0, 0, 32, 0, 0, 0, 32, 0, 0, 0, 32, 32, 0, 0x800000, 33792, 32, 33792, 0, 0x3C0000, 0x3C0000, 32, 0, 0, 0, 0, 2009319360, 32, 0, 1024, 32, 0, 1024, 14336, 32, 14336, 32, 49152, 14336, 0, 32, 0, 0, 32, 0, 0, 32, 0, 32, 2009319360, 32, 0, 32, 0, 2009319360, 0, 0, 0, 0, 32, 0, 0, 32, 0, 0, 0, 32, -64, 0, -64, -64, 32, 32, 32, 2009319360, 32, 0, 32, 0, 0, 0, 2009319360, 0, 32, 0, 0, 32, 0, 2009319360, 0, 32, 32, 0, 0, 0, 0, 32, 0, 2009319360, 0, 2009319360, 32, 2009319360, 0, 0, -2009319424, -64, 2009319360, 0, 0, 0, 0, 0, 0, 32, 32};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, -2147090415, 0, 0, -2147090415, 0, 0, -534002692, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 22, 0, 0, -12289, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -534002692, 0, 0, 0, 0, 0, 0, 22, 0, 0, -534002692, 0, 0, 0, 0, 0, -534002692, -534002692, 0, 0, 0, 0, 0, 0, 0, 0, 0, -534002692, 0, 8, 0, 0, -534002692, -534002692, 0, 0, 8, -534002692, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -12289, -534002692, 131008, 0, 0, 115648, 131008, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16384, 0, 0, -534002692, 0, 16384, 0, 0, 16384, 0, 0, 0, 0, 0, 0x1E000000, 0x60000000, 0x1E000000, 0, 8, 8, 0, 0, 0, Integer.MIN_VALUE, 0, 19660838, 0, 19660838, 0, 0, 0, 0, 0, 0, 0, 0, -534002692, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -534002692, 0, 0, 0, 0, -534002692, 0, 0, 0, 0x100000, 0, 0, 0xC00000, 0, 0xC00000, 0, 0, 0, -12289, 0, -12289, -12289, 0, 0, 0, -534002692, 0, 0, 0, 0, 0, 0, -534002692, 0, 0, 8, 8, 0, 0, -534002692, 0, 0, 0, 0, 0, 0, 0, 0, 0, -534002692, 0, -534002692, 0, -534002692, 0, 0, 533990403, -12289, -534002692, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, -2147483636, 0, 0, -2147483636, 0, 0, -525, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2147254256, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -525, 0, 0, 0, 0, 32784, 0, -2147254256, 32784, 0, -525, 0, 0, 0, 0, 0, -525, -525, 65536, 0, 0, 59506688, 0, 0, 0x700000, 0x7C000000, 59506688, -525, 65536, 0, 992, 0, -525, -525, 96, 992, 0, -525, 992, 0, 992, 96, 992, 0, 0, 0, 0, 0, 0, 0, -1, -525, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 16, 0, 0, Integer.MIN_VALUE, 0, 0, -525, 0, Integer.MIN_VALUE, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0x800001, 0, 0x800001, 0, 0, 0, 0, 0, 0x800000, 0, 0, -525, 0, 0, 32768, 0, 786432, 32768, 32768, 0, 32768, 0, 0, 32768, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -525, 0, 0, 0, 0, -525, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, -1, -1, 0, 0, 0, -525, 0, 0, 0, 0, 0, 0, -525, 0, 0, 0, 0, 0, 0, -525, 0, 0, 0, 0, 0, 0, 0, 0, 0, -525, 0, -525, 0, -525, 0, 0, 524, -1, -525, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1406136319, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1536, 0, 0, 0, 4255777, 0, 0, -1, 20480, 0, 20480, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1406136319, 0, 0x400000, 16384, 0, 53248, 0, 4255777, 53248, 0, 1406136319, 0, 0, 0, 0, 0, 1406136319, 1406136319, -2147475456, 0, 0, 0, 0, 0, 0, 0, 0, 1406136319, -2147475456, 0, 25165856, 0, 1406136319, 1406136319, 0, 0, 0, 1406136319, 25165856, 0, 25165856, 0, 0, 0, 0x800000, 0, 30, 0, 0, 30, -1, 1406136319, 1179672, 0, 0, 131096, 1179672, 851968, 0, 0, 851968, 0, 0xC000000, 0xC000000, 0, 0, 8192, 0, 0, 1406136319, 0, 8192, 0, 0, 8192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x208000, 0, 0x208000, 0, 0, 0, 0, 0, 0, 0, 0, 1406136319, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1406136319, 0, 0, 0, 0, 1406136319, 0, 0, 1536, 0, 0, 1536, 0, 0, 0, 0, 0, 0, -1, 0, -1, -1, 0, 0, 0, 1406136319, 0, 0, 0, 0, 0, 0, 1406136319, 0, 0, 0, 0, 0, 0, 1406136319, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1406136319, 0, 1406136319, 0, 1406136319, 0, 0, -1406136320, -1, 1406136319, 0, 640, 1280, 1920, 0, 0, 0, 0};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1056718836, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 8192, 8192, 32768, 0, 8192, -278465, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1056718836, 0, 0, 0, 0, 0, 0, 32768, 0, 2048, -1056718836, 8192, 0x180000, 0, 2560, 0x180000, -1056718836, -1056718836, 63, 0, 2560, 0, 0, 2560, 0, 0, 0, -1056718836, 63, 0, 0, 0, -1056718324, -1056718836, 0, 0, 0, -1056718836, 0, 0, 0, 0, 0, 8192, 0, 8192, 0, 0, 2560, 0, -278465, -1056718836, 0, 0, 2560, 0, 0, 0, 0, 2560, 0, 0, 0, 0, 8192, 8192, 0, 0, 2560, -1056718836, 8192, 0, 0, 2560, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2015363072, 0, 2015363072, 8192, 0, 0, 0, 0, 0x40000000, 0, 8192, -1056718836, 0, Integer.MIN_VALUE, 0x7C00000, 0, 0, 0x7C00000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1056718836, 0, 64, 0, 2048, -1056718836, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -266177, 12288, -266177, -266177, 0, 2560, 0, -1056718836, 0, 64, 0, 512, 2560, 2560, -1056718836, 0, 0, 384, 384, 0, 512, -1056718324, 8192, 0, 0, 0, 0, 0, 8192, 0, 0, -1056718836, 8192, -1056718324, 0, -1056718836, 384, 0, 1056440371, -278465, -1056718836, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_5() {
        jj_la1_5 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1953, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16383, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1953, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1953, 0, 0, 0, 0, 0, 1953, 1953, 2048, 0, 0, 0, 0, 0, 0, 0, 0, 1953, 2048, 0, 0, 0, 1953, 1953, 0, 0, 0, 1953, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16383, 1953, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 1953, 0, 63, 0, 0, 63, 12352, 0, 32, 12352, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4177920, 0, 4177920, 0, 0, 0, 0, 0, 0, 0, 0, 1953, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0xC00000, 0, 0xC00000, 0xC00000, 0, 0xC00000, 0xC00000, 0, 0xC00000, 0, 1953, 0, 1920, 0, 0, 1953, 1920, 917504, 0, 0, 0, 0, 0, 0, 0, 114688, 0x300000, 0, 16383, 0, 16383, 16383, 0, 0, 0, 1953, 0, 1920, 0, 0, 0, 0, 1953, 0, 0, 0, 0, 0, 0, 1953, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1953, 0, 1953, 0, 1953, 0, 0xC00000, 14430, 16383, 1953, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_6() {
        jj_la1_6 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 552136704, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 552599550, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 552136704, 0, 0, 0, 0, 0, 0, 0, 0, 0, 552136704, 0, 0, 0, 0, 0, 552136704, 552136704, 0, 0, 0, 0, 0, 0, 0, 0, 0, 552136704, 0, 0, 0, 0, 552136704, 552136704, 0, 0, 0, 552136704, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 552599550, 552136704, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 552136704, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1073717248, 0, -1073717248, 0, 24576, 24576, 0x1808000, 0, 0, 0, 0, 5114, 0, 5114, 0, 0, 0, 0, 0, 0, 0, 0, 552136704, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3072, 0, 3072, 2052, 0, 2052, 4, 0, 4, 0, 552136704, 0, 0, 0, 0, 552136704, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 553648126, 0, 553648126, 553648126, 0, 0, 0, 552136704, 0, 0, 0, 0x702000, 0, 0, 552136704, 0x308000, 0, 0, 0, 0, 0x700000, 552529920, 0, 0, 0, 0x700000, 0x700000, 0x700000, 0, 0, 0x700000, 552136704, 0, 552529920, 0, 552529920, 0, 0, 69630, 552206334, 552136704, 393216, 0, 0, 0, 0x600000, 0x700000, 0, 0};
    }

    private static void jj_la1_init_7() {
        jj_la1_7 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192, 192, 192, 192, 0, 0, 0, 0, 0, 0, 0, 256, 0, 0, 0, 0, 0, 0, 0, 0, 256, 0, 0, 0, 0, 256, 256, 256, 0, 0, 256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public SchemaParser(CharStream stream) {
        int i;
        this.token_source = new SchemaParserTokenManager(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 239; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CharStream stream) {
        int i;
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 239; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SchemaParser(SchemaParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 239; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(SchemaParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 239; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            if (t.next == null) {
                t.next = this.token_source.getNextToken();
            }
            t = t.next;
        }
        return t;
    }

    private int jj_ntk_f() {
        int ret;
        this.jj_nt = this.token.next;
        Token nt = this.jj_nt;
        if (nt == null) {
            this.token.next = this.token_source.getNextToken();
            ret = this.jj_ntk = this.token.next.kind;
        } else {
            ret = this.jj_ntk = nt.kind;
        }
        return ret;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[234];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 239; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) != 0) {
                    la1tokens[128 + j] = true;
                }
                if ((jj_la1_5[i] & 1 << j) != 0) {
                    la1tokens[160 + j] = true;
                }
                if ((jj_la1_6[i] & 1 << j) != 0) {
                    la1tokens[192 + j] = true;
                }
                if ((jj_la1_7[i] & 1 << j) == 0) continue;
                la1tokens[224 + j] = true;
            }
        }
        for (i = 0; i < 234; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return false;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 10; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_scanpos = p.first;
                    this.jj_lastpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        SchemaParser.jj_la1_init_0();
        SchemaParser.jj_la1_init_1();
        SchemaParser.jj_la1_init_2();
        SchemaParser.jj_la1_init_3();
        SchemaParser.jj_la1_init_4();
        SchemaParser.jj_la1_init_5();
        SchemaParser.jj_la1_init_6();
        SchemaParser.jj_la1_init_7();
    }

    private static final class LookaheadSuccess
    extends IllegalStateException {
        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

