/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.parser;

import com.yahoo.schema.parser.ParsedBlock;
import com.yahoo.schema.parser.ParsedType;
import java.util.ArrayList;
import java.util.List;

public class ParsedSummaryField
extends ParsedBlock {
    private ParsedType type;
    private boolean isDyn = false;
    private boolean isMEO = false;
    private boolean isFull = false;
    private boolean isBold = false;
    private boolean isTokens = false;
    private boolean hasExplicitType = false;
    private final List<String> sources = new ArrayList<String>();
    private final List<String> destinations = new ArrayList<String>();

    public ParsedSummaryField(String name) {
        this(name, (ParsedType)null);
    }

    public ParsedSummaryField(String name, ParsedType type) {
        super(name, "summary field");
        this.type = type;
    }

    ParsedType getType() {
        return this.type;
    }

    List<String> getDestinations() {
        return List.copyOf(this.destinations);
    }

    List<String> getSources() {
        return List.copyOf(this.sources);
    }

    boolean getBolded() {
        return this.isBold;
    }

    boolean getDynamic() {
        return this.isDyn;
    }

    boolean getFull() {
        return this.isFull;
    }

    boolean getMatchedElementsOnly() {
        return this.isMEO;
    }

    boolean getTokens() {
        return this.isTokens;
    }

    boolean getHasExplicitType() {
        return this.hasExplicitType;
    }

    public void addDestination(String dst) {
        this.destinations.add(dst);
    }

    public void addSource(String src) {
        this.sources.add(src);
    }

    public void setBold(boolean value) {
        this.isBold = value;
    }

    public void setDynamic() {
        this.isDyn = true;
    }

    public void setFull() {
        this.isFull = true;
    }

    public void setMatchedElementsOnly() {
        this.isMEO = true;
    }

    public void setTokens() {
        this.isTokens = true;
    }

    public void setHasExplicitType() {
        this.hasExplicitType = true;
    }

    void setType(ParsedType value) {
        this.verifyThat(this.type == null, "Cannot change type from ", this.type, "to", value);
        this.type = value;
    }
}

