/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.parser;

import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ModelContext;
import com.yahoo.config.model.application.provider.BaseDeployLogger;
import com.yahoo.config.model.application.provider.MockFileRegistry;
import com.yahoo.config.model.deploy.TestProperties;
import com.yahoo.config.model.test.MockApplicationPackage;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.parser.ConvertParsedSchemas;
import com.yahoo.schema.parser.ConvertParsedTypes;
import com.yahoo.schema.parser.IntermediateCollection;
import com.yahoo.schema.parser.ParsedAnnotation;
import com.yahoo.schema.parser.ParsedDocument;
import com.yahoo.schema.parser.ParsedSchema;
import com.yahoo.schema.parser.ParsedStruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConvertSchemaCollection {
    private final IntermediateCollection input;
    private final List<ParsedSchema> orderedInput = new ArrayList<ParsedSchema>();
    private final DocumentTypeManager docMan;
    private final ApplicationPackage applicationPackage;
    private final FileRegistry fileRegistry;
    private final DeployLogger deployLogger;
    private final ModelContext.Properties properties;
    private final RankProfileRegistry rankProfileRegistry;
    private final boolean documentsOnly;
    private ConvertParsedTypes typeConverter;

    ConvertSchemaCollection(IntermediateCollection input, DocumentTypeManager documentTypeManager) {
        this(input, documentTypeManager, MockApplicationPackage.createEmpty(), (FileRegistry)new MockFileRegistry(), (DeployLogger)new BaseDeployLogger(), new TestProperties(), new RankProfileRegistry(), true);
    }

    public ConvertSchemaCollection(IntermediateCollection input, DocumentTypeManager documentTypeManager, ApplicationPackage applicationPackage, FileRegistry fileRegistry, DeployLogger deployLogger, ModelContext.Properties properties, RankProfileRegistry rankProfileRegistry, boolean documentsOnly) {
        this.input = input;
        this.docMan = documentTypeManager;
        this.applicationPackage = applicationPackage;
        this.fileRegistry = fileRegistry;
        this.deployLogger = deployLogger;
        this.properties = properties;
        this.rankProfileRegistry = rankProfileRegistry;
        this.documentsOnly = documentsOnly;
        input.resolveInternalConnections();
        this.order();
        this.pushTypesToDocuments();
    }

    void order() {
        Map<String, ParsedSchema> map = this.input.getParsedSchemas();
        for (ParsedSchema schema : map.values()) {
            this.findOrdering(schema);
        }
    }

    void findOrdering(ParsedSchema schema) {
        if (this.orderedInput.contains(schema)) {
            return;
        }
        for (ParsedSchema parent : schema.getAllResolvedInherits()) {
            this.findOrdering(parent);
        }
        this.orderedInput.add(schema);
    }

    void pushTypesToDocuments() {
        for (ParsedSchema schema : this.orderedInput) {
            for (ParsedStruct struct : schema.getStructs()) {
                schema.getDocument().addStruct(struct);
            }
            for (ParsedAnnotation annotation : schema.getAnnotations()) {
                schema.getDocument().addAnnotation(annotation);
            }
        }
    }

    public void convertTypes() {
        this.typeConverter = new ConvertParsedTypes(this.orderedInput, this.docMan);
        this.typeConverter.convert(true);
    }

    public List<Schema> convertToSchemas() {
        this.resolveStructInheritance();
        this.resolveAnnotationInheritance();
        this.addMissingAnnotationStructs();
        ConvertParsedSchemas converter = new ConvertParsedSchemas(this.orderedInput, this.docMan, this.applicationPackage, this.fileRegistry, this.deployLogger, this.properties, this.rankProfileRegistry, this.documentsOnly);
        return converter.convertToSchemas();
    }

    private void resolveStructInheritance() {
        ArrayList<ParsedStruct> all = new ArrayList<ParsedStruct>();
        for (ParsedSchema schema : this.orderedInput) {
            ParsedDocument doc = schema.getDocument();
            for (ParsedStruct struct : doc.getStructs()) {
                for (String inherit : struct.getInherited()) {
                    ParsedStruct parent = doc.findParsedStruct(inherit);
                    if (parent == null) {
                        throw new IllegalArgumentException("Can not find parent for " + struct + " in " + doc);
                    }
                    struct.resolveInherit(inherit, parent);
                }
                all.add(struct);
            }
        }
        ArrayList<String> seen = new ArrayList<String>();
        for (ParsedStruct struct : all) {
            this.inheritanceCycleCheck(struct, seen);
        }
    }

    private void resolveAnnotationInheritance() {
        ArrayList<ParsedAnnotation> all = new ArrayList<ParsedAnnotation>();
        for (ParsedSchema schema : this.orderedInput) {
            ParsedDocument doc = schema.getDocument();
            for (ParsedAnnotation annotation : doc.getAnnotations()) {
                for (String inherit : annotation.getInherited()) {
                    ParsedAnnotation parent = doc.findParsedAnnotation(inherit);
                    if (parent == null) {
                        throw new IllegalArgumentException("Can not find parent for " + annotation + " in " + doc);
                    }
                    annotation.resolveInherit(inherit, parent);
                }
                all.add(annotation);
            }
        }
        ArrayList<String> seen = new ArrayList<String>();
        for (ParsedAnnotation annotation : all) {
            this.inheritanceCycleCheck(annotation, seen);
        }
    }

    private void fixupAnnotationStruct(ParsedAnnotation parsed) {
        for (ParsedAnnotation parent : parsed.getResolvedInherits()) {
            this.fixupAnnotationStruct(parent);
            parent.getStruct().ifPresent(ps -> {
                ParsedStruct myStruct = parsed.ensureStruct();
                if (!myStruct.getInherited().contains(ps.name())) {
                    myStruct.inherit(ps.name());
                    myStruct.resolveInherit(ps.name(), (ParsedStruct)ps);
                }
            });
        }
    }

    private void addMissingAnnotationStructs() {
        for (ParsedSchema schema : this.orderedInput) {
            ParsedDocument doc = schema.getDocument();
            for (ParsedAnnotation annotation : doc.getAnnotations()) {
                this.fixupAnnotationStruct(annotation);
            }
        }
    }

    private void inheritanceCycleCheck(ParsedStruct struct, List<String> seen) {
        String name = struct.name();
        if (seen.contains(name)) {
            seen.add(name);
            throw new IllegalArgumentException("Inheritance/reference cycle for structs: " + String.join((CharSequence)" -> ", seen));
        }
        seen.add(name);
        for (ParsedStruct parent : struct.getResolvedInherits()) {
            this.inheritanceCycleCheck(parent, seen);
        }
        seen.remove(name);
    }

    private void inheritanceCycleCheck(ParsedAnnotation annotation, List<String> seen) {
        String name = annotation.name();
        if (seen.contains(name)) {
            seen.add(name);
            throw new IllegalArgumentException("Inheritance/reference cycle for annotations: " + String.join((CharSequence)" -> ", seen));
        }
        seen.add(name);
        for (ParsedAnnotation parent : annotation.getResolvedInherits()) {
            this.inheritanceCycleCheck(parent, seen);
        }
        seen.remove(name);
    }
}

