/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.expressiontransforms;

import com.yahoo.searchlib.rankingexpression.evaluation.BooleanValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.IfNode;
import com.yahoo.searchlib.rankingexpression.rule.OperationNode;
import com.yahoo.searchlib.rankingexpression.rule.Operator;
import com.yahoo.searchlib.rankingexpression.transform.ExpressionTransformer;
import com.yahoo.searchlib.rankingexpression.transform.TransformContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

public class BooleanExpressionTransformer
extends ExpressionTransformer<TransformContext> {
    public ExpressionNode transform(ExpressionNode node, TransformContext context) {
        if (node instanceof CompositeNode) {
            CompositeNode composite = (CompositeNode)node;
            node = this.transformChildren(composite, context);
        }
        if (node instanceof OperationNode) {
            OperationNode arithmetic = (OperationNode)node;
            node = this.transformBooleanArithmetics(arithmetic, context);
        }
        return node;
    }

    private ExpressionNode transformBooleanArithmetics(OperationNode node, TransformContext context) {
        Iterator child = node.children().iterator();
        ArrayDeque<ChildNode> stack = new ArrayDeque<ChildNode>();
        stack.push(new ChildNode(null, (ExpressionNode)child.next()));
        Iterator it = node.operators().iterator();
        while (it.hasNext() && child.hasNext()) {
            Operator op = (Operator)it.next();
            if (!stack.isEmpty()) {
                while (stack.size() > 1 && !op.hasPrecedenceOver(((ChildNode)stack.peek()).op)) {
                    this.popStack(stack, context);
                }
            }
            stack.push(new ChildNode(op, (ExpressionNode)child.next()));
        }
        while (stack.size() > 1) {
            this.popStack(stack, context);
        }
        return ((ChildNode)stack.getFirst()).child;
    }

    private void popStack(Deque<ChildNode> stack, TransformContext context) {
        OperationNode combination;
        ChildNode rhs = stack.pop();
        ChildNode lhs = stack.peek();
        if (rhs.op == Operator.and && this.isDefinitelyPrimitive(lhs.child, context) && this.isDefinitelyPrimitive(rhs.child, context)) {
            combination = this.andByIfNode(lhs.child, rhs.child);
        } else if (rhs.op == Operator.or && this.isDefinitelyPrimitive(lhs.child, context) && this.isDefinitelyPrimitive(rhs.child, context)) {
            combination = this.orByIfNode(lhs.child, rhs.child);
        } else {
            combination = BooleanExpressionTransformer.resolve(lhs, rhs);
            lhs.artificial = true;
        }
        lhs.child = combination;
    }

    private boolean isDefinitelyPrimitive(ExpressionNode node, TransformContext context) {
        try {
            return node.type(context.types()).rank() == 0;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static OperationNode resolve(ChildNode left, ChildNode right) {
        if (!(left.child instanceof OperationNode) && !(right.child instanceof OperationNode)) {
            return new OperationNode(left.child, right.op, right.child);
        }
        ArrayList<Operator> joinedOps = new ArrayList<Operator>();
        BooleanExpressionTransformer.joinOps(left, joinedOps);
        joinedOps.add(right.op);
        BooleanExpressionTransformer.joinOps(right, joinedOps);
        ArrayList<ExpressionNode> joinedChildren = new ArrayList<ExpressionNode>();
        BooleanExpressionTransformer.joinChildren(left, joinedChildren);
        BooleanExpressionTransformer.joinChildren(right, joinedChildren);
        return new OperationNode(joinedChildren, joinedOps);
    }

    private static void joinOps(ChildNode node, List<Operator> joinedOps) {
        ExpressionNode expressionNode;
        if (node.artificial && (expressionNode = node.child) instanceof OperationNode) {
            OperationNode operationNode = (OperationNode)expressionNode;
            joinedOps.addAll(operationNode.operators());
        }
    }

    private static void joinChildren(ChildNode node, List<ExpressionNode> joinedChildren) {
        ExpressionNode expressionNode;
        if (node.artificial && (expressionNode = node.child) instanceof OperationNode) {
            OperationNode operationNode = (OperationNode)expressionNode;
            joinedChildren.addAll(operationNode.children());
        } else {
            joinedChildren.add(node.child);
        }
    }

    private IfNode andByIfNode(ExpressionNode a, ExpressionNode b) {
        return new IfNode(a, b, (ExpressionNode)new ConstantNode((Value)new BooleanValue(false)));
    }

    private IfNode orByIfNode(ExpressionNode a, ExpressionNode b) {
        return new IfNode(a, (ExpressionNode)new ConstantNode((Value)new BooleanValue(true)), b);
    }

    private static class ChildNode {
        final Operator op;
        ExpressionNode child;
        boolean artificial;

        public ChildNode(Operator op, ExpressionNode child) {
            this.op = op;
            this.child = child;
        }

        public String toString() {
            return this.child.toString();
        }
    }
}

