/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.producer;

import com.yahoo.api.annotations.Beta;
import com.yahoo.config.model.ApplicationConfigProducerRoot;
import com.yahoo.config.model.producer.AbstractConfigProducerRoot;
import com.yahoo.config.model.producer.AnyConfigProducer;
import com.yahoo.vespa.model.Service;
import com.yahoo.vespa.model.SimpleConfigProducer;
import com.yahoo.vespa.model.utils.FreezableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class TreeConfigProducer<CHILD extends AnyConfigProducer>
extends AnyConfigProducer {
    private final List<Service> descendantServices = new ArrayList<Service>();
    private final FreezableMap<String, CHILD> childrenBySubId = new FreezableMap(LinkedHashMap.class);

    public TreeConfigProducer(TreeConfigProducer parent, String subId) {
        super(parent, subId);
    }

    public TreeConfigProducer(String subId) {
        super(subId);
    }

    private String errorMsgClassName() {
        if (this.getClass().equals(SimpleConfigProducer.class)) {
            return this.getParent().getClass().getSimpleName();
        }
        return this.getClass().getSimpleName();
    }

    protected void addChild(CHILD child) {
        if (child == null) {
            throw new IllegalArgumentException("Trying to add null child for: " + this);
        }
        if (child instanceof AbstractConfigProducerRoot) {
            throw new IllegalArgumentException("Child cannot be a root node: " + child);
        }
        ((AnyConfigProducer)child).setParent(this);
        if (this.childrenBySubId.get(((AnyConfigProducer)child).getSubId()) != null) {
            throw new IllegalArgumentException("Multiple services/instances of the id '" + ((AnyConfigProducer)child).getSubId() + "' under the service/instance " + this.errorMsgClassName() + " '" + this.getSubId() + "'. (This is commonly caused by service/node index collisions in the config.).\nExisting instance: " + this.childrenBySubId.get(((AnyConfigProducer)child).getSubId()) + "\nAttempted to add:  " + child + "\nStack trace: " + Arrays.toString(Thread.currentThread().getStackTrace()));
        }
        this.childrenBySubId.put(((AnyConfigProducer)child).getSubId(), child);
        if (child instanceof Service) {
            this.addDescendantService((Service)child);
        }
    }

    public void removeChild(CHILD child) {
        if (((AnyConfigProducer)child).getParent() != this) {
            throw new IllegalArgumentException("Could not remove " + child + ": Expected its parent to be " + this + ", but was " + ((AnyConfigProducer)child).getParent());
        }
        if (child instanceof Service) {
            this.descendantServices.remove(child);
        }
        this.childrenBySubId.remove(((AnyConfigProducer)child).getSubId());
        ((AnyConfigProducer)child).setParent(null);
    }

    public Map<String, CHILD> getChildren() {
        return Collections.unmodifiableMap(this.childrenBySubId);
    }

    @Override
    @Beta
    public <J extends AnyConfigProducer> List<J> getChildrenByTypeRecursive(Class<J> type) {
        ArrayList<AnyConfigProducer> validChildren = new ArrayList<AnyConfigProducer>();
        if (this.getClass().equals(type)) {
            validChildren.add((AnyConfigProducer)type.cast(this));
        }
        Map<String, CHILD> children = this.getChildren();
        for (AnyConfigProducer child : children.values()) {
            validChildren.addAll(child.getChildrenByTypeRecursive(type));
        }
        return Collections.unmodifiableList(validChildren);
    }

    @Override
    public List<Service> getDescendantServices() {
        return Collections.unmodifiableList(this.descendantServices);
    }

    protected void addDescendantService(Service s) {
        this.descendantServices.add(s);
    }

    @Override
    void setupConfigId(String parentConfigId) {
        super.setupConfigId(parentConfigId);
        this.setupChildConfigIds(this.getConfigIdPrefix());
    }

    String getConfigIdPrefix() {
        if (this instanceof AbstractConfigProducerRoot || this instanceof ApplicationConfigProducerRoot) {
            return "";
        }
        if (this.currentConfigId() == null) {
            return null;
        }
        return this.getConfigId() + "/";
    }

    @Override
    protected ClassLoader getConfigClassLoader(String producerName) {
        ClassLoader classLoader = TreeConfigProducer.findInheritedClassLoader(this.getClass(), producerName);
        if (classLoader != null) {
            return classLoader;
        }
        for (AnyConfigProducer child : this.childrenBySubId.values()) {
            ClassLoader loader = child.getConfigClassLoader(producerName);
            if (loader == null) continue;
            return loader;
        }
        return null;
    }

    private void setupChildConfigIds(String currentConfigId) {
        for (AnyConfigProducer child : this.childrenBySubId.values()) {
            child.setupConfigId(currentConfigId);
        }
    }

    @Override
    void aggregateDescendantServices() {
        for (AnyConfigProducer child : this.childrenBySubId.values()) {
            child.aggregateDescendantServices();
            this.descendantServices.addAll(child.getDescendantServices());
        }
    }

    @Override
    void freeze() {
        this.childrenBySubId.freeze();
        for (AnyConfigProducer child : this.childrenBySubId.values()) {
            child.freeze();
        }
    }

    @Override
    public void validate() throws Exception {
        assert (this.childrenBySubId.isFrozen());
        for (AnyConfigProducer child : this.childrenBySubId.values()) {
            child.validate();
        }
    }
}

