/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.cluster;

import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.content.IndexedHierarchicDistributionValidator;
import com.yahoo.vespa.model.content.Redundancy;

public class RedundancyBuilder {
    private Integer initialRedundancy = null;
    private Integer finalRedundancy = null;
    private Integer readyCopies = null;
    private Integer globalMinRedundancy = null;

    RedundancyBuilder(ModelElement clusterXml) {
        ModelElement minRedundancyElement;
        ModelElement redundancyElement = clusterXml.child("redundancy");
        if (redundancyElement != null) {
            this.initialRedundancy = redundancyElement.integerAttribute("reply-after");
            this.finalRedundancy = (int)redundancyElement.asLong();
            if (this.initialRedundancy == null) {
                this.initialRedundancy = this.finalRedundancy;
            } else if (this.finalRedundancy < this.initialRedundancy) {
                throw new IllegalArgumentException("Final redundancy must be higher than or equal to initial redundancy");
            }
            this.readyCopies = clusterXml.childAsInteger("engine.proton.searchable-copies");
            if (this.readyCopies != null && this.readyCopies > this.finalRedundancy) {
                throw new IllegalArgumentException("Number of searchable copies can not be higher than final redundancy");
            }
        }
        if ((minRedundancyElement = clusterXml.child("min-redundancy")) != null) {
            this.globalMinRedundancy = (int)minRedundancyElement.asLong();
        }
        if (redundancyElement == null && minRedundancyElement == null) {
            throw new IllegalArgumentException("Either <redundancy> or <min-redundancy> must be set");
        }
    }

    public Redundancy build(boolean isHosted, int subGroups, int leafGroups, int totalNodes) {
        if (isHosted) {
            if (this.globalMinRedundancy != null && (this.finalRedundancy == null || this.finalRedundancy * leafGroups < this.globalMinRedundancy)) {
                this.initialRedundancy = this.finalRedundancy = Integer.valueOf((int)Math.ceil((double)this.globalMinRedundancy.intValue() / (double)leafGroups));
            }
            if (this.readyCopies == null) {
                this.readyCopies = leafGroups > 1 ? Integer.valueOf(1) : Integer.valueOf(this.finalRedundancy > 1 ? 2 : 1);
            }
            return new Redundancy(this.initialRedundancy, this.finalRedundancy, this.readyCopies, leafGroups, totalNodes);
        }
        if (this.globalMinRedundancy != null && (this.finalRedundancy == null || this.finalRedundancy < this.globalMinRedundancy)) {
            this.initialRedundancy = this.finalRedundancy = this.globalMinRedundancy;
        }
        if (this.readyCopies == null) {
            this.readyCopies = this.finalRedundancy > 1 ? Math.max(subGroups, 2) : 1;
        }
        subGroups = Math.max(1, subGroups);
        IndexedHierarchicDistributionValidator.validateThatLeafGroupsCountIsAFactorOfRedundancy(this.finalRedundancy, subGroups);
        IndexedHierarchicDistributionValidator.validateThatReadyCopiesIsCompatibleWithRedundancy(this.finalRedundancy, this.readyCopies, subGroups);
        if (this.initialRedundancy == null) {
            this.initialRedundancy = this.finalRedundancy;
        }
        return new Redundancy(this.initialRedundancy / subGroups, this.finalRedundancy / subGroups, this.readyCopies / subGroups, subGroups, totalNodes);
    }
}

