/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.binaryprefix.BinaryPrefix;
import com.yahoo.binaryprefix.BinaryScaledAmount;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BinaryScaledAmountParser {
    private static final Pattern pattern = Pattern.compile("(\\d+(\\.\\d*)?)\\s*([kmgKMG])?");

    public static BinaryScaledAmount parse(String valueString) {
        Matcher matcher = pattern.matcher(valueString);
        if (!matcher.matches()) {
            throw new RuntimeException("Pattern and schema is out of sync.");
        }
        double amount = Double.valueOf(matcher.group(1));
        String binaryPrefixString = matcher.group(3);
        return new BinaryScaledAmount(amount, BinaryScaledAmountParser.asBinaryPrefix(binaryPrefixString));
    }

    private static BinaryPrefix asBinaryPrefix(String binaryPrefixString) {
        if (binaryPrefixString == null) {
            return BinaryPrefix.unit;
        }
        return BinaryPrefix.fromSymbol((char)binaryPrefixString.toUpperCase().charAt(0));
    }
}

