/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin;

import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.TreeConfigProducer;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.PortAllocBridge;
import java.util.Optional;

public class Logserver
extends AbstractService {
    private static final long serialVersionUID = 1L;
    private static final String logArchiveDir = "$ROOT/logs/vespa/logarchive";
    private String compressionType = "gzip";

    public Logserver(TreeConfigProducer<? super Logserver> parent) {
        super(parent, "logserver");
        this.portsMeta.on(0).tag("logtp").tag("rpc");
        this.portsMeta.on(1).tag("unused");
        this.portsMeta.on(2).tag("unused");
        this.portsMeta.on(3).tag("unused");
        this.setProp("clustertype", "admin");
        this.setProp("clustername", "admin");
    }

    @Override
    public void initService(DeployState deployState) {
        super.initService(deployState);
        this.compressionType = deployState.featureFlags().logFileCompressionAlgorithm("gzip");
    }

    @Override
    public Optional<String> getStartupCommand() {
        return Optional.of("exec $ROOT/bin/vespa-logserver-start " + this.getMyJVMArgs() + " " + this.getJvmOptions());
    }

    private String getMyJVMArgs() {
        StringBuilder sb = new StringBuilder();
        sb.append("--add-opens=java.base/java.io=ALL-UNNAMED");
        sb.append(" ");
        sb.append("-Dlogserver.rpcListenPort=").append(this.getRelativePort(0));
        sb.append(" ");
        sb.append("-Dlogserver.logarchive.dir=$ROOT/logs/vespa/logarchive");
        sb.append(" ");
        sb.append("-Dlogserver.logarchive.compression=" + this.compressionType);
        return sb.toString();
    }

    @Override
    public int getWantedPort() {
        return 19080;
    }

    @Override
    public boolean requiresWantedPort() {
        return true;
    }

    @Override
    public int getPortCount() {
        return 4;
    }

    @Override
    public void allocatePorts(int start, PortAllocBridge from) {
        int port = start == 0 ? this.getWantedPort() : start;
        from.requirePort(port++, "rpc");
        from.requirePort(port++, "unused/1");
        from.requirePort(port++, "unused/2");
        from.requirePort(port++, "unused/3");
    }
}

