/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.MatchType;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.indexinglanguage.ExpressionVisitor;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.IndexExpression;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.HashMap;
import java.util.Map;

public class MatchConsistency
extends Processor {
    public MatchConsistency(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        if (!validate) {
            return;
        }
        HashMap<String, MatchType> types = new HashMap<String, MatchType>();
        for (SDField field : this.schema.allConcreteFields()) {
            new MyVisitor(this.schema, field, types).visit((Expression)field.getIndexingScript());
        }
    }

    private void checkMatching(Schema schema, SDField field, Map<String, MatchType> types, String indexTo) {
        MatchType prevType = types.get(indexTo);
        if (prevType == null) {
            types.put(indexTo, field.getMatching().getType());
        } else if (!field.getMatching().getType().equals((Object)prevType)) {
            this.warn(schema, field, "The matching type for index '" + indexTo + "' (got " + field.getMatching().getType() + ") is inconsistent with that given for the same index in a previous field (had " + prevType + ").");
        }
    }

    private class MyVisitor
    extends ExpressionVisitor {
        final Schema schema;
        final SDField field;
        final Map<String, MatchType> types;

        MyVisitor(Schema schema, SDField field, Map<String, MatchType> types) {
            this.schema = schema;
            this.field = field;
            this.types = types;
        }

        protected void doVisit(Expression exp) {
            if (exp instanceof IndexExpression) {
                MatchConsistency.this.checkMatching(this.schema, this.field, this.types, ((IndexExpression)exp).getFieldName());
            }
        }
    }
}

