/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.Field;
import com.yahoo.schema.RankProfileRegistry;
import com.yahoo.schema.Schema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.ImmutableSDField;
import com.yahoo.schema.document.SDDocumentType;
import com.yahoo.schema.document.SDField;
import com.yahoo.schema.processing.DynamicSummaryTransformUtils;
import com.yahoo.schema.processing.Processor;
import com.yahoo.vespa.documentmodel.DocumentSummary;
import com.yahoo.vespa.documentmodel.SummaryField;
import com.yahoo.vespa.documentmodel.SummaryTransform;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class AddExtraFieldsToDocument
extends Processor {
    AddExtraFieldsToDocument(Schema schema, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(schema, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate, boolean documentsOnly) {
        SDDocumentType document = this.schema.getDocument();
        if (document != null) {
            for (SDField field : this.schema.extraFieldList()) {
                this.addSdField(this.schema, document, field, validate);
            }
            for (DocumentSummary docsum : this.schema.getSummaries().values()) {
                for (SummaryField summaryField : docsum.getSummaryFields().values()) {
                    SummaryTransform transform = summaryField.getTransform();
                    if ((!transform.isDynamic() || !DynamicSummaryTransformUtils.summaryFieldIsRequiredInDocumentType(summaryField)) && transform != SummaryTransform.NONE && transform != SummaryTransform.DOCUMENT_ID) continue;
                    this.addSummaryField(this.schema, document, summaryField, validate);
                }
            }
        }
    }

    private void addSdField(Schema schema, SDDocumentType document, SDField field, boolean validate) {
        if (!field.hasIndex() && field.getAttributes().isEmpty()) {
            return;
        }
        for (Attribute atr : field.getAttributes().values()) {
            if (atr.getName().equals(field.getName())) continue;
            this.addField(schema, document, new SDField(document, atr.getName(), atr.getDataType()), validate);
        }
        this.addField(schema, document, field, validate);
    }

    private void addSummaryField(Schema schema, SDDocumentType document, SummaryField field, boolean validate) {
        Field docField = document.getField(field.getName());
        if (docField == null) {
            ImmutableSDField existingField = schema.getField(field.getName());
            if (existingField == null) {
                SDField newField = new SDField(document, field.getName(), field.getDataType());
                newField.setIsExtraField(true);
                document.addField(newField);
            } else if (!existingField.isImportedField()) {
                document.addField(existingField.asField());
            }
        } else if (!docField.getDataType().equals((Object)field.getDataType()) && validate) {
            throw this.newProcessException(schema, field, "Summary field has conflicting type.");
        }
    }

    private void addField(Schema schema, SDDocumentType document, Field field, boolean validate) {
        if (document.getField(field.getName()) != null && document.getField(field.getName()) != field && validate) {
            throw this.newProcessException(schema, field, "Field shadows another.");
        }
        document.addField(field);
    }
}

